/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.uml2.diagram.sequence.internal.layout.model;

import java.awt.Point;
import org.eclipse.uml2.diagram.sequence.internal.layout.abstractgde.AbsLink;
import org.eclipse.uml2.diagram.sequence.internal.layout.model.LMMessage;
import org.eclipse.uml2.diagram.sequence.internal.layout.model.LMMessageEnd;
import org.eclipse.uml2.diagram.sequence.internal.layout.model.LMReceiveMessageEnd;
import org.eclipse.uml2.diagram.sequence.internal.layout.model.LMSendMessageEnd;
import org.eclipse.uml2.diagram.sequence.internal.layout.model.MessageLabelLayouter;
import org.eclipse.uml2.diagram.sequence.internal.layout.vertical.input.LifeLineElement;
import org.eclipse.uml2.diagram.sequence.internal.layout.vertical.input.OrderingConstraint;

public class LMSelfMessage
extends LMMessage {
    private final boolean myIsFromSendToReceive;
    private final boolean myIsAsynchronous;
    private LMReceiveMessageEnd myReceiveMessageEnd;
    private LMSendMessageEnd mySendMessageEnd;
    private LMMessageEnd.VerticalConstraintedPositioning mySendVerticalPositioning;
    private LMMessageEnd.VerticalConstraintedPositioning myReceiveVerticalPositioning;
    private LMSendMessageEnd.HorizontalPositioning mySendHorizontalPositioning;
    private LMReceiveMessageEnd.HorizontalPositioning myReceiveHorizontalPositioning;
    private OrderingConstraint myOrderingConstraint = null;
    private boolean myIsVerticalConstraintViolated;

    LMSelfMessage(AbsLink gdeLink, boolean isFromSendToReceive, boolean isAsynchronous) {
        super(gdeLink);
        this.myIsFromSendToReceive = isFromSendToReceive;
        this.myIsAsynchronous = isAsynchronous;
    }

    boolean isFromSendToReceive() {
        return this.myIsFromSendToReceive;
    }

    boolean isAsynchronous() {
        return this.myIsAsynchronous;
    }

    public void layoutHorizontally(boolean fullLayout) {
        Point[] newPoints = this.getHorizontalLayout(fullLayout);
        this.getGdeLink().setLinkPoints(newPoints);
        int startXPos = newPoints[0].x;
        MessageLabelLayouter.layoutMessageLabelsHorizontally(this.getGdeLink(), startXPos, startXPos + 1, fullLayout);
    }

    public Point[] getHorizontalLayout(boolean fullLayout) {
        int startXPos = this.mySendHorizontalPositioning.getSendEndXPos(true);
        int endXPos = this.myReceiveHorizontalPositioning.getReceiveEndXPos(true);
        if (!this.isFromSendToReceive()) {
            int t = startXPos;
            startXPos = endXPos;
            endXPos = t;
        }
        Point[] linkPoints = this.getGdeLink().getLinkPoints();
        Point[] newPoints = new Point[]{this.getPointFromArray(linkPoints, 0), this.getPointFromArray(linkPoints, 1), this.getPointFromArray(linkPoints, -2), this.getPointFromArray(linkPoints, -1)};
        int xPosMin = (startXPos > endXPos ? startXPos : endXPos) + 20;
        if (this.isFromSendToReceive()) {
            xPosMin -= 3;
        }
        int xPosMax = xPosMin + 30;
        int middleSegmentX = fullLayout ? 0 : this.getPointFromArray((Point[])linkPoints, (int)1).x;
        if (middleSegmentX < xPosMin) {
            middleSegmentX = xPosMin;
        }
        if (middleSegmentX > xPosMax) {
            middleSegmentX = xPosMax;
        }
        newPoints[0].x = startXPos;
        newPoints[1].x = middleSegmentX;
        newPoints[2].x = middleSegmentX;
        newPoints[3].x = endXPos;
        return newPoints;
    }

    void setLMMessageEndVerticalPosition(int pos, boolean sourceNotDestination, int siblingNumber) {
        Point[] linkPoints = this.getGdeLink().getLinkPoints();
        Point[] newPoints = new Point[]{this.getPointFromArray(linkPoints, 0), this.getPointFromArray(linkPoints, 1), this.getPointFromArray(linkPoints, -2), this.getPointFromArray(linkPoints, -1)};
        boolean changeSourceNotDestinaction = sourceNotDestination ^ !this.isFromSendToReceive();
        if (this.myIsAsynchronous) {
            int slopeSign;
            int n = slopeSign = this.isFromSendToReceive() ? 1 : -1;
            if (changeSourceNotDestinaction) {
                newPoints[0].y = pos;
                newPoints[1].y = pos + slopeSign * 5;
            } else {
                newPoints[2].y = pos - slopeSign * 5;
                newPoints[3].y = pos;
            }
        } else if (changeSourceNotDestinaction) {
            newPoints[0].y = pos;
            newPoints[1].y = pos;
        } else {
            newPoints[2].y = pos;
            newPoints[3].y = pos;
        }
        this.getGdeLink().setLinkPoints(newPoints);
        if (sourceNotDestination) {
            MessageLabelLayouter.layoutMessageLabelsVertically(this.getGdeLink(), pos);
        }
    }

    private Point getPointFromArray(Point[] points, int index) {
        Point foundPoint;
        if (points == null || points.length == 0) {
            return new Point();
        }
        if (index >= 0) {
            int halfIndex = (points.length - 1) / 2;
            if (index > halfIndex) {
                index = halfIndex;
            }
            foundPoint = points[index];
        } else {
            int halfIndex = points.length / 2;
            if ((index = points.length + index) < halfIndex) {
                index = halfIndex;
            }
            foundPoint = points[index];
        }
        if (foundPoint == null) {
            return new Point();
        }
        return new Point(foundPoint);
    }

    LMSendMessageEnd getSendMessageEnd() {
        return this.mySendMessageEnd;
    }

    LMReceiveMessageEnd getReceiveMessageEnd() {
        return this.myReceiveMessageEnd;
    }

    protected void setSendMessageEnd(LMSendMessageEnd sendMessageEnd, LMMessageEnd.VerticalConstraintedPositioning sendVerticalPositioning, LMSendMessageEnd.HorizontalPositioning sendHorizontalPositioning) {
        this.mySendMessageEnd = sendMessageEnd;
        this.mySendVerticalPositioning = sendVerticalPositioning;
        this.mySendHorizontalPositioning = sendHorizontalPositioning;
        this.sourceOrDestinationChanged();
    }

    protected void setReceiveMessageEnd(LMReceiveMessageEnd receiveMessageEnd, LMMessageEnd.VerticalConstraintedPositioning receiveVerticalPositioning, LMReceiveMessageEnd.HorizontalPositioning receiveHorizontalPositioning) {
        this.myReceiveMessageEnd = receiveMessageEnd;
        this.myReceiveVerticalPositioning = receiveVerticalPositioning;
        this.myReceiveHorizontalPositioning = receiveHorizontalPositioning;
        this.sourceOrDestinationChanged();
    }

    void resetSendMessageEnd() {
        this.mySendMessageEnd = null;
        this.mySendVerticalPositioning = null;
        this.mySendHorizontalPositioning = null;
        this.sourceOrDestinationChanged();
    }

    void resetReceiveMessageEnd() {
        this.myReceiveMessageEnd = null;
        this.myReceiveVerticalPositioning = null;
        this.myReceiveHorizontalPositioning = null;
        this.sourceOrDestinationChanged();
    }

    void becomeLayoutConstraint(boolean on) {
        if (!this.myIsAsynchronous || !this.myIsFromSendToReceive) {
            return;
        }
        final LMMessageEnd.ConnectableLifeLineElement sendElement = this.mySendVerticalPositioning.getTopLifeLineElement();
        final LMMessageEnd.ConnectableLifeLineElement receiveElement = this.myReceiveVerticalPositioning.getTopLifeLineElement();
        if (on) {
            this.myOrderingConstraint = new OrderingConstraint(){

                public LifeLineElement getBeforeElement() {
                    return sendElement;
                }

                public LifeLineElement getAfterElement() {
                    return receiveElement;
                }

                public void setInvalid(boolean invalid) {
                    LMSelfMessage.this.setVerticalConstraintViolationState(invalid);
                }

                public int getMinSlopeValue() {
                    return 15;
                }
            };
            sendElement.addAfterConstraint(this.myOrderingConstraint);
            receiveElement.addBeforeConstraint(this.myOrderingConstraint);
        } else {
            sendElement.removeAfterConstraint(this.myOrderingConstraint);
            receiveElement.removeBeforeConstraint(this.myOrderingConstraint);
            this.myOrderingConstraint = null;
        }
    }

    boolean isLayoutConstraint() {
        return this.myOrderingConstraint != null;
    }

    protected boolean calculateIsMessageViolated() {
        return this.myIsVerticalConstraintViolated || super.calculateIsMessageViolated();
    }

    protected void setVerticalConstraintViolationState(boolean violated) {
        this.myIsVerticalConstraintViolated = violated;
        this.updateMessageViolationState();
    }
}

