/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.uml2.diagram.common.part;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.StringTokenizer;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.uml2.uml.UMLPackage;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UMLModelWizardInitialObjectCreationPage
extends WizardPage {
    protected List<EClass> initialObjectNames;
    protected UMLPackage umlPackage = UMLPackage.eINSTANCE;
    protected Combo initialObjectField;
    protected List<String> encodings;
    protected Combo encodingField;
    private final EClass baseClass;
    protected ModifyListener validator = new ModifyListener(){

        public void modifyText(ModifyEvent e) {
            UMLModelWizardInitialObjectCreationPage.this.setPageComplete(UMLModelWizardInitialObjectCreationPage.this.validatePage());
        }
    };

    public UMLModelWizardInitialObjectCreationPage(String pageId, EClass bc) {
        super(pageId);
        this.baseClass = bc;
    }

    public void createControl(Composite parent) {
        Composite composite = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 1;
        layout.verticalSpacing = 12;
        composite.setLayout((Layout)layout);
        GridData data = new GridData();
        data.verticalAlignment = 4;
        data.grabExcessVerticalSpace = true;
        data.horizontalAlignment = 4;
        composite.setLayoutData((Object)data);
        Label containerLabel = new Label(composite, 16384);
        containerLabel.setText("Model Object");
        data = new GridData();
        data.horizontalAlignment = 4;
        containerLabel.setLayoutData((Object)data);
        this.initialObjectField = new Combo(composite, 2048);
        data = new GridData();
        data.horizontalAlignment = 4;
        data.grabExcessHorizontalSpace = true;
        this.initialObjectField.setLayoutData((Object)data);
        for (EClass object : this.getInitialObjectTypes()) {
            this.initialObjectField.add(this.getLabel(object));
        }
        if (this.initialObjectField.getItemCount() > 0) {
            this.initialObjectField.select(0);
        }
        this.initialObjectField.addModifyListener(this.validator);
        Label encodingLabel = new Label(composite, 16384);
        encodingLabel.setText("XML Encoding");
        GridData data2 = new GridData();
        data2.horizontalAlignment = 4;
        encodingLabel.setLayoutData((Object)data2);
        this.encodingField = new Combo(composite, 2048);
        data2 = new GridData();
        data2.horizontalAlignment = 4;
        data2.grabExcessHorizontalSpace = true;
        this.encodingField.setLayoutData((Object)data2);
        for (String encoding : this.getEncodings()) {
            this.encodingField.add(encoding);
        }
        this.encodingField.select(0);
        this.encodingField.addModifyListener(this.validator);
        this.setPageComplete(this.validatePage());
        this.setControl((Control)composite);
    }

    protected boolean validatePage() {
        return this.getInitialObject() != null && this.getEncodings().contains(this.encodingField.getText());
    }

    public void setVisible(boolean visible) {
        super.setVisible(visible);
        if (visible) {
            if (this.initialObjectField.getItemCount() == 1) {
                this.initialObjectField.clearSelection();
                this.encodingField.setFocus();
            } else {
                this.encodingField.clearSelection();
                this.initialObjectField.setFocus();
            }
        }
    }

    public EClass getInitialObject() {
        String label = this.initialObjectField.getText();
        for (EClass next : this.getInitialObjectTypes()) {
            if (!this.getLabel(next).equals(label)) continue;
            return next;
        }
        return null;
    }

    public String getEncoding() {
        return this.encodingField.getText();
    }

    protected String getLabel(EClass type) {
        return type.getName();
    }

    protected Collection<String> getEncodings() {
        if (this.encodings == null) {
            this.encodings = new ArrayList<String>();
            StringTokenizer stringTokenizer = new StringTokenizer(" UTF-8 ASCII UTF-16 UTF-16BE UTF-16LE ISO-8859-1");
            while (stringTokenizer.hasMoreTokens()) {
                this.encodings.add(stringTokenizer.nextToken());
            }
        }
        return this.encodings;
    }

    private Collection<EClass> getInitialObjectTypes() {
        if (this.initialObjectNames == null) {
            this.initialObjectNames = this.createInitialObjectTypes();
        }
        return this.initialObjectNames;
    }

    protected List<EClass> createInitialObjectTypes() {
        return Collections.unmodifiableList(this.getAllSubTypes(this.baseClass));
    }

    private List<EClass> getAllSubTypes(EClass baseClass) {
        ArrayList<EClass> result = new ArrayList<EClass>();
        TreeIterator contents = this.umlPackage.eAllContents();
        result.add(baseClass);
        while (contents.hasNext()) {
            EClass eclass;
            EObject next = (EObject)contents.next();
            if (!(next instanceof EClass) || (eclass = (EClass)next).isAbstract() || !baseClass.isSuperTypeOf(eclass) || eclass.equals(baseClass)) continue;
            result.add(eclass);
        }
        return result;
    }
}

