/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.uml2.diagram.common.parser.slot;

import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.uml2.diagram.parser.AbstractToString;
import org.eclipse.uml2.diagram.parser.ExternalToString;
import org.eclipse.uml2.uml.Expression;
import org.eclipse.uml2.uml.LiteralInteger;
import org.eclipse.uml2.uml.LiteralString;
import org.eclipse.uml2.uml.NamedElement;
import org.eclipse.uml2.uml.Slot;
import org.eclipse.uml2.uml.StructuralFeature;
import org.eclipse.uml2.uml.UMLPackage;
import org.eclipse.uml2.uml.ValueSpecification;

public abstract class SlotToString
extends AbstractToString {
    public String getToString(EObject object, int flags) {
        Slot slot = this.asSlot(object);
        StringBuffer result = new StringBuffer();
        this.appendFeatureName(result, slot);
        this.appendSlotValue(result, slot);
        return result.toString();
    }

    protected void appendFeatureName(StringBuffer result, Slot slot) {
        StructuralFeature feature = slot.getDefiningFeature();
        this.appendName(result, (NamedElement)feature);
    }

    protected void appendSlotValue(StringBuffer result, Slot slot) {
        for (ValueSpecification next : slot.getValues()) {
            String nextDisplayValue = this.getSlotValue(next);
            if (SlotToString.isEmpty((String)nextDisplayValue)) continue;
            result.append(" = ").append(nextDisplayValue);
            break;
        }
    }

    protected String getSlotValue(ValueSpecification value) {
        if (value instanceof LiteralString) {
            LiteralString literal = (LiteralString)value;
            return "\"" + literal.getValue() + "\"";
        }
        if (value instanceof LiteralInteger) {
            LiteralInteger literal = (LiteralInteger)value;
            return String.valueOf(literal.getValue());
        }
        if (value instanceof Expression) {
            Expression expression = (Expression)value;
            return expression.getSymbol();
        }
        return null;
    }

    protected Slot asSlot(EObject object) {
        if (!(object instanceof Slot)) {
            throw new IllegalStateException("I can not provide toString for: " + object);
        }
        return (Slot)object;
    }

    public static class EDIT
    extends SlotToString {
        public boolean isAffectingFeature(EStructuralFeature feature) {
            throw new UnsupportedOperationException("I am edit toString, I am not expected to be asked");
        }
    }

    public static class VIEW
    extends SlotToString
    implements ExternalToString.WithReferences {
        private static final List AFFECTING = Arrays.asList(UMLPackage.eINSTANCE.getSlot_Value(), UMLPackage.eINSTANCE.getSlot_DefiningFeature(), UMLPackage.eINSTANCE.getExpression_Symbol(), UMLPackage.eINSTANCE.getLiteralString_Value(), UMLPackage.eINSTANCE.getLiteralInteger_Value());

        public boolean isAffectingFeature(EStructuralFeature feature) {
            return AFFECTING.contains(feature);
        }

        public List getAdditionalReferencedElements(EObject object) {
            Slot slot = this.asSlot(object);
            LinkedList<Object> result = new LinkedList<Object>();
            result.add(slot);
            StructuralFeature definingFeature = slot.getDefiningFeature();
            if (definingFeature != null) {
                result.add(definingFeature);
            }
            result.addAll((Collection<Object>)slot.getValues());
            return result;
        }
    }
}

