/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.types.util;

import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.ocl.types.AnyType;
import org.eclipse.ocl.types.BagType;
import org.eclipse.ocl.types.CollectionType;
import org.eclipse.ocl.types.ElementType;
import org.eclipse.ocl.types.InvalidType;
import org.eclipse.ocl.types.MessageType;
import org.eclipse.ocl.types.OrderedSetType;
import org.eclipse.ocl.types.PrimitiveType;
import org.eclipse.ocl.types.SequenceType;
import org.eclipse.ocl.types.SetType;
import org.eclipse.ocl.types.TupleType;
import org.eclipse.ocl.types.TypeType;
import org.eclipse.ocl.types.TypesPackage;
import org.eclipse.ocl.types.VoidType;
import org.eclipse.ocl.utilities.ASTNode;
import org.eclipse.ocl.utilities.PredefinedType;
import org.eclipse.ocl.utilities.TypedASTNode;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TypesSwitch<T> {
    protected static TypesPackage modelPackage;

    public TypesSwitch() {
        if (modelPackage == null) {
            modelPackage = TypesPackage.eINSTANCE;
        }
    }

    public T doSwitch(EObject theEObject) {
        return this.doSwitch(theEObject.eClass(), theEObject);
    }

    protected T doSwitch(EClass theEClass, EObject theEObject) {
        if (theEClass.eContainer() == modelPackage) {
            return this.doSwitch(theEClass.getClassifierID(), theEObject);
        }
        T result = this.doSwitchSuperTypes(theEClass, theEObject);
        if (result == null) {
            result = this.defaultCase(theEObject);
        }
        return result;
    }

    protected T doSwitchSuperTypes(EClass theEClass, EObject theEObject) {
        if (theEClass.eContainer() == modelPackage) {
            return this.doSwitch(theEClass.getClassifierID(), theEObject);
        }
        for (EClass esuper : theEClass.getESuperTypes()) {
            T result = this.doSwitchSuperTypes(esuper, theEObject);
            if (result == null) continue;
            return result;
        }
        return null;
    }

    protected T doSwitch(int classifierID, EObject theEObject) {
        switch (classifierID) {
            case 0: {
                AnyType anyType = (AnyType)theEObject;
                T result = this.caseAnyType(anyType);
                if (result == null) {
                    result = this.casePredefinedType(anyType);
                }
                if (result == null) {
                    result = this.defaultCase(theEObject);
                }
                return result;
            }
            case 1: {
                BagType bagType = (BagType)theEObject;
                T result = this.caseBagType(bagType);
                if (result == null) {
                    result = this.caseCollectionType(bagType);
                }
                if (result == null) {
                    result = this.casePredefinedType(bagType);
                }
                if (result == null) {
                    result = this.caseTypedASTNode(bagType);
                }
                if (result == null) {
                    result = this.caseASTNode(bagType);
                }
                if (result == null) {
                    result = this.defaultCase(theEObject);
                }
                return result;
            }
            case 2: {
                CollectionType collectionType = (CollectionType)theEObject;
                T result = this.caseCollectionType(collectionType);
                if (result == null) {
                    result = this.casePredefinedType(collectionType);
                }
                if (result == null) {
                    result = this.caseTypedASTNode(collectionType);
                }
                if (result == null) {
                    result = this.caseASTNode(collectionType);
                }
                if (result == null) {
                    result = this.defaultCase(theEObject);
                }
                return result;
            }
            case 3: {
                ElementType elementType = (ElementType)theEObject;
                T result = this.caseElementType(elementType);
                if (result == null) {
                    result = this.defaultCase(theEObject);
                }
                return result;
            }
            case 4: {
                InvalidType invalidType = (InvalidType)theEObject;
                T result = this.caseInvalidType(invalidType);
                if (result == null) {
                    result = this.casePredefinedType(invalidType);
                }
                if (result == null) {
                    result = this.defaultCase(theEObject);
                }
                return result;
            }
            case 5: {
                MessageType messageType = (MessageType)theEObject;
                T result = this.caseMessageType(messageType);
                if (result == null) {
                    result = this.casePredefinedType(messageType);
                }
                if (result == null) {
                    result = this.defaultCase(theEObject);
                }
                return result;
            }
            case 6: {
                OrderedSetType orderedSetType = (OrderedSetType)theEObject;
                T result = this.caseOrderedSetType(orderedSetType);
                if (result == null) {
                    result = this.caseCollectionType(orderedSetType);
                }
                if (result == null) {
                    result = this.casePredefinedType(orderedSetType);
                }
                if (result == null) {
                    result = this.caseTypedASTNode(orderedSetType);
                }
                if (result == null) {
                    result = this.caseASTNode(orderedSetType);
                }
                if (result == null) {
                    result = this.defaultCase(theEObject);
                }
                return result;
            }
            case 7: {
                PrimitiveType primitiveType = (PrimitiveType)theEObject;
                T result = this.casePrimitiveType(primitiveType);
                if (result == null) {
                    result = this.casePredefinedType(primitiveType);
                }
                if (result == null) {
                    result = this.defaultCase(theEObject);
                }
                return result;
            }
            case 8: {
                SequenceType sequenceType = (SequenceType)theEObject;
                T result = this.caseSequenceType(sequenceType);
                if (result == null) {
                    result = this.caseCollectionType(sequenceType);
                }
                if (result == null) {
                    result = this.casePredefinedType(sequenceType);
                }
                if (result == null) {
                    result = this.caseTypedASTNode(sequenceType);
                }
                if (result == null) {
                    result = this.caseASTNode(sequenceType);
                }
                if (result == null) {
                    result = this.defaultCase(theEObject);
                }
                return result;
            }
            case 9: {
                SetType setType = (SetType)theEObject;
                T result = this.caseSetType(setType);
                if (result == null) {
                    result = this.caseCollectionType(setType);
                }
                if (result == null) {
                    result = this.casePredefinedType(setType);
                }
                if (result == null) {
                    result = this.caseTypedASTNode(setType);
                }
                if (result == null) {
                    result = this.caseASTNode(setType);
                }
                if (result == null) {
                    result = this.defaultCase(theEObject);
                }
                return result;
            }
            case 10: {
                TupleType tupleType = (TupleType)theEObject;
                T result = this.caseTupleType(tupleType);
                if (result == null) {
                    result = this.casePredefinedType(tupleType);
                }
                if (result == null) {
                    result = this.defaultCase(theEObject);
                }
                return result;
            }
            case 11: {
                TypeType typeType = (TypeType)theEObject;
                T result = this.caseTypeType(typeType);
                if (result == null) {
                    result = this.casePredefinedType(typeType);
                }
                if (result == null) {
                    result = this.defaultCase(theEObject);
                }
                return result;
            }
            case 12: {
                VoidType voidType = (VoidType)theEObject;
                T result = this.caseVoidType(voidType);
                if (result == null) {
                    result = this.casePredefinedType(voidType);
                }
                if (result == null) {
                    result = this.defaultCase(theEObject);
                }
                return result;
            }
        }
        return this.defaultCase(theEObject);
    }

    public <O> T caseAnyType(AnyType<O> object) {
        return null;
    }

    public <C, O> T caseBagType(BagType<C, O> object) {
        return null;
    }

    public <C, O> T caseCollectionType(CollectionType<C, O> object) {
        return null;
    }

    public T caseElementType(ElementType object) {
        return null;
    }

    public <O> T caseInvalidType(InvalidType<O> object) {
        return null;
    }

    public <C, O, P> T caseMessageType(MessageType<C, O, P> object) {
        return null;
    }

    public <C, O> T caseOrderedSetType(OrderedSetType<C, O> object) {
        return null;
    }

    public <O> T casePrimitiveType(PrimitiveType<O> object) {
        return null;
    }

    public <C, O> T caseSequenceType(SequenceType<C, O> object) {
        return null;
    }

    public <C, O> T caseSetType(SetType<C, O> object) {
        return null;
    }

    public <O, P> T caseTupleType(TupleType<O, P> object) {
        return null;
    }

    public <C, O> T caseTypeType(TypeType<C, O> object) {
        return null;
    }

    public <O> T caseVoidType(VoidType<O> object) {
        return null;
    }

    public <O> T casePredefinedType(PredefinedType<O> object) {
        return null;
    }

    public T caseASTNode(ASTNode object) {
        return null;
    }

    public T caseTypedASTNode(TypedASTNode object) {
        return null;
    }

    public T defaultCase(EObject object) {
        return null;
    }
}

