/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.tasks.ui.editors;

import org.apache.commons.lang.StringUtils;
import org.eclipse.jface.dialogs.IInputValidator;
import org.eclipse.mylyn.internal.tasks.ui.editors.Messages;
import org.eclipse.mylyn.internal.tasks.ui.editors.TextAttributeEditor;
import org.eclipse.mylyn.tasks.core.data.TaskAttribute;
import org.eclipse.mylyn.tasks.core.data.TaskDataModel;
import org.eclipse.mylyn.tasks.ui.editors.AttributeEditorToolkit;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.forms.widgets.FormToolkit;

public class DoubleAttributeEditor
extends TextAttributeEditor {
    public DoubleAttributeEditor(TaskDataModel manager, TaskAttribute taskAttribute) {
        super(manager, taskAttribute);
    }

    @Override
    public void createControl(Composite parent, FormToolkit toolkit) {
        super.createControl(parent, toolkit);
        AttributeEditorToolkit.createValidator(this, (Control)this.getText(), this.getAttributeTypeValidator());
    }

    IInputValidator getAttributeTypeValidator() {
        return new IInputValidator(){

            public String isValid(String newText) {
                if (StringUtils.isNotBlank((String)newText)) {
                    try {
                        Double.parseDouble(newText);
                    }
                    catch (NumberFormatException e) {
                        return Messages.DoubleAttributeEditor_this_field_requires_double_value;
                    }
                }
                return null;
            }
        };
    }
}

