/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.net4j.util.security;

import java.io.IOException;
import java.math.BigInteger;
import java.security.AlgorithmParameterGenerator;
import java.security.AlgorithmParameters;
import java.security.GeneralSecurityException;
import java.security.Key;
import java.security.KeyFactory;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.spec.X509EncodedKeySpec;
import javax.crypto.Cipher;
import javax.crypto.KeyAgreement;
import javax.crypto.interfaces.DHPublicKey;
import javax.crypto.spec.DHParameterSpec;
import javax.crypto.spec.SecretKeySpec;
import org.eclipse.net4j.util.io.ExtendedDataInput;
import org.eclipse.net4j.util.io.ExtendedDataOutput;
import org.eclipse.net4j.util.io.IORuntimeException;

public class DiffieHellman {

    public static class Client {
        public Response handleChallenge(Server.Challenge challenge, byte[] clearText) {
            try {
                KeyFactory keyFactory = KeyFactory.getInstance("DH");
                X509EncodedKeySpec x509KeySpec = new X509EncodedKeySpec(challenge.getServerPubKeyEnc());
                PublicKey pubKey = keyFactory.generatePublic(x509KeySpec);
                DHParameterSpec dhParamSpec = ((DHPublicKey)pubKey).getParams();
                KeyPairGenerator keyPairGenerator = KeyPairGenerator.getInstance("DH");
                keyPairGenerator.initialize(dhParamSpec);
                KeyPair keyPair = keyPairGenerator.generateKeyPair();
                KeyAgreement clientKeyAgree = KeyAgreement.getInstance("DH");
                clientKeyAgree.init(keyPair.getPrivate());
                byte[] pubKeyEnc = keyPair.getPublic().getEncoded();
                clientKeyAgree.doPhase(pubKey, true);
                byte[] sharedSecret = clientKeyAgree.generateSecret();
                SecretKeySpec secretKeySpec = new SecretKeySpec(sharedSecret, 0, challenge.getSecretAlgorithmKeyLen(), challenge.getSecretAlgorithm());
                Cipher clientCipher = Cipher.getInstance(challenge.getCipherTransformation());
                clientCipher.init(1, secretKeySpec);
                byte[] ciphertext = clientCipher.doFinal(clearText);
                AlgorithmParameters params = clientCipher.getParameters();
                byte[] paramsEnc = params == null ? null : params.getEncoded();
                return new Response(pubKeyEnc, ciphertext, paramsEnc);
            }
            catch (GeneralSecurityException ex) {
                throw new SecurityException(ex);
            }
            catch (IOException ex) {
                throw new IORuntimeException(ex);
            }
        }

        public static final class Response {
            private final byte[] clientPubKeyEnc;
            private final byte[] cipherText;
            private final byte[] paramsEnc;

            public Response(byte[] clientPubKeyEnc, byte[] cipherText, byte[] paramsEnc) {
                this.clientPubKeyEnc = clientPubKeyEnc;
                this.cipherText = cipherText;
                this.paramsEnc = paramsEnc;
            }

            public Response(ExtendedDataInput in) throws IOException {
                this.clientPubKeyEnc = in.readByteArray();
                this.cipherText = in.readByteArray();
                this.paramsEnc = in.readByteArray();
            }

            public void write(ExtendedDataOutput out) throws IOException {
                out.writeByteArray(this.clientPubKeyEnc);
                out.writeByteArray(this.cipherText);
                out.writeByteArray(this.paramsEnc);
            }

            public byte[] getClientPubKeyEnc() {
                return this.clientPubKeyEnc;
            }

            public byte[] getCipherText() {
                return this.cipherText;
            }

            public byte[] getParamsEnc() {
                return this.paramsEnc;
            }
        }
    }

    public static final class ParameterSpecGenerator {
        public static DHParameterSpec generate(int bits) {
            try {
                AlgorithmParameterGenerator paramGen = AlgorithmParameterGenerator.getInstance("DH");
                paramGen.init(bits);
                AlgorithmParameters params = paramGen.generateParameters();
                return params.getParameterSpec(DHParameterSpec.class);
            }
            catch (GeneralSecurityException ex) {
                throw new SecurityException(ex);
            }
        }
    }

    public static class Server {
        @Deprecated
        public static final String DEFAULT_SECRET_ALGORITHM = "DES";
        @Deprecated
        public static final String DEFAULT_CYPHER_TRANSFORMATION = "DES/CBC/PKCS5Padding";
        private static final int DIFFIE_HELLMAN_KEY_SIZE = 2048;
        private static final int UNKNOWN_SECRET_ALGORITHM_KEY_LEN = -1;
        private static final String SECRET_ALGORITHM = "AES";
        private static final String CIPHER_TRANSFORMATION = "AES/CBC/PKCS5Padding";
        private final String realm;
        private final PrivateKey privateKey;
        private final Challenge challenge;

        public Server(String realm, KeyPairGenerator keyPairGenerator, int secretAlgorithmKeyLen, String secretAlgorithm, String cipherTransformation) {
            this.realm = realm;
            KeyPair keyPair = keyPairGenerator.generateKeyPair();
            this.privateKey = keyPair.getPrivate();
            this.challenge = new Challenge(realm, secretAlgorithmKeyLen, secretAlgorithm, cipherTransformation, keyPair);
        }

        public Server(String realm, int diffieHellmanKeySize, int secretAlgorithmKeyLen, String secretAlgorithm, String cipherTransformation) {
            this(realm, Server.createKeyPairGenerator(diffieHellmanKeySize), secretAlgorithmKeyLen, secretAlgorithm, cipherTransformation);
        }

        public Server(String realm, int diffieHellmanKeySize, String secretAlgorithm, String cipherTransformation) {
            this(realm, Server.createKeyPairGenerator(diffieHellmanKeySize), -1, secretAlgorithm, cipherTransformation);
        }

        public Server(String realm, int diffieHellmanKeySize) {
            this(realm, diffieHellmanKeySize, SECRET_ALGORITHM, CIPHER_TRANSFORMATION);
        }

        public Server(String realm) {
            this(realm, 2048);
        }

        public Server(String realm, DHParameterSpec dhParamSpec, int secretAlgorithmKeyLen, String secretAlgorithm, String cipherTransformation) {
            this(realm, Server.createKeyPairGenerator(dhParamSpec), secretAlgorithmKeyLen, secretAlgorithm, cipherTransformation);
        }

        public Server(String realm, DHParameterSpec dhParamSpec, String secretAlgorithm, String cipherTransformation) {
            this(realm, Server.createKeyPairGenerator(dhParamSpec), -1, secretAlgorithm, cipherTransformation);
        }

        public Server(String realm, DHParameterSpec dhParamSpec) {
            this(realm, dhParamSpec, SECRET_ALGORITHM, CIPHER_TRANSFORMATION);
        }

        public final String getRealm() {
            return this.realm;
        }

        public final Challenge getChallenge() {
            return this.challenge;
        }

        public byte[] handleResponse(Client.Response response) {
            try {
                KeyFactory keyFactory = KeyFactory.getInstance("DH");
                X509EncodedKeySpec x509KeySpec = new X509EncodedKeySpec(response.getClientPubKeyEnc());
                PublicKey pubKey = keyFactory.generatePublic(x509KeySpec);
                KeyAgreement keyAgree = KeyAgreement.getInstance("DH");
                keyAgree.init(this.privateKey);
                keyAgree.doPhase(pubKey, true);
                byte[] sharedSecret = keyAgree.generateSecret();
                SecretKeySpec secretKeySpec = new SecretKeySpec(sharedSecret, 0, this.challenge.getSecretAlgorithmKeyLen(), this.challenge.getSecretAlgorithm());
                Cipher serverCipher = Cipher.getInstance(this.challenge.getCipherTransformation());
                byte[] encodedParams = response.getParamsEnc();
                if (encodedParams == null) {
                    serverCipher.init(2, secretKeySpec);
                } else {
                    AlgorithmParameters params = AlgorithmParameters.getInstance(this.challenge.getSecretAlgorithm());
                    params.init(encodedParams);
                    serverCipher.init(2, (Key)secretKeySpec, params);
                }
                return serverCipher.doFinal(response.getCipherText());
            }
            catch (GeneralSecurityException ex) {
                throw new SecurityException(ex);
            }
            catch (IOException ex) {
                throw new IORuntimeException(ex);
            }
        }

        private static final KeyPairGenerator createKeyPairGenerator(int keySize) {
            try {
                KeyPairGenerator keyPairGenerator = KeyPairGenerator.getInstance("DH");
                keyPairGenerator.initialize(keySize);
                return keyPairGenerator;
            }
            catch (GeneralSecurityException ex) {
                throw new SecurityException(ex);
            }
        }

        private static final KeyPairGenerator createKeyPairGenerator(DHParameterSpec dhParamSpec) {
            try {
                KeyPairGenerator keyPairGenerator = KeyPairGenerator.getInstance("DH");
                keyPairGenerator.initialize(dhParamSpec);
                return keyPairGenerator;
            }
            catch (GeneralSecurityException ex) {
                throw new SecurityException(ex);
            }
        }

        private static final int determineSecretAlgorithmKeyLen(String secretAlgorithm, String cipherTransformation, KeyPair keyPair) {
            byte[] secret;
            try {
                KeyAgreement keyAgree = KeyAgreement.getInstance("DH");
                keyAgree.init(keyPair.getPrivate());
                keyAgree.doPhase(keyPair.getPublic(), true);
                secret = keyAgree.generateSecret();
            }
            catch (GeneralSecurityException ex) {
                throw new SecurityException(ex);
            }
            int keyLen = secret.length;
            while (keyLen > 0) {
                SecretKeySpec secretKeySpec = new SecretKeySpec(secret, 0, keyLen, secretAlgorithm);
                try {
                    Cipher clientCipher = Cipher.getInstance(cipherTransformation);
                    clientCipher.init(1, secretKeySpec);
                    return keyLen;
                }
                catch (GeneralSecurityException generalSecurityException) {
                    --keyLen;
                }
            }
            throw new SecurityException("Key length could not be determined for " + secretAlgorithm + " [" + cipherTransformation + "]");
        }

        public static final class Challenge {
            private final String serverRealm;
            private final int secretAlgorithmKeyLen;
            private final String secretAlgorithm;
            private final String cipherTransformation;
            private final byte[] serverPubKeyEnc;

            private Challenge(String serverRealm, int secretAlgorithmKeyLen, String secretAlgorithm, String cipherTransformation, KeyPair keyPair) {
                this.serverRealm = serverRealm;
                this.secretAlgorithmKeyLen = secretAlgorithmKeyLen == -1 ? Server.determineSecretAlgorithmKeyLen(secretAlgorithm, cipherTransformation, keyPair) : secretAlgorithmKeyLen;
                this.secretAlgorithm = secretAlgorithm;
                this.cipherTransformation = cipherTransformation;
                this.serverPubKeyEnc = keyPair.getPublic().getEncoded();
            }

            @Deprecated
            public Challenge(String serverRealm, String secretAlgorithm, String cipherTransformation, byte[] serverPubKeyEnc) {
                throw new UnsupportedOperationException();
            }

            public Challenge(ExtendedDataInput in) throws IOException {
                this.serverRealm = in.readString();
                this.secretAlgorithmKeyLen = in.readInt();
                this.secretAlgorithm = in.readString();
                this.cipherTransformation = in.readString();
                this.serverPubKeyEnc = in.readByteArray();
            }

            public void write(ExtendedDataOutput out) throws IOException {
                out.writeString(this.serverRealm);
                out.writeInt(this.secretAlgorithmKeyLen);
                out.writeString(this.secretAlgorithm);
                out.writeString(this.cipherTransformation);
                out.writeByteArray(this.serverPubKeyEnc);
            }

            public String getServerRealm() {
                return this.serverRealm;
            }

            public int getSecretAlgorithmKeyLen() {
                return this.secretAlgorithmKeyLen;
            }

            public String getSecretAlgorithm() {
                return this.secretAlgorithm;
            }

            public String getCipherTransformation() {
                return this.cipherTransformation;
            }

            @Deprecated
            public String getCypherTransformation() {
                return this.cipherTransformation;
            }

            public byte[] getServerPubKeyEnc() {
                return this.serverPubKeyEnc;
            }
        }
    }

    public static final class SkipParameterSpec {
        private static final byte[] modulusBytes = new byte[]{-12, -120, -3, 88, 78, 73, -37, -51, 32, -76, -99, -28, -111, 7, 54, 107, 51, 108, 56, 13, 69, 29, 15, 124, -120, -77, 28, 124, 91, 45, -114, -10, -13, -55, 35, -64, 67, -16, -91, 91, 24, -115, -114, -69, 85, -116, -72, 93, 56, -45, 52, -3, 124, 23, 87, 67, -93, 29, 24, 108, -34, 51, 33, 44, -75, 42, -1, 60, -31, -79, 41, 64, 24, 17, -115, 124, -124, -89, 10, 114, -42, -122, -60, 3, 25, -56, 7, 41, 122, -54, -107, 12, -39, -106, -97, -85, -48, 10, 80, -101, 2, 70, -45, 8, 61, 102, -92, 93, 65, -97, -100, 124, -67, -119, 75, 34, 25, 38, -70, -85, -94, 94, -61, 85, -23, 47, 120, -57};
        private static final BigInteger modulus = new BigInteger(1, modulusBytes);
        private static final BigInteger base = BigInteger.valueOf(2L);
        public static final DHParameterSpec INSTANCE = new DHParameterSpec(modulus, base);
    }
}

