/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.properties.widgets;

import java.util.Collections;
import org.eclipse.emf.ecore.EModelElement;
import org.eclipse.gef.EditPart;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.papyrus.infra.properties.ui.modelelement.DataSource;
import org.eclipse.papyrus.infra.properties.ui.modelelement.DataSourceChangedEvent;
import org.eclipse.papyrus.infra.properties.ui.modelelement.IDataSourceListener;
import org.eclipse.papyrus.infra.properties.ui.modelelement.ModelElement;
import org.eclipse.papyrus.infra.properties.ui.widgets.AbstractPropertyEditor;
import org.eclipse.papyrus.infra.widgets.editors.AbstractEditor;
import org.eclipse.papyrus.uml.profile.tree.objects.StereotypedElementTreeObject;
import org.eclipse.papyrus.uml.properties.modelelement.UMLNotationModelElement;
import org.eclipse.papyrus.uml.properties.profile.ui.compositeforview.AppearanceForAppliedStereotypeComposite;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.uml2.uml.Element;

public class StereotypeDisplay
extends AbstractPropertyEditor {
    private AppearanceForAppliedStereotypeComposite composite;
    private IDataSourceListener dataSourceListener;

    public StereotypeDisplay(Composite parent, int style) {
        this.composite = new AppearanceForAppliedStereotypeComposite(parent);
        this.composite.createContent(parent, AbstractEditor.factory);
    }

    protected void doBinding() {
        ModelElement element = this.input.getModelElement(this.propertyPath);
        if (element instanceof UMLNotationModelElement) {
            View diagramElement = (View)((UMLNotationModelElement)element).getEModelElement();
            EditPart editPart = ((UMLNotationModelElement)element).getEditPart();
            Element umlElement = (Element)diagramElement.getElement();
            this.composite.setSelection((ISelection)new StructuredSelection(Collections.singletonList(editPart)));
            this.composite.setElement(umlElement);
            this.composite.setInput(new StereotypedElementTreeObject(umlElement));
            this.composite.setDiagramElement((EModelElement)diagramElement);
            this.composite.refresh();
        }
    }

    protected void unhookDataSourceListener(DataSource oldInput) {
        oldInput.removeDataSourceListener(this.getDataSourceListener());
        super.unhookDataSourceListener(oldInput);
    }

    protected void hookDataSourceListener(DataSource newInput) {
        super.hookDataSourceListener(newInput);
        newInput.addDataSourceListener(this.getDataSourceListener());
    }

    private IDataSourceListener getDataSourceListener() {
        if (this.dataSourceListener == null) {
            this.dataSourceListener = new IDataSourceListener(){

                public void dataSourceChanged(DataSourceChangedEvent event) {
                    if (StereotypeDisplay.this.composite != null && !StereotypeDisplay.this.composite.isDisposed()) {
                        StereotypeDisplay.this.composite.getDisplay().asyncExec(new Runnable(){

                            @Override
                            public void run() {
                                if (!(this).StereotypeDisplay.this.composite.isDisposed()) {
                                    StereotypeDisplay.this.doBinding();
                                }
                            }
                        });
                    }
                }
            };
        }
        return this.dataSourceListener;
    }
}

