/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.emf.facet.util.pde.core.internal.exported;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Array;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.jar.JarOutputStream;
import java.util.zip.ZipOutputStream;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Platform;
import org.eclipse.papyrus.emf.facet.util.pde.core.internal.Activator;
import org.eclipse.papyrus.emf.facet.util.pde.core.internal.exported.exception.PdeCoreUtilsException;
import org.eclipse.papyrus.emf.facet.util.pde.core.internal.exported.exception.ReflexiveDiscouragedAccessException;
import org.osgi.framework.Bundle;
import org.osgi.framework.Version;

public final class TargetPlatformUtils {
    private static final String BUNDLE_SEPARATOR = ",";
    private static final String JAR_EXT = ".jar";
    private static final String JAR_DIRECTORY = "jarFiles";
    private static final int BUFFER_SIZE = 4096;
    private static final String BUNDLE_PREFIX = "reference:file:";
    private static final String FRAMEWORK_PREFIX = "file:";
    private static final String OSGI_PROP = "osgi.bundles";
    private static final String OSGI_PROP_FRK = "osgi.framework";
    private static final String ARRAY_PREFIX = "[L";

    private TargetPlatformUtils() {
    }

    public static void loadTargetPlatform() throws PdeCoreUtilsException {
        String copyDirectoryPath;
        try {
            Object targetPlServ = TargetPlatformUtils.reflexiveCall(true, "org.eclipse.pde.internal.core.target.TargetPlatformService", "getDefault", null);
            Object targetDefinition = TargetPlatformUtils.reflexiveCall(false, targetPlServ, "newTarget", null);
            copyDirectoryPath = Activator.getDefault().getStateLocation() + File.separator + JAR_DIRECTORY;
            File copyDirectory = new File(copyDirectoryPath);
            copyDirectory.mkdirs();
            List<String> dirPaths = TargetPlatformUtils.parseBundlesList();
            Object[] dirContainers = TargetPlatformUtils.copyJarsAndGetContainers(dirPaths, copyDirectory);
            TargetPlatformUtils.reflexiveCall(false, targetDefinition, TargetPlatformUtils.getContainerSetterName(), new Object[]{dirContainers});
            TargetPlatformUtils.reflexiveCall(false, targetDefinition, "resolve", new Object[]{new NullProgressMonitor()});
            TargetPlatformUtils.reflexiveCall(true, TargetPlatformUtils.getLoadTargetDefinitionJobQualifiedName(), "load", new Object[]{targetDefinition});
            TargetPlatformUtils.reflexiveCall(false, targetPlServ, "saveTargetDefinition", new Object[]{targetDefinition});
        }
        catch (Exception e) {
            throw new PdeCoreUtilsException(e);
        }
        new File(copyDirectoryPath).delete();
    }

    private static boolean isHigherVersion() {
        Version version = new Version(3, 7, 1);
        Bundle bundle = Platform.getBundle((String)"org.eclipse.pde.core");
        Version currentVersion = bundle.getVersion();
        return currentVersion.compareTo(version) > 0;
    }

    private static String getLoadTargetDefinitionJobQualifiedName() {
        String lTDefJobName = TargetPlatformUtils.isHigherVersion() ? "org.eclipse.pde.core.target.LoadTargetDefinitionJob" : "org.eclipse.pde.internal.core.target.provisional.LoadTargetDefinitionJob";
        return lTDefJobName;
    }

    private static String getContainerSetterName() {
        String setterName = TargetPlatformUtils.isHigherVersion() ? "setTargetLocations" : "setBundleContainers";
        return setterName;
    }

    private static List<String> parseBundlesList() throws PdeCoreUtilsException, IOException {
        LinkedList<String> result = new LinkedList<String>();
        String bundlesFromConfig = System.getProperty(OSGI_PROP);
        String frwkFromConfig = System.getProperty(OSGI_PROP_FRK);
        if (bundlesFromConfig != null && !"".equals(bundlesFromConfig)) {
            String[] bundlesStr = bundlesFromConfig.split(BUNDLE_SEPARATOR);
            result.addAll(TargetPlatformUtils.trimPaths(bundlesStr, BUNDLE_PREFIX));
        }
        if (frwkFromConfig != null && !"".equals(frwkFromConfig)) {
            String[] frameworkStr = frwkFromConfig.split(BUNDLE_SEPARATOR);
            result.addAll(TargetPlatformUtils.trimPaths(frameworkStr, FRAMEWORK_PREFIX));
        }
        return result;
    }

    private static List<String> trimPaths(String[] paths, String prefix) {
        LinkedList<String> result = new LinkedList<String>();
        String[] stringArray = paths;
        int n = paths.length;
        int n2 = 0;
        while (n2 < n) {
            String path = stringArray[n2];
            int indexSuffix = path.indexOf("@");
            if (indexSuffix < 0) {
                indexSuffix = path.length();
            }
            result.add(path.substring(prefix.length(), indexSuffix));
            ++n2;
        }
        return result;
    }

    private static Object newDirectoryBundleContainer(String containerPath) throws PdeCoreUtilsException {
        Object container = null;
        try {
            Bundle bundle = Activator.getDefault().getBundle();
            Class classs = bundle.loadClass("org.eclipse.pde.internal.core.target.DirectoryBundleContainer");
            Class[] paramTypes = new Class[]{containerPath.getClass()};
            Constructor constructor = classs.getConstructor(paramTypes);
            Object[] initargs = new Object[]{containerPath};
            container = constructor.newInstance(initargs);
        }
        catch (Exception e) {
            throw new PdeCoreUtilsException(e);
        }
        return container;
    }

    private static Object[] copyJarsAndGetContainers(List<String> bundlesStr, File copyDirectory) throws PdeCoreUtilsException, IOException {
        LinkedList<Object> bundleContainers = new LinkedList<Object>();
        Iterator<String> bundlesStrIter = bundlesStr.iterator();
        while (bundlesStrIter.hasNext()) {
            File bundleFile = new File(bundlesStrIter.next());
            if (!bundleFile.exists()) continue;
            if (bundleFile.isDirectory()) {
                TargetPlatformUtils.copyJarFileOrAddContainerDirectory(bundleFile, bundleContainers, copyDirectory);
                continue;
            }
            try {
                JarFile jarFile = new JarFile(bundleFile);
                TargetPlatformUtils.copyJarFile(jarFile, copyDirectory);
            }
            catch (IOException e) {
                throw new PdeCoreUtilsException(e);
            }
        }
        Object copyDirContainer = TargetPlatformUtils.newDirectoryBundleContainer(copyDirectory.getAbsolutePath());
        bundleContainers.add(copyDirContainer);
        return bundleContainers.toArray();
    }

    private static void copyJarFileOrAddContainerDirectory(File bundleFile, List<Object> bundleContainers, File copyDirectory) throws PdeCoreUtilsException, IOException {
        JarFile jarFile = TargetPlatformUtils.getFirstMatchingJarFile(bundleFile);
        if (jarFile == null) {
            Object container = TargetPlatformUtils.newDirectoryBundleContainer(bundleFile.getAbsolutePath());
            bundleContainers.add(container);
        } else {
            TargetPlatformUtils.copyJarFile(jarFile, copyDirectory);
        }
    }

    private static JarFile getFirstMatchingJarFile(File bundleFile) throws IOException {
        String bundleFileName;
        File jar;
        JarFile result = null;
        if (bundleFile.exists() && bundleFile.isDirectory() && (jar = TargetPlatformUtils.findJarFile(bundleFile, bundleFileName = bundleFile.getName())) != null) {
            result = new JarFile(jar);
        }
        return result;
    }

    private static File findJarFile(File directory, String fileName) {
        File[] children = directory.listFiles();
        LinkedList<File> toVisit = new LinkedList<File>();
        int cpt = 0;
        File foundFile = null;
        while (foundFile != null && cpt < children.length) {
            File child = children[cpt];
            if (child.isFile()) {
                String childName = child.getName();
                if (childName.startsWith(fileName) && childName.endsWith(JAR_EXT)) {
                    foundFile = child;
                }
            } else {
                toVisit.add(child);
            }
            ++cpt;
        }
        if (foundFile == null) {
            foundFile = TargetPlatformUtils.searchInSubDirectories(fileName, toVisit);
        }
        return foundFile;
    }

    private static File searchInSubDirectories(String fileName, List<File> toVisit) {
        File result = null;
        Iterator<File> childrenIterator = toVisit.iterator();
        while (childrenIterator.hasNext() && result != null) {
            File child = childrenIterator.next();
            result = TargetPlatformUtils.findJarFile(child.getAbsoluteFile(), fileName);
        }
        return result;
    }

    private static void copyJarFile(JarFile jarFile, File copyTo) throws PdeCoreUtilsException {
        String fileName = jarFile.getName();
        String bundleName = fileName.substring(fileName.lastIndexOf(File.separator));
        File copyToDirectory = new File(copyTo, bundleName);
        ZipOutputStream jarOutputStream = null;
        try {
            try {
                jarOutputStream = new JarOutputStream(new FileOutputStream(copyToDirectory));
                Enumeration<JarEntry> jarFileEntries = jarFile.entries();
                byte[] buffer = new byte[4096];
                while (jarFileEntries.hasMoreElements()) {
                    JarEntry sourceEntry = jarFileEntries.nextElement();
                    InputStream inputStream = jarFile.getInputStream(sourceEntry);
                    JarEntry targetEntry = new JarEntry(sourceEntry.getName());
                    ((JarOutputStream)jarOutputStream).putNextEntry(targetEntry);
                    int bytesRead = inputStream.read(buffer);
                    while (bytesRead != -1) {
                        jarOutputStream.write(buffer, 0, bytesRead);
                        bytesRead = inputStream.read(buffer);
                    }
                    inputStream.close();
                    jarOutputStream.flush();
                    jarOutputStream.closeEntry();
                }
            }
            catch (IOException e) {
                throw new PdeCoreUtilsException(e);
            }
        }
        finally {
            if (jarOutputStream != null) {
                try {
                    jarOutputStream.close();
                }
                catch (IOException e) {
                    throw new PdeCoreUtilsException(e);
                }
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static Object reflexiveCall(boolean staticCall, Object callOn, String calledMethodName, Object[] args) throws ReflexiveDiscouragedAccessException {
        Object result = null;
        Class<?>[] classes = TargetPlatformUtils.getClassesFromArgs(args);
        try {
            Method aMethod;
            if (staticCall) {
                if (!(callOn instanceof String)) throw new ReflexiveDiscouragedAccessException("Invalid parameter, callOn parameter should be a String. (Static Call)");
                Class clazz = Activator.getDefault().getBundle().loadClass((String)callOn);
                aMethod = TargetPlatformUtils.getMethod(clazz, calledMethodName, classes);
            } else {
                aMethod = TargetPlatformUtils.getMethod(callOn.getClass(), calledMethodName, classes);
            }
            if (aMethod != null) return aMethod.invoke(callOn, TargetPlatformUtils.manageArguments(args));
            throw new ReflexiveDiscouragedAccessException("API break, no method with specified arguments found.");
        }
        catch (Exception e) {
            throw new ReflexiveDiscouragedAccessException(e);
        }
    }

    private static Object[] manageArguments(Object[] arguments) {
        Object[] result;
        if (arguments != null && arguments.length > 0) {
            result = new Object[arguments.length];
            int i = 0;
            while (i < arguments.length) {
                Object arg = arguments[i];
                if (TargetPlatformUtils.isArray(arg)) {
                    Object argElement = ((Object[])arg)[0];
                    int arraySize = Array.getLength(arg);
                    Object[] argTmp = (Object[])Array.newInstance(argElement.getClass(), arraySize);
                    int y = 0;
                    while (y < arraySize) {
                        argTmp[y] = ((Object[])arg)[y];
                        ++y;
                    }
                    result[i] = argTmp;
                } else {
                    result[i] = arg;
                }
                ++i;
            }
        } else {
            result = arguments;
        }
        return result;
    }

    private static boolean isArray(Object obj) {
        return obj.getClass().getName().startsWith(ARRAY_PREFIX);
    }

    private static Class<?>[] getClassesFromArgs(Object[] args) {
        Class[] classes = null;
        if (args != null) {
            classes = new Class[args.length];
            Object arg = null;
            int i = 0;
            while (i < args.length) {
                arg = args[i];
                if (arg != null) {
                    if (TargetPlatformUtils.isArray(arg)) {
                        arg = ((Object[])arg)[0];
                        arg = Array.newInstance(arg.getClass(), 0);
                    }
                    classes[i] = arg.getClass();
                }
                ++i;
            }
        }
        return classes;
    }

    private static Method getMethod(Class<?> clazz, String methodName, Class<?> ... parameterTypes) throws ClassNotFoundException {
        Method[] methods;
        Method result = null;
        Method[] methodArray = methods = clazz.getMethods();
        int n = methods.length;
        int n2 = 0;
        while (n2 < n) {
            Class<?>[] parameters;
            Method method = methodArray[n2];
            if (methodName.equals(method.getName()) && TargetPlatformUtils.checkTypes(parameters = method.getParameterTypes(), parameterTypes)) {
                result = method;
                break;
            }
            ++n2;
        }
        return result;
    }

    private static boolean checkTypes(Class<?>[] refParams, Class<?>[] parameterToTest) throws ClassNotFoundException {
        boolean result = true;
        if (refParams != null && parameterToTest != null && refParams.length == parameterToTest.length) {
            String refClazzName = null;
            String clazzName = null;
            int i = 0;
            while (i < parameterToTest.length) {
                boolean isParamArray;
                boolean isRefArray;
                refClazzName = refParams[i].getName();
                clazzName = parameterToTest[i].getName();
                if (!clazzName.equals(refClazzName) && (isRefArray = refClazzName.startsWith(ARRAY_PREFIX)) == (isParamArray = clazzName.startsWith(ARRAY_PREFIX))) {
                    if (isRefArray) {
                        refClazzName = refClazzName.substring(ARRAY_PREFIX.length(), refClazzName.length() - 1);
                        clazzName = clazzName.substring(ARRAY_PREFIX.length(), clazzName.length() - 1);
                    }
                    result = TargetPlatformUtils.paramExtendsRef(refClazzName, clazzName);
                }
                ++i;
            }
        }
        return result;
    }

    private static boolean paramExtendsRef(String refClassName, String className) throws ClassNotFoundException {
        Bundle bundle = Activator.getDefault().getBundle();
        Class refClazz = bundle.loadClass(refClassName);
        Class clazz = bundle.loadClass(className);
        return refClazz.isAssignableFrom(clazz);
    }
}

