/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.decoratormodel.internal.controlmode;

import com.google.common.base.Function;
import com.google.common.base.Functions;
import com.google.common.base.Predicate;
import com.google.common.collect.Collections2;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.Iterators;
import com.google.common.collect.MapMaker;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.emf.transaction.util.TransactionUtil;
import org.eclipse.papyrus.infra.emf.utils.EMFFunctions;
import org.eclipse.papyrus.infra.emf.utils.EMFPredicates;
import org.eclipse.papyrus.infra.services.controlmode.ControlModeRequest;
import org.eclipse.papyrus.infra.tools.util.ReferenceCounted;
import org.eclipse.papyrus.uml.decoratormodel.helper.DecoratorModelUtils;
import org.eclipse.papyrus.uml.decoratormodel.internal.controlmode.Activator;
import org.eclipse.papyrus.uml.decoratormodel.internal.resource.DecoratorModelIndex;
import org.eclipse.uml2.uml.Package;
import org.eclipse.uml2.uml.Profile;
import org.eclipse.uml2.uml.ProfileApplication;
import org.eclipse.uml2.uml.UMLPackage;

public class PackageRefactoringContext
extends ReferenceCounted<PackageRefactoringContext> {
    private static Map<Package, PackageRefactoringContext> contexts = new MapMaker().weakKeys().weakValues().makeMap();
    private final Package package_;
    private final URI oldUserModelURI;
    private final URI newUserModelURI;
    private final TransactionalEditingDomain domain;
    private final Set<Package> affectedPackages;
    private final Set<ProfileApplication> preRefactoringProfileApplications;
    private final Map<URI, Map<URI, URI>> allExternalAppliedProfiles;
    private final Map<URI, Map<URI, URI>> inheritedExternalAppliedProfiles;
    private final Set<URI> affectedDecoratorModels;
    private final Set<URI> affectedLoadedDecoratorModels;
    private final Set<URI> affectedUnloadedDecoratorModels;
    private Map<Object, Object> data;

    private PackageRefactoringContext(Package package_, URI oldUserModelURI, URI newUserModelURI) {
        super(Activator.getDefault().getExecutorService());
        this.package_ = package_;
        this.oldUserModelURI = oldUserModelURI;
        this.newUserModelURI = newUserModelURI;
        this.domain = TransactionUtil.getEditingDomain((EObject)package_);
        this.affectedPackages = ImmutableSet.copyOf(PackageRefactoringContext.getPackagesBeingControlled((EObject)package_));
        this.preRefactoringProfileApplications = ImmutableSet.copyOf((Collection)package_.getProfileApplications());
        HashSet allPackages = Sets.newHashSet(this.affectedPackages);
        for (Package next : this.affectedPackages) {
            allPackages.addAll(next.allOwningPackages());
        }
        HashSet decorators = Sets.newHashSet();
        Map allExternal = null;
        Map inheritedExternal = null;
        try {
            allExternal = DecoratorModelUtils.getAllDecoratorModelAppliedProfileDefinitions((Package)package_);
            if (package_.getNestingPackage() != null) {
                inheritedExternal = DecoratorModelUtils.getAllDecoratorModelAppliedProfileDefinitions((Package)package_.getNestingPackage());
            }
            for (Package next : allPackages) {
                decorators.addAll(DecoratorModelIndex.getInstance().getDecoratorModelsForPackage(EcoreUtil.getURI((EObject)next)));
            }
        }
        catch (CoreException e) {
            Activator.getDefault().getLog().log(e.getStatus());
            allExternal = Collections.emptyMap();
        }
        this.allExternalAppliedProfiles = allExternal != null ? allExternal : Collections.emptyMap();
        this.inheritedExternalAppliedProfiles = inheritedExternal != null ? inheritedExternal : Collections.emptyMap();
        this.affectedDecoratorModels = ImmutableSet.copyOf((Collection)decorators);
        HashSet allLoaded = Sets.newHashSet((Iterable)Iterables.transform((Iterable)Iterables.filter((Iterable)this.domain.getResourceSet().getResources(), (Predicate)EMFPredicates.isLoaded()), (Function)EMFFunctions.resourceURI()));
        this.affectedLoadedDecoratorModels = ImmutableSet.copyOf((Collection)Sets.intersection((Set)decorators, (Set)allLoaded));
        decorators.removeAll(allLoaded);
        this.affectedUnloadedDecoratorModels = ImmutableSet.copyOf((Collection)decorators);
    }

    static PackageRefactoringContext get(Package package_, ControlModeRequest request) {
        PackageRefactoringContext result = contexts.get(package_);
        if (result == null) {
            result = new PackageRefactoringContext(package_, request.getSourceURI(), request.getNewURI());
            contexts.put(package_, result);
        }
        return result;
    }

    static void remove(PackageRefactoringContext context) {
        if (contexts.get(context.getPackage()) == context) {
            contexts.remove(context.getPackage());
        }
    }

    public static PackageRefactoringContext getInstance(ControlModeRequest request) {
        return request.getTargetObject() instanceof Package ? (PackageRefactoringContext)((Object)PackageRefactoringContext.get((Package)request.getTargetObject(), request).retain()) : null;
    }

    protected void dispose() {
        PackageRefactoringContext.remove(this);
        this.data = null;
    }

    public TransactionalEditingDomain getEditingDomain() {
        return this.domain;
    }

    public Package getPackage() {
        return this.package_;
    }

    public URI getOldUserModelURI() {
        return this.oldUserModelURI;
    }

    public URI getNewUserModelURI() {
        return this.newUserModelURI;
    }

    public Set<ProfileApplication> getPreRefactoringProfileApplications() {
        return this.preRefactoringProfileApplications;
    }

    public Set<Profile> getPreRefactoringAppliedProfiles() {
        return ImmutableSet.copyOf((Collection)Collections2.transform(this.getPreRefactoringProfileApplications(), (Function)EMFFunctions.getFeature((EStructuralFeature)UMLPackage.Literals.PROFILE_APPLICATION__APPLIED_PROFILE, Profile.class)));
    }

    public Set<URI> getPreRefactoringAppliedProfileURIs() {
        return ImmutableSet.copyOf((Collection)Collections2.transform(this.getPreRefactoringProfileApplications(), (Function)Functions.compose((Function)EMFFunctions.objectURI(), (Function)EMFFunctions.getFeature((EStructuralFeature)UMLPackage.Literals.PROFILE_APPLICATION__APPLIED_PROFILE, Profile.class))));
    }

    public Set<ProfileApplication> getPostRefactoringProfileApplications() {
        return Sets.difference((Set)Sets.newHashSet((Iterable)this.package_.getProfileApplications()), this.preRefactoringProfileApplications);
    }

    public Set<Profile> getPostRefactoringAppliedProfiles() {
        return ImmutableSet.copyOf((Collection)Collections2.transform(this.getPostRefactoringProfileApplications(), (Function)EMFFunctions.getFeature((EStructuralFeature)UMLPackage.Literals.PROFILE_APPLICATION__APPLIED_PROFILE, Profile.class)));
    }

    public Set<URI> getPostRefactoringAppliedProfileURIs() {
        return ImmutableSet.copyOf((Collection)Collections2.transform(this.getPostRefactoringProfileApplications(), (Function)Functions.compose((Function)EMFFunctions.objectURI(), (Function)EMFFunctions.getFeature((EStructuralFeature)UMLPackage.Literals.PROFILE_APPLICATION__APPLIED_PROFILE, Profile.class))));
    }

    public Set<Package> getAffectedPackages() {
        return this.affectedPackages;
    }

    public Map<URI, Map<URI, URI>> getAllExternalProfileApplications() {
        return this.allExternalAppliedProfiles;
    }

    public Map<URI, Map<URI, URI>> getInheritedExternalProfileApplications() {
        return this.inheritedExternalAppliedProfiles;
    }

    public Set<URI> getAffectedDecoratorModels() {
        return this.affectedDecoratorModels;
    }

    public Set<URI> getAffectedLoadedDecoratorModels() {
        return this.affectedLoadedDecoratorModels;
    }

    public Set<URI> getAffectedUnloadedDecoratorModels() {
        return this.affectedUnloadedDecoratorModels;
    }

    public Map<URI, URI> getAllExternalProfileApplicationsFor(URI decoratorModelURI) {
        return this.getExternalProfileApplicationsFor(decoratorModelURI, this.getAllExternalProfileApplications());
    }

    public Map<URI, URI> getInheritedExternalProfileApplicationsFor(URI decoratorModelURI) {
        return this.getExternalProfileApplicationsFor(decoratorModelURI, this.getInheritedExternalProfileApplications());
    }

    private Map<URI, URI> getExternalProfileApplicationsFor(URI decoratorModelURI, Map<URI, Map<URI, URI>> source) {
        ImmutableMap.Builder result = ImmutableMap.builder();
        for (Map.Entry<URI, Map<URI, URI>> next : source.entrySet()) {
            URI definition = next.getValue().get(decoratorModelURI);
            if (definition == null) continue;
            result.put((Object)next.getKey(), (Object)definition);
        }
        return result.build();
    }

    public static Iterable<Package> getPackagesBeingControlled(final EObject object) {
        return new Iterable<Package>(){

            @Override
            public Iterator<Package> iterator() {
                TreeIterator properContents = EcoreUtil.getAllProperContents(Collections.singletonList(object), (boolean)false);
                return Iterators.filter((Iterator)Iterators.filter((Iterator)properContents, Package.class), (Predicate)EMFPredicates.notProxy());
            }
        };
    }

    public Map<Object, Object> getContextData() {
        if (this.data == null) {
            this.data = Maps.newHashMap();
        }
        return this.data;
    }
}

