/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.builder.preferences;

import com.google.common.base.Strings;
import com.google.inject.Inject;
import com.google.inject.Singleton;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.xtext.generator.IOutputConfigurationProvider;
import org.eclipse.xtext.generator.OutputConfiguration;
import org.eclipse.xtext.ui.editor.preferences.IPreferenceStoreAccess;
import org.eclipse.xtext.ui.editor.preferences.IPreferenceStoreInitializer;

@Singleton
public class BuilderPreferenceAccess {
    public static final String PREF_AUTO_BUILDING = "autobuilding";
    private IPreferenceStoreAccess preferenceStoreAccess;

    public static String getKey(OutputConfiguration outputConfiguration, String preferenceName) {
        return "outlet." + outputConfiguration.getName() + '.' + preferenceName;
    }

    public static String getOutputForSourceFolderKey(OutputConfiguration outputConfiguration, String sourceFolder) {
        return BuilderPreferenceAccess.getKey(outputConfiguration, "sourceFolder." + sourceFolder + '.' + "directory");
    }

    public static String getIgnoreSourceFolderKey(OutputConfiguration outputConfiguration, String sourceFolder) {
        return BuilderPreferenceAccess.getKey(outputConfiguration, "sourceFolder." + sourceFolder + '.' + "ignore");
    }

    @Inject
    public void setPreferenceStoreAccess(IPreferenceStoreAccess preferenceStoreAccess) {
        this.preferenceStoreAccess = preferenceStoreAccess;
    }

    public boolean isAutoBuildEnabled(Object context) {
        IPreferenceStore preferenceStore = this.preferenceStoreAccess.getContextPreferenceStore(context);
        return preferenceStore.contains(PREF_AUTO_BUILDING) ? preferenceStore.getBoolean(PREF_AUTO_BUILDING) : true;
    }

    public void setAutoBuildEnabled(Object context, boolean enabled) {
        IPreferenceStore preferenceStore = this.preferenceStoreAccess.getWritablePreferenceStore(context);
        preferenceStore.setValue(PREF_AUTO_BUILDING, enabled);
    }

    public static class Initializer
    implements IPreferenceStoreInitializer {
        private IOutputConfigurationProvider outputConfigurationProvider;

        public IOutputConfigurationProvider getOutputConfigurationProvider() {
            return this.outputConfigurationProvider;
        }

        @Inject
        public void setOutputConfigurationProvider(IOutputConfigurationProvider outputConfigurationProvider) {
            this.outputConfigurationProvider = outputConfigurationProvider;
        }

        public void initialize(IPreferenceStoreAccess preferenceStoreAccess) {
            IPreferenceStore store = preferenceStoreAccess.getWritablePreferenceStore();
            this.initializeBuilderPreferences(store);
            for (OutputConfiguration configuration : this.outputConfigurationProvider.getOutputConfigurations()) {
                this.initializeOutputPreferences(store, configuration);
            }
        }

        protected void initializeBuilderPreferences(IPreferenceStore store) {
            store.setDefault(BuilderPreferenceAccess.PREF_AUTO_BUILDING, true);
        }

        protected void initializeOutputPreferences(IPreferenceStore store, OutputConfiguration configuration) {
            store.setDefault(BuilderPreferenceAccess.getKey(configuration, "name"), configuration.getName());
            store.setDefault(BuilderPreferenceAccess.getKey(configuration, "description"), configuration.getDescription());
            store.setDefault(BuilderPreferenceAccess.getKey(configuration, "derived"), configuration.isSetDerivedProperty());
            store.setDefault(BuilderPreferenceAccess.getKey(configuration, "directory"), configuration.getOutputDirectory());
            store.setDefault(BuilderPreferenceAccess.getKey(configuration, "createDirectory"), configuration.isCreateOutputDirectory());
            store.setDefault(BuilderPreferenceAccess.getKey(configuration, "cleanDirectory"), configuration.isCanClearOutputDirectory());
            store.setDefault(BuilderPreferenceAccess.getKey(configuration, "override"), configuration.isOverrideExistingResources());
            store.setDefault(BuilderPreferenceAccess.getKey(configuration, "cleanupDerived"), configuration.isCleanUpDerivedResources());
            store.setDefault(BuilderPreferenceAccess.getKey(configuration, "installDslAsPrimarySource"), configuration.isInstallDslAsPrimarySource());
            store.setDefault(BuilderPreferenceAccess.getKey(configuration, "hideLocalSyntheticVariables"), configuration.isHideSyntheticLocalVariables());
            store.setDefault(BuilderPreferenceAccess.getKey(configuration, "keepLocalHistory"), configuration.isKeepLocalHistory().booleanValue());
            for (OutputConfiguration.SourceMapping sourceMapping : configuration.getSourceMappings()) {
                store.setDefault(BuilderPreferenceAccess.getOutputForSourceFolderKey(configuration, sourceMapping.getSourceFolder()), Strings.nullToEmpty((String)sourceMapping.getOutputDirectory()));
                store.setDefault(BuilderPreferenceAccess.getIgnoreSourceFolderKey(configuration, sourceMapping.getSourceFolder()), sourceMapping.isIgnore());
            }
        }
    }
}

