/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.diagram.activity.activitygroup.request;

import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.Multimap;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.gef.Request;
import org.eclipse.gmf.runtime.diagram.ui.editparts.IGraphicalEditPart;
import org.eclipse.papyrus.uml.diagram.activity.activitygroup.IContainerNodeDescriptor;
import org.eclipse.papyrus.uml.diagram.activity.activitygroup.request.IGroupRequest;
import org.eclipse.papyrus.uml.diagram.activity.activitygroup.utils.Utils;

public abstract class AbstractGroupRequest
extends Request
implements IGroupRequest {
    protected IGraphicalEditPart host;
    protected Request request;
    protected IAdaptable target;
    protected IContainerNodeDescriptor nodeDescriptor;
    private Multimap<EReference, EObject> eParentRefenceMap;
    private Multimap<EReference, EObject> eChildrenRefenceMap;

    public AbstractGroupRequest(IGraphicalEditPart host, Request request, IAdaptable target, IContainerNodeDescriptor nodeDescriptor) {
        this.host = host;
        this.request = request;
        this.target = target;
        this.nodeDescriptor = nodeDescriptor;
    }

    @Override
    public IGraphicalEditPart getHostRequest() {
        return this.host;
    }

    @Override
    public Request getInitialRequest() {
        return this.request;
    }

    @Override
    public IContainerNodeDescriptor getNodeDescpitor() {
        return this.nodeDescriptor;
    }

    @Override
    public IAdaptable getTargetElement() {
        return this.target;
    }

    @Override
    public String getLabel() {
        StringBuilder builder = new StringBuilder(" IGroupRequest :\n \t Request : ").append(this.request).append("\n \t Target : ");
        Object eObject = this.getTargetElement().getAdapter(EObject.class);
        if (eObject instanceof EObject) {
            return "";
        }
        builder.append(Utils.getCorrectLabel(eObject));
        builder.append("\n \t Host :").append(Utils.getCorrectLabel((IAdaptable)this.getHostRequest()));
        builder.append("\n \t Type :").append((Object)this.getGroupRequestType());
        return builder.toString();
    }

    @Override
    public Multimap<EReference, EObject> getParentEReferenceMap() {
        if (this.eParentRefenceMap == null) {
            this.eParentRefenceMap = ArrayListMultimap.create();
        }
        return this.eParentRefenceMap;
    }

    @Override
    public Multimap<EReference, EObject> getChildrenEReferenceMap() {
        if (this.eChildrenRefenceMap == null) {
            this.eChildrenRefenceMap = ArrayListMultimap.create();
        }
        return this.eChildrenRefenceMap;
    }
}

