/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.diagram.sequence.edit.policies;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.draw2d.Connection;
import org.eclipse.draw2d.Ellipse;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.PointList;
import org.eclipse.draw2d.geometry.Translatable;
import org.eclipse.gef.ConnectionEditPart;
import org.eclipse.gef.DragTracker;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.Request;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.editpolicies.ConnectionEndpointEditPolicy;
import org.eclipse.gef.handles.ConnectionEndpointHandle;
import org.eclipse.gef.requests.ReconnectRequest;
import org.eclipse.gef.tools.ConnectionEndpointTracker;

public class AnnotatedLinkEndpointEditPolicy
extends ConnectionEndpointEditPolicy {
    private IFigure anchorFeedback;

    public void eraseSourceFeedback(Request request) {
        if ("annotated link reorient start".equals(request.getType()) || "annotated link reorient end".equals(request.getType())) {
            this.eraseConnectionMoveFeedback((ReconnectRequest)request);
        }
    }

    public void showSourceFeedback(Request request) {
        if ("annotated link reorient start".equals(request.getType()) || "annotated link reorient end".equals(request.getType())) {
            this.showConnectionMoveFeedback((ReconnectRequest)request);
        }
    }

    protected void showConnectionMoveFeedback(ReconnectRequest request) {
        boolean showFeedback;
        super.showConnectionMoveFeedback(request);
        EditPart target = request.getTarget();
        boolean bl = showFeedback = target != null;
        if (target != null) {
            Command command = target.getCommand((Request)request);
            boolean bl2 = showFeedback = command != null && command.canExecute();
        }
        if (showFeedback) {
            Point location = null;
            Connection connection = this.getConnection();
            PointList points = connection.getPoints().getCopy();
            location = request.isMovingStartAnchor() ? points.getFirstPoint() : points.getLastPoint();
            connection.translateToAbsolute((Translatable)location);
            this.setFeedbackLocation(this.getAnchorFeedback(), location);
        } else {
            if (this.anchorFeedback != null && this.anchorFeedback.getParent() != null) {
                this.removeFeedback(this.anchorFeedback);
            }
            this.anchorFeedback = null;
        }
    }

    protected void eraseConnectionMoveFeedback(ReconnectRequest request) {
        super.eraseConnectionMoveFeedback(request);
        if (this.anchorFeedback != null && this.anchorFeedback.getParent() != null) {
            this.removeFeedback(this.anchorFeedback);
        }
        this.anchorFeedback = null;
    }

    private void setFeedbackLocation(IFigure feedback, Point location) {
        if (feedback == null || location == null) {
            return;
        }
        Point p = location.getCopy();
        Dimension d = feedback.getSize();
        p.x -= d.width / 2;
        p.y -= d.height / 2;
        feedback.translateToRelative((Translatable)p);
        feedback.setLocation(p);
    }

    private IFigure getAnchorFeedback() {
        if (this.anchorFeedback == null || this.anchorFeedback.getParent() == null) {
            Ellipse feedback = new Ellipse();
            feedback.setLineWidth(2);
            feedback.setAntialias(1);
            feedback.setSize(10, 10);
            this.getFeedbackLayer().add((IFigure)feedback);
            this.anchorFeedback = feedback;
        }
        return this.anchorFeedback;
    }

    protected List createSelectionHandles() {
        ArrayList<ConnectionEndpointHandle> list = new ArrayList<ConnectionEndpointHandle>();
        list.add(new ConnectionEndpointHandle((ConnectionEditPart)this.getHost(), 2){

            protected DragTracker createDragTracker() {
                ConnectionEndpointTracker tracker = new ConnectionEndpointTracker((ConnectionEditPart)this.getOwner()){

                    protected Request createTargetRequest() {
                        ReconnectRequest request = new ReconnectRequest(this.getCommandName()){

                            public boolean isMovingStartAnchor() {
                                return true;
                            }
                        };
                        request.setConnectionEditPart(this.getConnectionEditPart());
                        return request;
                    }
                };
                tracker.setCommandName("annotated link reorient start");
                tracker.setDefaultCursor(this.getCursor());
                return tracker;
            }
        });
        list.add(new ConnectionEndpointHandle((ConnectionEditPart)this.getHost(), 3){

            protected DragTracker createDragTracker() {
                ConnectionEndpointTracker tracker = new ConnectionEndpointTracker((ConnectionEditPart)this.getOwner()){

                    protected Request createTargetRequest() {
                        ReconnectRequest request = new ReconnectRequest(this.getCommandName()){

                            public boolean isMovingStartAnchor() {
                                return false;
                            }
                        };
                        request.setConnectionEditPart(this.getConnectionEditPart());
                        return request;
                    }
                };
                tracker.setCommandName("annotated link reorient end");
                tracker.setDefaultCursor(this.getCursor());
                return tracker;
            }
        });
        return list;
    }
}

