/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.util.bkd;

import java.io.Closeable;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.lucene.codecs.CodecUtil;
import org.apache.lucene.index.MergeState;
import org.apache.lucene.store.ChecksumIndexInput;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.IOContext;
import org.apache.lucene.store.IndexOutput;
import org.apache.lucene.store.TrackingDirectoryWrapper;
import org.apache.lucene.util.ArrayUtil;
import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.BytesRefComparator;
import org.apache.lucene.util.FixedBitSet;
import org.apache.lucene.util.IOUtils;
import org.apache.lucene.util.LongBitSet;
import org.apache.lucene.util.MSBRadixSorter;
import org.apache.lucene.util.NumericUtils;
import org.apache.lucene.util.OfflineSorter;
import org.apache.lucene.util.PriorityQueue;
import org.apache.lucene.util.StringHelper;
import org.apache.lucene.util.bkd.BKDReader;
import org.apache.lucene.util.bkd.HeapPointWriter;
import org.apache.lucene.util.bkd.OfflinePointWriter;
import org.apache.lucene.util.bkd.PointReader;
import org.apache.lucene.util.bkd.PointWriter;

public class BKDWriter
implements Closeable {
    public static final String CODEC_NAME = "BKD";
    public static final int VERSION_START = 0;
    public static final int VERSION_CURRENT = 0;
    private final int bytesPerDoc;
    public static final int DEFAULT_MAX_POINTS_IN_LEAF_NODE = 1024;
    public static final float DEFAULT_MAX_MB_SORT_IN_HEAP = 16.0f;
    public static final int MAX_DIMS = 8;
    protected final int numDims;
    protected final int bytesPerDim;
    protected final int packedBytesLength;
    final TrackingDirectoryWrapper tempDir;
    final String tempFileNamePrefix;
    final double maxMBSortInHeap;
    final byte[] scratchDiff;
    final byte[] scratch1;
    final byte[] scratch2;
    final BytesRef scratchBytesRef = new BytesRef();
    final int[] commonPrefixLengths;
    protected final FixedBitSet docsSeen;
    private OfflinePointWriter offlinePointWriter;
    private HeapPointWriter heapPointWriter;
    private IndexOutput tempInput;
    protected final int maxPointsInLeafNode;
    private final int maxPointsSortInHeap;
    protected final byte[] minPackedValue;
    protected final byte[] maxPackedValue;
    protected long pointCount;
    protected final boolean longOrds;
    private final long totalPointCount;
    protected final boolean singleValuePerDoc;
    protected final OfflineSorter.BufferSize offlineSorterBufferMB;
    protected final int offlineSorterMaxTempFiles;
    private final int maxDoc;

    public BKDWriter(int maxDoc, Directory tempDir, String tempFileNamePrefix, int numDims, int bytesPerDim, int maxPointsInLeafNode, double maxMBSortInHeap, long totalPointCount, boolean singleValuePerDoc) throws IOException {
        this(maxDoc, tempDir, tempFileNamePrefix, numDims, bytesPerDim, maxPointsInLeafNode, maxMBSortInHeap, totalPointCount, singleValuePerDoc, totalPointCount > Integer.MAX_VALUE, Math.max(1L, (long)maxMBSortInHeap), 10);
    }

    protected BKDWriter(int maxDoc, Directory tempDir, String tempFileNamePrefix, int numDims, int bytesPerDim, int maxPointsInLeafNode, double maxMBSortInHeap, long totalPointCount, boolean singleValuePerDoc, boolean longOrds, long offlineSorterBufferMB, int offlineSorterMaxTempFiles) throws IOException {
        BKDWriter.verifyParams(numDims, maxPointsInLeafNode, maxMBSortInHeap, totalPointCount);
        this.tempDir = new TrackingDirectoryWrapper(tempDir);
        this.tempFileNamePrefix = tempFileNamePrefix;
        this.maxPointsInLeafNode = maxPointsInLeafNode;
        this.numDims = numDims;
        this.bytesPerDim = bytesPerDim;
        this.totalPointCount = totalPointCount;
        this.maxDoc = maxDoc;
        this.offlineSorterBufferMB = OfflineSorter.BufferSize.megabytes(offlineSorterBufferMB);
        this.offlineSorterMaxTempFiles = offlineSorterMaxTempFiles;
        this.docsSeen = new FixedBitSet(maxDoc);
        this.packedBytesLength = numDims * bytesPerDim;
        this.scratchDiff = new byte[bytesPerDim];
        this.scratchBytesRef.length = this.packedBytesLength;
        this.scratch1 = new byte[this.packedBytesLength];
        this.scratch2 = new byte[this.packedBytesLength];
        this.commonPrefixLengths = new int[numDims];
        this.minPackedValue = new byte[this.packedBytesLength];
        this.maxPackedValue = new byte[this.packedBytesLength];
        this.longOrds = longOrds;
        this.singleValuePerDoc = singleValuePerDoc;
        if (singleValuePerDoc) {
            assert (!longOrds);
            this.bytesPerDoc = this.packedBytesLength + 4;
        } else {
            this.bytesPerDoc = longOrds ? this.packedBytesLength + 8 + 4 : this.packedBytesLength + 4 + 4;
        }
        this.maxPointsSortInHeap = (int)(0.5 * (maxMBSortInHeap * 1024.0 * 1024.0) / (double)(this.bytesPerDoc * numDims));
        if (this.maxPointsSortInHeap < maxPointsInLeafNode) {
            throw new IllegalArgumentException("maxMBSortInHeap=" + maxMBSortInHeap + " only allows for maxPointsSortInHeap=" + this.maxPointsSortInHeap + ", but this is less than maxPointsInLeafNode=" + maxPointsInLeafNode + "; either increase maxMBSortInHeap or decrease maxPointsInLeafNode");
        }
        this.heapPointWriter = new HeapPointWriter(16, this.maxPointsSortInHeap, this.packedBytesLength, longOrds, singleValuePerDoc);
        this.maxMBSortInHeap = maxMBSortInHeap;
    }

    public static void verifyParams(int numDims, int maxPointsInLeafNode, double maxMBSortInHeap, long totalPointCount) {
        if (numDims < 1 || numDims > 8) {
            throw new IllegalArgumentException("numDims must be 1 .. 8 (got: " + numDims + ")");
        }
        if (maxPointsInLeafNode <= 0) {
            throw new IllegalArgumentException("maxPointsInLeafNode must be > 0; got " + maxPointsInLeafNode);
        }
        if (maxPointsInLeafNode > ArrayUtil.MAX_ARRAY_LENGTH) {
            throw new IllegalArgumentException("maxPointsInLeafNode must be <= ArrayUtil.MAX_ARRAY_LENGTH (= " + ArrayUtil.MAX_ARRAY_LENGTH + "); got " + maxPointsInLeafNode);
        }
        if (maxMBSortInHeap < 0.0) {
            throw new IllegalArgumentException("maxMBSortInHeap must be >= 0.0 (got: " + maxMBSortInHeap + ")");
        }
        if (totalPointCount < 0L) {
            throw new IllegalArgumentException("totalPointCount must be >=0 (got: " + totalPointCount + ")");
        }
    }

    private void spillToOffline() throws IOException {
        this.offlinePointWriter = new OfflinePointWriter(this.tempDir, this.tempFileNamePrefix, this.packedBytesLength, this.longOrds, "spill", 0L, this.singleValuePerDoc);
        this.tempInput = this.offlinePointWriter.out;
        PointReader reader = this.heapPointWriter.getReader(0L, this.pointCount);
        int i = 0;
        while ((long)i < this.pointCount) {
            boolean hasNext = reader.next();
            assert (hasNext);
            this.offlinePointWriter.append(reader.packedValue(), i, this.heapPointWriter.docIDs[i]);
            ++i;
        }
        this.heapPointWriter = null;
    }

    public void add(byte[] packedValue, int docID) throws IOException {
        if (packedValue.length != this.packedBytesLength) {
            throw new IllegalArgumentException("packedValue should be length=" + this.packedBytesLength + " (got: " + packedValue.length + ")");
        }
        if (this.pointCount >= (long)this.maxPointsSortInHeap) {
            if (this.offlinePointWriter == null) {
                this.spillToOffline();
            }
            this.offlinePointWriter.append(packedValue, this.pointCount, docID);
        } else {
            this.heapPointWriter.append(packedValue, this.pointCount, docID);
        }
        if (this.pointCount == 0L) {
            System.arraycopy(packedValue, 0, this.minPackedValue, 0, this.packedBytesLength);
            System.arraycopy(packedValue, 0, this.maxPackedValue, 0, this.packedBytesLength);
        } else {
            for (int dim = 0; dim < this.numDims; ++dim) {
                int offset = dim * this.bytesPerDim;
                if (StringHelper.compare(this.bytesPerDim, packedValue, offset, this.minPackedValue, offset) < 0) {
                    System.arraycopy(packedValue, offset, this.minPackedValue, offset, this.bytesPerDim);
                }
                if (StringHelper.compare(this.bytesPerDim, packedValue, offset, this.maxPackedValue, offset) <= 0) continue;
                System.arraycopy(packedValue, offset, this.maxPackedValue, offset, this.bytesPerDim);
            }
        }
        ++this.pointCount;
        if (this.pointCount > this.totalPointCount) {
            throw new IllegalStateException("totalPointCount=" + this.totalPointCount + " was passed when we were created, but we just hit " + this.pointCount + " values");
        }
        this.docsSeen.set(docID);
    }

    public long getPointCount() {
        return this.pointCount;
    }

    public long merge(IndexOutput out, List<MergeState.DocMap> docMaps, List<BKDReader> readers, List<Integer> docIDBases) throws IOException {
        if (this.numDims != 1) {
            throw new UnsupportedOperationException("numDims must be 1 but got " + this.numDims);
        }
        if (this.pointCount != 0L) {
            throw new IllegalStateException("cannot mix add and merge");
        }
        if (this.heapPointWriter == null && this.tempInput == null) {
            throw new IllegalStateException("already finished");
        }
        this.heapPointWriter = null;
        assert (docMaps == null || readers.size() == docMaps.size());
        BKDMergeQueue queue = new BKDMergeQueue(this.bytesPerDim, readers.size());
        for (int i = 0; i < readers.size(); ++i) {
            MergeState.DocMap docMap;
            BKDReader bkd = readers.get(i);
            MergeReader reader = new MergeReader(bkd, docMap = docMaps == null ? null : docMaps.get(i), docIDBases.get(i));
            if (!reader.next()) continue;
            queue.add(reader);
        }
        if (queue.size() == 0) {
            return -1L;
        }
        int leafCount = 0;
        ArrayList<Long> leafBlockFPs = new ArrayList<Long>();
        ArrayList<byte[]> leafBlockStartValues = new ArrayList<byte[]>();
        int pointsPerLeafBlock = (int)(0.75 * (double)this.maxPointsInLeafNode);
        byte[] lastPackedValue = new byte[this.bytesPerDim];
        byte[] firstPackedValue = new byte[this.bytesPerDim];
        long valueCount = 0L;
        int[] leafBlockDocIDs = new int[this.maxPointsInLeafNode];
        byte[][] leafBlockPackedValues = new byte[this.maxPointsInLeafNode][];
        for (int i = 0; i < this.maxPointsInLeafNode; ++i) {
            leafBlockPackedValues[i] = new byte[this.packedBytesLength];
        }
        Arrays.fill(this.commonPrefixLengths, this.bytesPerDim);
        while (queue.size() != 0) {
            int docID;
            MergeReader reader = (MergeReader)queue.top();
            leafBlockDocIDs[leafCount] = docID = reader.docIDBase + reader.docID;
            System.arraycopy(reader.state.scratchPackedValue, 0, leafBlockPackedValues[leafCount], 0, this.packedBytesLength);
            this.docsSeen.set(docID);
            if (valueCount == 0L) {
                System.arraycopy(reader.state.scratchPackedValue, 0, this.minPackedValue, 0, this.packedBytesLength);
            }
            System.arraycopy(reader.state.scratchPackedValue, 0, this.maxPackedValue, 0, this.packedBytesLength);
            assert (this.numDims > 1 || this.valueInOrder(valueCount, lastPackedValue, reader.state.scratchPackedValue, 0));
            ++valueCount;
            if (this.pointCount > this.totalPointCount) {
                throw new IllegalStateException("totalPointCount=" + this.totalPointCount + " was passed when we were created, but we just hit " + this.pointCount + " values");
            }
            if (leafCount == 0) {
                if (leafBlockFPs.size() > 0) {
                    leafBlockStartValues.add(Arrays.copyOf(reader.state.scratchPackedValue, this.bytesPerDim));
                }
                Arrays.fill(this.commonPrefixLengths, this.bytesPerDim);
                System.arraycopy(reader.state.scratchPackedValue, 0, firstPackedValue, 0, this.bytesPerDim);
            } else {
                block3: for (int dim = 0; dim < this.numDims; ++dim) {
                    int offset = dim * this.bytesPerDim;
                    for (int j = 0; j < this.commonPrefixLengths[dim]; ++j) {
                        if (firstPackedValue[offset + j] == reader.state.scratchPackedValue[offset + j]) continue;
                        this.commonPrefixLengths[dim] = j;
                        continue block3;
                    }
                }
            }
            ++leafCount;
            if (reader.next()) {
                queue.updateTop();
            } else {
                queue.pop();
            }
            if (leafCount != pointsPerLeafBlock && queue.size() != 0) continue;
            leafBlockFPs.add(out.getFilePointer());
            this.checkMaxLeafNodeCount(leafBlockFPs.size());
            this.writeLeafBlockDocs(out, leafBlockDocIDs, 0, leafCount);
            this.writeCommonPrefixes(out, this.commonPrefixLengths, firstPackedValue);
            for (int i = 0; i < leafCount; ++i) {
                this.writeLeafBlockPackedValue(out, this.commonPrefixLengths, leafBlockPackedValues[i], 0);
            }
            leafCount = 0;
        }
        this.pointCount = valueCount;
        long indexFP = out.getFilePointer();
        int numInnerNodes = leafBlockStartValues.size();
        byte[] index = new byte[(1 + numInnerNodes) * (1 + this.bytesPerDim)];
        this.rotateToTree(1, 0, numInnerNodes, index, leafBlockStartValues);
        long[] arr = new long[leafBlockFPs.size()];
        for (int i = 0; i < leafBlockFPs.size(); ++i) {
            arr[i] = (Long)leafBlockFPs.get(i);
        }
        this.writeIndex(out, arr, index);
        return indexFP;
    }

    private void rotateToTree(int nodeID, int offset, int count, byte[] index, List<byte[]> leafBlockStartValues) {
        if (count == 1) {
            System.arraycopy(leafBlockStartValues.get(offset), 0, index, nodeID * (1 + this.bytesPerDim) + 1, this.bytesPerDim);
        } else {
            if (count > 1) {
                int countAtLevel = 1;
                int totalCount = 0;
                while (true) {
                    int countLeft;
                    if ((countLeft = count - totalCount) <= countAtLevel) {
                        int lastLeftCount = Math.min(countAtLevel / 2, countLeft);
                        assert (lastLeftCount >= 0);
                        int leftHalf = (totalCount - 1) / 2 + lastLeftCount;
                        int rootOffset = offset + leftHalf;
                        System.arraycopy(leafBlockStartValues.get(rootOffset), 0, index, nodeID * (1 + this.bytesPerDim) + 1, this.bytesPerDim);
                        this.rotateToTree(2 * nodeID, offset, leftHalf, index, leafBlockStartValues);
                        this.rotateToTree(2 * nodeID + 1, rootOffset + 1, count - leftHalf - 1, index, leafBlockStartValues);
                        return;
                    }
                    totalCount += countAtLevel;
                    countAtLevel *= 2;
                }
            }
            assert (count == 0);
        }
    }

    private void sortHeapPointWriter(final HeapPointWriter writer, final int dim) {
        int pointCount = Math.toIntExact(this.pointCount);
        new MSBRadixSorter(this.bytesPerDim + 4){

            @Override
            protected int byteAt(int i, int k) {
                assert (k >= 0);
                if (k < BKDWriter.this.bytesPerDim) {
                    int block = i / writer.valuesPerBlock;
                    int index = i % writer.valuesPerBlock;
                    return writer.blocks.get(block)[index * BKDWriter.this.packedBytesLength + dim * BKDWriter.this.bytesPerDim + k] & 0xFF;
                }
                int s = 3 - (k - BKDWriter.this.bytesPerDim);
                return writer.docIDs[i] >>> s * 8 & 0xFF;
            }

            @Override
            protected void swap(int i, int j) {
                int docID = writer.docIDs[i];
                writer.docIDs[i] = writer.docIDs[j];
                writer.docIDs[j] = docID;
                if (!BKDWriter.this.singleValuePerDoc) {
                    if (BKDWriter.this.longOrds) {
                        long ord = writer.ordsLong[i];
                        writer.ordsLong[i] = writer.ordsLong[j];
                        writer.ordsLong[j] = ord;
                    } else {
                        int ord = writer.ords[i];
                        writer.ords[i] = writer.ords[j];
                        writer.ords[j] = ord;
                    }
                }
                byte[] blockI = writer.blocks.get(i / writer.valuesPerBlock);
                int indexI = i % writer.valuesPerBlock * BKDWriter.this.packedBytesLength;
                byte[] blockJ = writer.blocks.get(j / writer.valuesPerBlock);
                int indexJ = j % writer.valuesPerBlock * BKDWriter.this.packedBytesLength;
                System.arraycopy(blockI, indexI, BKDWriter.this.scratch1, 0, BKDWriter.this.packedBytesLength);
                System.arraycopy(blockJ, indexJ, blockI, indexI, BKDWriter.this.packedBytesLength);
                System.arraycopy(BKDWriter.this.scratch1, 0, blockJ, indexJ, BKDWriter.this.packedBytesLength);
            }
        }.sort(0, pointCount);
    }

    private PointWriter sort(int dim) throws IOException {
        if (this.heapPointWriter != null) {
            HeapPointWriter sorted;
            assert (this.tempInput == null);
            if (dim == 0) {
                sorted = this.heapPointWriter;
            } else {
                sorted = new HeapPointWriter((int)this.pointCount, (int)this.pointCount, this.packedBytesLength, this.longOrds, this.singleValuePerDoc);
                sorted.copyFrom(this.heapPointWriter);
            }
            this.sortHeapPointWriter(sorted, dim);
            sorted.close();
            return sorted;
        }
        assert (this.tempInput != null);
        final int offset = this.bytesPerDim * dim;
        BytesRefComparator cmp = dim == this.numDims - 1 ? new BytesRefComparator(this.bytesPerDim + 4){

            @Override
            protected int byteAt(BytesRef ref, int i) {
                return ref.bytes[ref.offset + offset + i] & 0xFF;
            }
        } : new BytesRefComparator(this.bytesPerDim + 4){

            @Override
            protected int byteAt(BytesRef ref, int i) {
                if (i < BKDWriter.this.bytesPerDim) {
                    return ref.bytes[ref.offset + offset + i] & 0xFF;
                }
                return ref.bytes[ref.offset + BKDWriter.this.packedBytesLength + i - BKDWriter.this.bytesPerDim] & 0xFF;
            }
        };
        OfflineSorter sorter = new OfflineSorter(this.tempDir, this.tempFileNamePrefix + "_bkd" + dim, cmp, this.offlineSorterBufferMB, this.offlineSorterMaxTempFiles, this.bytesPerDoc){

            @Override
            protected OfflineSorter.ByteSequencesWriter getWriter(IndexOutput out) {
                return new OfflineSorter.ByteSequencesWriter(out){

                    @Override
                    public void write(byte[] bytes, int off, int len) throws IOException {
                        assert (len == BKDWriter.this.bytesPerDoc) : "len=" + len + " bytesPerDoc=" + BKDWriter.access$000(BKDWriter.this);
                        this.out.writeBytes(bytes, off, len);
                    }
                };
            }

            @Override
            protected OfflineSorter.ByteSequencesReader getReader(ChecksumIndexInput in, String name) throws IOException {
                return new OfflineSorter.ByteSequencesReader(in, name){
                    final BytesRef scratch;
                    {
                        this.scratch = new BytesRef(new byte[BKDWriter.this.bytesPerDoc]);
                    }

                    @Override
                    public BytesRef next() throws IOException {
                        if (this.in.getFilePointer() >= this.end) {
                            return null;
                        }
                        this.in.readBytes(this.scratch.bytes, 0, BKDWriter.this.bytesPerDoc);
                        return this.scratch;
                    }
                };
            }
        };
        String name = sorter.sort(this.tempInput.getName());
        return new OfflinePointWriter(this.tempDir, name, this.packedBytesLength, this.pointCount, this.longOrds, this.singleValuePerDoc);
    }

    private void checkMaxLeafNodeCount(int numLeaves) {
        if ((long)(1 + this.bytesPerDim) * (long)numLeaves > (long)ArrayUtil.MAX_ARRAY_LENGTH) {
            throw new IllegalStateException("too many nodes; increase maxPointsInLeafNode (currently " + this.maxPointsInLeafNode + ") and reindex");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long finish(IndexOutput out) throws IOException {
        if (this.heapPointWriter == null && this.tempInput == null) {
            throw new IllegalStateException("already finished");
        }
        if (this.offlinePointWriter != null) {
            this.offlinePointWriter.close();
        }
        if (this.pointCount == 0L) {
            throw new IllegalStateException("must index at least one point");
        }
        LongBitSet ordBitSet = this.numDims > 1 ? (this.singleValuePerDoc ? new LongBitSet(this.maxDoc) : new LongBitSet(this.pointCount)) : null;
        long countPerLeaf = this.pointCount;
        long innerNodeCount = 1L;
        while (countPerLeaf > (long)this.maxPointsInLeafNode) {
            countPerLeaf = (countPerLeaf + 1L) / 2L;
            innerNodeCount *= 2L;
        }
        int numLeaves = (int)innerNodeCount;
        this.checkMaxLeafNodeCount(numLeaves);
        byte[] splitPackedValues = new byte[Math.toIntExact(numLeaves * (1 + this.bytesPerDim))];
        long[] leafBlockFPs = new long[numLeaves];
        assert (this.pointCount / (long)numLeaves <= (long)this.maxPointsInLeafNode) : "pointCount=" + this.pointCount + " numLeaves=" + numLeaves + " maxPointsInLeafNode=" + this.maxPointsInLeafNode;
        PathSlice[] sortedPointWriters = new PathSlice[this.numDims];
        ArrayList<Closeable> toCloseHeroically = new ArrayList<Closeable>();
        boolean success = false;
        try {
            for (int dim = 0; dim < this.numDims; ++dim) {
                sortedPointWriters[dim] = new PathSlice(this.sort(dim), 0L, this.pointCount);
            }
            if (this.tempInput != null) {
                this.tempDir.deleteFile(this.tempInput.getName());
                this.tempInput = null;
            } else {
                assert (this.heapPointWriter != null);
                this.heapPointWriter = null;
            }
            this.build(1, numLeaves, sortedPointWriters, ordBitSet, out, this.minPackedValue, this.maxPackedValue, splitPackedValues, leafBlockFPs, toCloseHeroically);
            for (PathSlice slice : sortedPointWriters) {
                slice.writer.destroy();
            }
            assert (this.tempDir.getCreatedFiles().isEmpty());
            success = true;
        }
        finally {
            if (!success) {
                IOUtils.deleteFilesIgnoringExceptions((Directory)this.tempDir, this.tempDir.getCreatedFiles());
                IOUtils.closeWhileHandlingException(toCloseHeroically);
            }
        }
        long indexFP = out.getFilePointer();
        this.writeIndex(out, leafBlockFPs, splitPackedValues);
        return indexFP;
    }

    protected void writeIndex(IndexOutput out, long[] leafBlockFPs, byte[] splitPackedValues) throws IOException {
        CodecUtil.writeHeader(out, CODEC_NAME, 0);
        out.writeVInt(this.numDims);
        out.writeVInt(this.maxPointsInLeafNode);
        out.writeVInt(this.bytesPerDim);
        assert (leafBlockFPs.length > 0);
        out.writeVInt(leafBlockFPs.length);
        out.writeBytes(this.minPackedValue, 0, this.packedBytesLength);
        out.writeBytes(this.maxPackedValue, 0, this.packedBytesLength);
        out.writeVLong(this.pointCount);
        out.writeVInt(this.docsSeen.cardinality());
        out.writeBytes(splitPackedValues, 0, splitPackedValues.length);
        long lastFP = 0L;
        for (int i = 0; i < leafBlockFPs.length; ++i) {
            long delta = leafBlockFPs[i] - lastFP;
            out.writeVLong(delta);
            lastFP = leafBlockFPs[i];
        }
    }

    protected void writeLeafBlockDocs(IndexOutput out, int[] docIDs, int start, int count) throws IOException {
        assert (count > 0) : "maxPointsInLeafNode=" + this.maxPointsInLeafNode;
        out.writeVInt(count);
        for (int i = 0; i < count; ++i) {
            out.writeInt(docIDs[start + i]);
        }
    }

    protected void writeLeafBlockPackedValue(IndexOutput out, int[] commonPrefixLengths, byte[] bytes, int offset) throws IOException {
        for (int dim = 0; dim < this.numDims; ++dim) {
            int prefix = commonPrefixLengths[dim];
            out.writeBytes(bytes, offset + dim * this.bytesPerDim + prefix, this.bytesPerDim - prefix);
        }
    }

    protected void writeCommonPrefixes(IndexOutput out, int[] commonPrefixes, byte[] packedValue) throws IOException {
        for (int dim = 0; dim < this.numDims; ++dim) {
            out.writeVInt(commonPrefixes[dim]);
            out.writeBytes(packedValue, dim * this.bytesPerDim, commonPrefixes[dim]);
        }
    }

    @Override
    public void close() throws IOException {
        if (this.tempInput != null) {
            try {
                this.tempInput.close();
            }
            finally {
                this.tempDir.deleteFile(this.tempInput.getName());
                this.tempInput = null;
            }
        }
    }

    private void verifyChecksum(Throwable priorException, PointWriter writer) throws IOException {
        if (writer instanceof OfflinePointWriter) {
            String tempFileName = ((OfflinePointWriter)writer).name;
            try (ChecksumIndexInput in = this.tempDir.openChecksumInput(tempFileName, IOContext.READONCE);){
                CodecUtil.checkFooter(in, priorException);
            }
        } else {
            IOUtils.reThrow(priorException);
        }
    }

    private byte[] markRightTree(long rightCount, int splitDim, PathSlice source, LongBitSet ordBitSet) throws IOException {
        try (PointReader reader = source.writer.getReader(source.start + source.count - rightCount, rightCount);){
            boolean result = reader.next();
            assert (result);
            System.arraycopy(reader.packedValue(), splitDim * this.bytesPerDim, this.scratch1, 0, this.bytesPerDim);
            if (this.numDims > 1) {
                assert (!ordBitSet.get(reader.ord()));
                ordBitSet.set(reader.ord());
                reader.markOrds(rightCount - 1L, ordBitSet);
            }
        }
        catch (Throwable t) {
            this.verifyChecksum(t, source.writer);
        }
        return this.scratch1;
    }

    private boolean valueInBounds(BytesRef packedValue, byte[] minPackedValue, byte[] maxPackedValue) {
        for (int dim = 0; dim < this.numDims; ++dim) {
            int offset = this.bytesPerDim * dim;
            if (StringHelper.compare(this.bytesPerDim, packedValue.bytes, packedValue.offset + offset, minPackedValue, offset) < 0) {
                return false;
            }
            if (StringHelper.compare(this.bytesPerDim, packedValue.bytes, packedValue.offset + offset, maxPackedValue, offset) <= 0) continue;
            return false;
        }
        return true;
    }

    protected int split(byte[] minPackedValue, byte[] maxPackedValue) {
        int splitDim = -1;
        for (int dim = 0; dim < this.numDims; ++dim) {
            NumericUtils.subtract(this.bytesPerDim, dim, maxPackedValue, minPackedValue, this.scratchDiff);
            if (splitDim != -1 && StringHelper.compare(this.bytesPerDim, this.scratchDiff, 0, this.scratch1, 0) <= 0) continue;
            System.arraycopy(this.scratchDiff, 0, this.scratch1, 0, this.bytesPerDim);
            splitDim = dim;
        }
        return splitDim;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private PathSlice switchToHeap(PathSlice source, List<Closeable> toCloseHeroically) throws IOException {
        int count = Math.toIntExact(source.count);
        PointReader reader = source.writer.getSharedReader(source.start, source.count, toCloseHeroically);
        try (HeapPointWriter writer = new HeapPointWriter(count, count, this.packedBytesLength, this.longOrds, this.singleValuePerDoc);){
            for (int i = 0; i < count; ++i) {
                boolean hasNext = reader.next();
                assert (hasNext);
                writer.append(reader.packedValue(), reader.ord(), reader.docID());
            }
            PathSlice pathSlice = new PathSlice(writer, 0L, count);
            return pathSlice;
        }
        catch (Throwable t) {
            this.verifyChecksum(t, source.writer);
            return null;
        }
    }

    private void build(int nodeID, int leafNodeOffset, PathSlice[] slices, LongBitSet ordBitSet, IndexOutput out, byte[] minPackedValue, byte[] maxPackedValue, byte[] splitPackedValues, long[] leafBlockFPs, List<Closeable> toCloseHeroically) throws IOException {
        for (PathSlice slice : slices) {
            assert (slice.count == slices[0].count);
        }
        if (this.numDims == 1 && slices[0].writer instanceof OfflinePointWriter && slices[0].count <= (long)this.maxPointsSortInHeap) {
            slices[0] = this.switchToHeap(slices[0], toCloseHeroically);
        }
        if (nodeID >= leafNodeOffset) {
            block21: for (int dim = 0; dim < this.numDims; ++dim) {
                if (!(slices[dim].writer instanceof HeapPointWriter)) {
                    slices[dim] = this.switchToHeap(slices[dim], toCloseHeroically);
                }
                PathSlice source = slices[dim];
                HeapPointWriter heapSource = (HeapPointWriter)source.writer;
                heapSource.readPackedValue(Math.toIntExact(source.start), this.scratch1);
                heapSource.readPackedValue(Math.toIntExact(source.start + source.count - 1L), this.scratch2);
                int offset = dim * this.bytesPerDim;
                this.commonPrefixLengths[dim] = this.bytesPerDim;
                for (int j = 0; j < this.bytesPerDim; ++j) {
                    if (this.scratch1[offset + j] == this.scratch2[offset + j]) continue;
                    this.commonPrefixLengths[dim] = j;
                    continue block21;
                }
            }
            PathSlice source = slices[0];
            HeapPointWriter heapSource = (HeapPointWriter)source.writer;
            leafBlockFPs[nodeID - leafNodeOffset] = out.getFilePointer();
            int count = Math.toIntExact(source.count);
            assert (count > 0) : "nodeID=" + nodeID + " leafNodeOffset=" + leafNodeOffset;
            this.writeLeafBlockDocs(out, heapSource.docIDs, Math.toIntExact(source.start), count);
            this.writeCommonPrefixes(out, this.commonPrefixLengths, this.scratch1);
            byte[] lastPackedValue = new byte[this.bytesPerDim];
            for (int i = 0; i < count; ++i) {
                heapSource.getPackedValueSlice(Math.toIntExact(source.start + (long)i), this.scratchBytesRef);
                assert (this.numDims != 1 || this.valueInOrder(i, lastPackedValue, this.scratchBytesRef.bytes, this.scratchBytesRef.offset));
                assert (this.valueInBounds(this.scratchBytesRef, minPackedValue, maxPackedValue));
                this.writeLeafBlockPackedValue(out, this.commonPrefixLengths, this.scratchBytesRef.bytes, this.scratchBytesRef.offset);
            }
        } else {
            int dim;
            int splitDim = this.numDims > 1 ? this.split(minPackedValue, maxPackedValue) : 0;
            PathSlice source = slices[splitDim];
            assert (nodeID < splitPackedValues.length) : "nodeID=" + nodeID + " splitValues.length=" + splitPackedValues.length;
            long rightCount = source.count / 2L;
            long leftCount = source.count - rightCount;
            byte[] splitValue = this.markRightTree(rightCount, splitDim, source, ordBitSet);
            int address = nodeID * (1 + this.bytesPerDim);
            splitPackedValues[address] = (byte)splitDim;
            System.arraycopy(splitValue, 0, splitPackedValues, address + 1, this.bytesPerDim);
            PathSlice[] leftSlices = new PathSlice[this.numDims];
            PathSlice[] rightSlices = new PathSlice[this.numDims];
            byte[] minSplitPackedValue = new byte[this.packedBytesLength];
            System.arraycopy(minPackedValue, 0, minSplitPackedValue, 0, this.packedBytesLength);
            byte[] maxSplitPackedValue = new byte[this.packedBytesLength];
            System.arraycopy(maxPackedValue, 0, maxSplitPackedValue, 0, this.packedBytesLength);
            int dimToClear = this.numDims - 1 == splitDim ? this.numDims - 2 : this.numDims - 1;
            for (dim = 0; dim < this.numDims; ++dim) {
                if (dim == splitDim) {
                    leftSlices[dim] = new PathSlice(source.writer, source.start, leftCount);
                    rightSlices[dim] = new PathSlice(source.writer, source.start + leftCount, rightCount);
                    System.arraycopy(splitValue, 0, minSplitPackedValue, dim * this.bytesPerDim, this.bytesPerDim);
                    System.arraycopy(splitValue, 0, maxSplitPackedValue, dim * this.bytesPerDim, this.bytesPerDim);
                    continue;
                }
                PointReader reader = slices[dim].writer.getSharedReader(slices[dim].start, slices[dim].count, toCloseHeroically);
                try (PointWriter leftPointWriter = this.getPointWriter(leftCount, "left" + dim);
                     PointWriter rightPointWriter = this.getPointWriter(source.count - leftCount, "right" + dim);){
                    long nextRightCount = reader.split(source.count, ordBitSet, leftPointWriter, rightPointWriter, dim == dimToClear);
                    if (rightCount != nextRightCount) {
                        throw new IllegalStateException("wrong number of points in split: expected=" + rightCount + " but actual=" + nextRightCount);
                    }
                    leftSlices[dim] = new PathSlice(leftPointWriter, 0L, leftCount);
                    rightSlices[dim] = new PathSlice(rightPointWriter, 0L, rightCount);
                    continue;
                }
                catch (Throwable t) {
                    this.verifyChecksum(t, slices[dim].writer);
                }
            }
            this.build(2 * nodeID, leafNodeOffset, leftSlices, ordBitSet, out, minPackedValue, maxSplitPackedValue, splitPackedValues, leafBlockFPs, toCloseHeroically);
            for (dim = 0; dim < this.numDims; ++dim) {
                if (dim == splitDim) continue;
                leftSlices[dim].writer.destroy();
            }
            this.build(2 * nodeID + 1, leafNodeOffset, rightSlices, ordBitSet, out, minSplitPackedValue, maxPackedValue, splitPackedValues, leafBlockFPs, toCloseHeroically);
            for (dim = 0; dim < this.numDims; ++dim) {
                if (dim == splitDim) continue;
                rightSlices[dim].writer.destroy();
            }
        }
    }

    private boolean valueInOrder(long ord, byte[] lastPackedValue, byte[] packedValue, int packedValueOffset) {
        if (ord > 0L && StringHelper.compare(this.bytesPerDim, lastPackedValue, 0, packedValue, packedValueOffset) > 0) {
            throw new AssertionError((Object)("values out of order: last value=" + new BytesRef(lastPackedValue) + " current value=" + new BytesRef(packedValue, packedValueOffset, this.packedBytesLength) + " ord=" + ord));
        }
        System.arraycopy(packedValue, packedValueOffset, lastPackedValue, 0, this.bytesPerDim);
        return true;
    }

    PointWriter getPointWriter(long count, String desc) throws IOException {
        if (count <= (long)this.maxPointsSortInHeap) {
            int size = Math.toIntExact(count);
            return new HeapPointWriter(size, size, this.packedBytesLength, this.longOrds, this.singleValuePerDoc);
        }
        return new OfflinePointWriter(this.tempDir, this.tempFileNamePrefix, this.packedBytesLength, this.longOrds, desc, count, this.singleValuePerDoc);
    }

    private static class BKDMergeQueue
    extends PriorityQueue<MergeReader> {
        private final int bytesPerDim;

        public BKDMergeQueue(int bytesPerDim, int maxSize) {
            super(maxSize);
            this.bytesPerDim = bytesPerDim;
        }

        @Override
        public boolean lessThan(MergeReader a, MergeReader b) {
            assert (a != b);
            int cmp = StringHelper.compare(this.bytesPerDim, a.state.scratchPackedValue, 0, b.state.scratchPackedValue, 0);
            if (cmp < 0) {
                return true;
            }
            if (cmp > 0) {
                return false;
            }
            return a.docIDBase < b.docIDBase;
        }
    }

    private static class MergeReader {
        final BKDReader bkd;
        final BKDReader.IntersectState state;
        final MergeState.DocMap docMap;
        final int docIDBase;
        public int docID;
        private int docBlockUpto;
        private int docsInBlock;
        private int blockID;

        public MergeReader(BKDReader bkd, MergeState.DocMap docMap, int docIDBase) throws IOException {
            this.bkd = bkd;
            this.state = new BKDReader.IntersectState(bkd.in.clone(), bkd.numDims, bkd.packedBytesLength, bkd.maxPointsInLeafNode, null);
            this.docMap = docMap;
            this.docIDBase = docIDBase;
            long minFP = Long.MAX_VALUE;
            for (long fp : bkd.leafBlockFPs) {
                minFP = Math.min(minFP, fp);
            }
            this.state.in.seek(minFP);
        }

        public boolean next() throws IOException {
            int mappedDocID;
            do {
                if (this.docBlockUpto == this.docsInBlock) {
                    if (this.blockID == this.bkd.leafBlockFPs.length) {
                        return false;
                    }
                    this.docsInBlock = this.bkd.readDocIDs(this.state.in, this.state.in.getFilePointer(), this.state.scratchDocIDs);
                    assert (this.docsInBlock > 0);
                    this.docBlockUpto = 0;
                    for (int dim = 0; dim < this.bkd.numDims; ++dim) {
                        int prefix;
                        this.state.commonPrefixLengths[dim] = prefix = this.state.in.readVInt();
                        if (prefix <= 0) continue;
                        this.state.in.readBytes(this.state.scratchPackedValue, dim * this.bkd.bytesPerDim, prefix);
                    }
                    ++this.blockID;
                }
                int oldDocID = this.state.scratchDocIDs[this.docBlockUpto++];
                mappedDocID = this.docMap == null ? oldDocID : this.docMap.get(oldDocID);
                for (int dim = 0; dim < this.bkd.numDims; ++dim) {
                    int prefix = this.state.commonPrefixLengths[dim];
                    this.state.in.readBytes(this.state.scratchPackedValue, dim * this.bkd.bytesPerDim + prefix, this.bkd.bytesPerDim - prefix);
                }
            } while (mappedDocID == -1);
            this.docID = mappedDocID;
            return true;
        }
    }

    private static final class PathSlice {
        final PointWriter writer;
        final long start;
        final long count;

        public PathSlice(PointWriter writer, long start, long count) {
            this.writer = writer;
            this.start = start;
            this.count = count;
        }

        public String toString() {
            return "PathSlice(start=" + this.start + " count=" + this.count + " writer=" + this.writer + ")";
        }
    }
}

