/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.core.plugin;

import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.attribute.BasicFileAttributes;
import org.eclipse.core.runtime.Path;
import org.eclipse.osgi.service.resolver.BundleDescription;
import org.eclipse.pde.core.build.IBuildModel;
import org.eclipse.pde.internal.core.NLResourceHelper;
import org.eclipse.pde.internal.core.PDEManager;
import org.eclipse.pde.internal.core.PDEState;
import org.eclipse.pde.internal.core.plugin.AbstractPluginModelBase;

public abstract class ExternalPluginModelBase
extends AbstractPluginModelBase {
    private static final long serialVersionUID = 1L;
    private String fInstallLocation;
    private String fLocalization;

    @Override
    protected NLResourceHelper createNLResourceHelper() {
        return this.fLocalization == null ? null : new NLResourceHelper(this.fLocalization, PDEManager.getNLLookupLocations(this));
    }

    @Override
    @Deprecated
    public URL getNLLookupLocation() {
        try {
            if (this.fInstallLocation != null && new File(this.fInstallLocation).isDirectory() && !this.fInstallLocation.endsWith("/")) {
                return new URL("file:" + this.fInstallLocation + "/");
            }
            return new URL("file:" + this.fInstallLocation);
        }
        catch (MalformedURLException malformedURLException) {
            return null;
        }
    }

    @Override
    @Deprecated
    public IBuildModel getBuildModel() {
        return null;
    }

    @Override
    public String getInstallLocation() {
        return this.fInstallLocation;
    }

    @Override
    public boolean isEditable() {
        return false;
    }

    @Override
    public void load() {
    }

    @Override
    public void load(BundleDescription description, PDEState state) {
        Path path = new Path(description.getLocation());
        String device = path.getDevice();
        if (device != null) {
            path = path.setDevice(device.toUpperCase());
        }
        this.setInstallLocation(path.toOSString());
        this.fLocalization = state.getBundleLocalization(description.getBundleId());
        super.load(description, state);
    }

    @Override
    protected Long getResourceTimeStamp() {
        BasicFileAttributes installFileAttribute;
        java.nio.file.Path installFile = java.nio.file.Path.of(this.getInstallLocation(), new String[0]);
        try {
            installFileAttribute = Files.readAttributes(installFile, BasicFileAttributes.class, new LinkOption[0]);
        }
        catch (IOException iOException) {
            return null;
        }
        if (!installFileAttribute.isDirectory()) {
            return installFileAttribute.lastModifiedTime().toMillis();
        }
        try {
            java.nio.file.Path manifestFile = java.nio.file.Path.of(this.getInstallLocation(), "META-INF/MANIFEST.MF");
            return Files.getLastModifiedTime(manifestFile, new LinkOption[0]).toMillis();
        }
        catch (IOException iOException) {
            try {
                String xml = this.isFragmentModel() ? "fragment.xml" : "plugin.xml";
                File xmlFile = new File(this.getInstallLocation(), xml);
                return Files.getLastModifiedTime(xmlFile.toPath(), new LinkOption[0]).toMillis();
            }
            catch (IOException iOException2) {
                return null;
            }
        }
    }

    public void setInstallLocation(String newInstallLocation) {
        this.fInstallLocation = newInstallLocation;
    }

    public String getLocalization() {
        return this.fLocalization;
    }
}

