/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.cheatsheets.composite.views;

import java.io.IOException;
import java.lang.reflect.Constructor;
import java.net.URL;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.osgi.util.NLS;
import org.eclipse.ui.internal.cheatsheets.CheatSheetPlugin;
import org.eclipse.ui.internal.cheatsheets.Messages;
import org.eclipse.ui.internal.cheatsheets.registry.CheatSheetRegistryReader;
import org.eclipse.ui.internal.provisional.cheatsheets.TaskEditor;
import org.osgi.framework.Bundle;

public class TaskEditorManager {
    private static TaskEditorManager instance;

    private TaskEditorManager() {
    }

    public static TaskEditorManager getInstance() {
        if (instance == null) {
            instance = new TaskEditorManager();
        }
        return instance;
    }

    public TaskEditor getEditor(String editorKind) {
        CheatSheetRegistryReader.TaskEditorNode editorInfo = CheatSheetRegistryReader.getInstance().findTaskEditor(editorKind);
        if (editorInfo != null) {
            String message;
            TaskEditor editorInstance = null;
            Class extClass = null;
            String className = editorInfo.getClassName();
            try {
                Bundle bundle = Platform.getBundle((String)editorInfo.getPluginId());
                extClass = bundle.loadClass(className);
            }
            catch (Exception e) {
                message = NLS.bind((String)Messages.ERROR_LOADING_CLASS, (Object[])new Object[]{className});
                CheatSheetPlugin.getPlugin().getLog().error(message, (Throwable)e);
            }
            try {
                if (extClass != null) {
                    Constructor c = extClass.getConstructor(new Class[0]);
                    editorInstance = (TaskEditor)c.newInstance(new Object[0]);
                }
            }
            catch (Exception e) {
                message = NLS.bind((String)Messages.ERROR_CREATING_CLASS, (Object[])new Object[]{className});
                CheatSheetPlugin.getPlugin().getLog().error(message, (Throwable)e);
            }
            return editorInstance;
        }
        return null;
    }

    public ImageDescriptor getImageDescriptor(String editorKind) {
        Bundle bundle;
        URL url;
        CheatSheetRegistryReader.TaskEditorNode editorInfo = CheatSheetRegistryReader.getInstance().findTaskEditor(editorKind);
        if (editorInfo != null && (url = FileLocator.find((Bundle)(bundle = Platform.getBundle((String)editorInfo.getPluginId())), (IPath)new Path(editorInfo.getIconPath()), null)) != null) {
            try {
                url = FileLocator.resolve((URL)url);
                return ImageDescriptor.createFromURL((URL)url);
            }
            catch (IOException iOException) {
                return null;
            }
        }
        return null;
    }
}

