/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.emf.facet.custom.core.internal;

import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import org.eclipse.emf.common.util.BasicEList;
import org.eclipse.emf.common.util.EList;
import org.eclipse.papyrus.emf.facet.custom.metamodel.v0_2_0.custom.Customization;
import org.eclipse.papyrus.emf.facet.efacet.metamodel.v0_2_0.efacet.FacetSet;

public class CustomizationsDelegatingList
extends BasicEList<Customization> {
    private static final long serialVersionUID = 1L;
    private final List<FacetSet> delegate;

    public CustomizationsDelegatingList(List<FacetSet> delegate) {
        super(CustomizationsDelegatingList.customizations(delegate));
        this.delegate = delegate;
    }

    protected void didAdd(int index, Customization newObject) {
        if (index > 0) {
            index = this.delegate.indexOf(this.get(index - 1)) + 1;
        }
        this.delegate.add(index, (FacetSet)newObject);
    }

    protected void didSet(int index, Customization newObject, Customization oldObject) {
        index = this.delegate.indexOf(oldObject);
        this.delegate.set(index, (FacetSet)newObject);
    }

    protected void didRemove(int index, Customization oldObject) {
        this.delegate.remove(oldObject);
    }

    protected void didClear(int size, Object[] oldObjects) {
        this.delegate.removeAll(Arrays.asList(oldObjects));
    }

    protected void didMove(int index, Customization movedObject, int oldIndex) {
        if (index > 0) {
            index = this.delegate.indexOf(this.get(index - 1)) + 1;
        }
        if (this.delegate instanceof EList) {
            ((EList)this.delegate).move(index, (Object)movedObject);
        } else {
            this.delegate.remove(movedObject);
            this.delegate.add(index, (FacetSet)movedObject);
        }
    }

    protected static List<Customization> customizations(List<FacetSet> facetSets) {
        return facetSets.stream().filter(Customization.class::isInstance).map(Customization.class::cast).collect(Collectors.toList());
    }
}

