/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.compare.match.eobject;

import com.google.common.base.Function;
import com.google.common.base.Optional;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.emf.common.util.BasicDiagnostic;
import org.eclipse.emf.common.util.Diagnostic;
import org.eclipse.emf.common.util.Monitor;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.compare.CompareFactory;
import org.eclipse.emf.compare.Comparison;
import org.eclipse.emf.compare.ComparisonCanceledException;
import org.eclipse.emf.compare.EMFCompareMessages;
import org.eclipse.emf.compare.Match;
import org.eclipse.emf.compare.match.eobject.EObjectIndex;
import org.eclipse.emf.compare.match.eobject.IEObjectMatcher;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.ecore.util.InternalEList;
import org.eclipse.emf.ecore.xmi.XMIResource;

public class IdentifierEObjectMatcher
implements IEObjectMatcher {
    private Optional<IEObjectMatcher> delegate;
    private Function<EObject, String> idComputation = new DefaultIDFunction();
    private BasicDiagnostic diagnostic;

    public IdentifierEObjectMatcher() {
        this(null, new DefaultIDFunction());
    }

    public IdentifierEObjectMatcher(IEObjectMatcher delegateWhenNoID) {
        this(delegateWhenNoID, new DefaultIDFunction());
    }

    public IdentifierEObjectMatcher(Function<EObject, String> idComputation) {
        this(null, idComputation);
    }

    public IdentifierEObjectMatcher(IEObjectMatcher delegateWhenNoID, Function<EObject, String> idComputation) {
        this.delegate = Optional.fromNullable((Object)delegateWhenNoID);
        this.idComputation = idComputation;
    }

    @Override
    public void createMatches(Comparison comparison, Iterator<? extends EObject> leftEObjects, Iterator<? extends EObject> rightEObjects, Iterator<? extends EObject> originEObjects, Monitor monitor) {
        if (monitor.isCanceled()) {
            throw new ComparisonCanceledException();
        }
        ArrayList leftEObjectsNoID = Lists.newArrayList();
        ArrayList rightEObjectsNoID = Lists.newArrayList();
        ArrayList originEObjectsNoID = Lists.newArrayList();
        this.diagnostic = new BasicDiagnostic(0, "org.eclipse.emf.compare", 0, EMFCompareMessages.getString("IdentifierEObjectMatcher.diagnosticMessage"), null);
        Set<Match> matches = this.matchPerId(leftEObjects, rightEObjects, originEObjects, leftEObjectsNoID, rightEObjectsNoID, originEObjectsNoID);
        this.addDiagnostic(comparison);
        Iterables.addAll(comparison.getMatches(), matches);
        if (!(leftEObjectsNoID.isEmpty() && rightEObjectsNoID.isEmpty() && originEObjectsNoID.isEmpty())) {
            if (this.delegate.isPresent()) {
                this.doDelegation(comparison, leftEObjectsNoID, rightEObjectsNoID, originEObjectsNoID, monitor);
            } else {
                Match match;
                for (EObject eObject : leftEObjectsNoID) {
                    if (monitor.isCanceled()) {
                        throw new ComparisonCanceledException();
                    }
                    match = CompareFactory.eINSTANCE.createMatch();
                    match.setLeft(eObject);
                    matches.add(match);
                }
                for (EObject eObject : rightEObjectsNoID) {
                    if (monitor.isCanceled()) {
                        throw new ComparisonCanceledException();
                    }
                    match = CompareFactory.eINSTANCE.createMatch();
                    match.setRight(eObject);
                    matches.add(match);
                }
                for (EObject eObject : originEObjectsNoID) {
                    if (monitor.isCanceled()) {
                        throw new ComparisonCanceledException();
                    }
                    match = CompareFactory.eINSTANCE.createMatch();
                    match.setOrigin(eObject);
                    matches.add(match);
                }
            }
        }
    }

    protected void doDelegation(Comparison comparison, List<EObject> leftEObjectsNoID, List<EObject> rightEObjectsNoID, List<EObject> originEObjectsNoID, Monitor monitor) {
        ((IEObjectMatcher)this.delegate.get()).createMatches(comparison, leftEObjectsNoID.iterator(), rightEObjectsNoID.iterator(), originEObjectsNoID.iterator(), monitor);
    }

    protected Set<Match> matchPerId(Iterator<? extends EObject> leftEObjects, Iterator<? extends EObject> rightEObjects, Iterator<? extends EObject> originEObjects, List<EObject> leftEObjectsNoID, List<EObject> rightEObjectsNoID, List<EObject> originEObjectsNoID) {
        MatchComputation computation = new MatchComputation(leftEObjects, rightEObjects, originEObjects, leftEObjectsNoID, rightEObjectsNoID, originEObjectsNoID);
        computation.compute();
        return computation.getMatches();
    }

    protected EObject getParentEObject(EObject eObject) {
        EObject parent = eObject != null ? eObject.eContainer() : null;
        return parent;
    }

    private void reportDuplicateID(EObjectIndex.Side side, EObject eObject) {
        String duplicateID = (String)this.idComputation.apply((Object)eObject);
        String sideName = side.name().toLowerCase();
        String uriString = this.getUriString(eObject);
        String message = uriString != null ? EMFCompareMessages.getString("IdentifierEObjectMatcher.duplicateIdWithResource", duplicateID, sideName, uriString) : EMFCompareMessages.getString("IdentifierEObjectMatcher.duplicateId", duplicateID, sideName);
        this.diagnostic.add((Diagnostic)new BasicDiagnostic(2, "org.eclipse.emf.compare", 0, message, null));
    }

    private String getUriString(EObject eObject) {
        String uriString = null;
        Resource resource = eObject.eResource();
        if (resource != null && resource.getURI() != null) {
            URI uri = resource.getURI();
            uriString = uri.isPlatform() ? uri.toPlatformString(true) : uri.toString();
        }
        return uriString;
    }

    private void addDiagnostic(Comparison comparison) {
        if (comparison.getDiagnostic() == null) {
            comparison.setDiagnostic((Diagnostic)this.diagnostic);
        } else {
            ((BasicDiagnostic)comparison.getDiagnostic()).merge((Diagnostic)this.diagnostic);
        }
    }

    public static class DefaultIDFunction
    implements Function<EObject, String> {
        public String apply(EObject eObject) {
            String identifier;
            if (eObject == null) {
                identifier = null;
            } else if (eObject.eIsProxy()) {
                identifier = ((InternalEObject)eObject).eProxyURI().fragment();
            } else {
                Resource eObjectResource = eObject.eResource();
                String xmiID = eObjectResource instanceof XMIResource ? ((XMIResource)eObjectResource).getID(eObject) : null;
                identifier = xmiID != null ? xmiID : EcoreUtil.getID((EObject)eObject);
            }
            return identifier;
        }
    }

    private class MatchComputation {
        private final Set<Match> matches = Sets.newLinkedHashSet();
        private final Map<EObject, Match> leftEObjectsToMatch = Maps.newHashMap();
        private final Map<EObject, Match> rightEObjectsToMatch = Maps.newHashMap();
        private final Map<EObject, Match> originEObjectsToMatch = Maps.newHashMap();
        private Iterator<? extends EObject> leftEObjects;
        private Iterator<? extends EObject> rightEObjects;
        private Iterator<? extends EObject> originEObjects;
        private List<EObject> leftEObjectsNoID;
        private List<EObject> rightEObjectsNoID;
        private List<EObject> originEObjectsNoID;
        private SwitchMap<String, Match> idProxyMap;

        MatchComputation(Iterator<? extends EObject> leftEObjects, Iterator<? extends EObject> rightEObjects, Iterator<? extends EObject> originEObjects, List<EObject> leftEObjectsNoID, List<EObject> rightEObjectsNoID, List<EObject> originEObjectsNoID) {
            this.idProxyMap = new SwitchMap();
            this.leftEObjects = leftEObjects;
            this.rightEObjects = rightEObjects;
            this.originEObjects = originEObjects;
            this.leftEObjectsNoID = leftEObjectsNoID;
            this.rightEObjectsNoID = rightEObjectsNoID;
            this.originEObjectsNoID = originEObjectsNoID;
        }

        public Set<Match> getMatches() {
            return this.matches;
        }

        public void compute() {
            this.computeLeftSide();
            this.computeRightSide();
            this.computeOriginSide();
            this.reorganizeMatches();
        }

        private void computeLeftSide() {
            while (this.leftEObjects.hasNext()) {
                EObject left = this.leftEObjects.next();
                String identifier = (String)IdentifierEObjectMatcher.this.idComputation.apply((Object)left);
                if (identifier != null) {
                    Match match = CompareFactory.eINSTANCE.createMatch();
                    match.setLeft(left);
                    EObject parentEObject = IdentifierEObjectMatcher.this.getParentEObject(left);
                    Match parent = this.leftEObjectsToMatch.get(parentEObject);
                    if (parent != null) {
                        ((InternalEList)parent.getSubmatches()).addUnique((Object)match);
                    } else {
                        this.matches.add(match);
                    }
                    boolean isAlreadyContained = this.idProxyMap.put(left.eIsProxy(), identifier, match);
                    if (isAlreadyContained) {
                        IdentifierEObjectMatcher.this.reportDuplicateID(EObjectIndex.Side.LEFT, left);
                    }
                    this.leftEObjectsToMatch.put(left, match);
                    continue;
                }
                this.leftEObjectsNoID.add(left);
            }
        }

        private void computeRightSide() {
            while (this.rightEObjects.hasNext()) {
                EObject right = this.rightEObjects.next();
                String identifier = (String)IdentifierEObjectMatcher.this.idComputation.apply((Object)right);
                if (identifier != null) {
                    Match match = this.idProxyMap.get(right.eIsProxy(), identifier);
                    if (match != null) {
                        if (match.getRight() != null) {
                            IdentifierEObjectMatcher.this.reportDuplicateID(EObjectIndex.Side.RIGHT, right);
                        }
                        match.setRight(right);
                        this.rightEObjectsToMatch.put(right, match);
                        continue;
                    }
                    match = CompareFactory.eINSTANCE.createMatch();
                    match.setRight(right);
                    EObject parentEObject = IdentifierEObjectMatcher.this.getParentEObject(right);
                    Match parent = this.rightEObjectsToMatch.get(parentEObject);
                    if (parent != null) {
                        ((InternalEList)parent.getSubmatches()).addUnique((Object)match);
                    } else {
                        this.matches.add(match);
                    }
                    this.rightEObjectsToMatch.put(right, match);
                    this.idProxyMap.put(right.eIsProxy(), identifier, match);
                    continue;
                }
                this.rightEObjectsNoID.add(right);
            }
        }

        private void computeOriginSide() {
            while (this.originEObjects.hasNext()) {
                EObject origin = this.originEObjects.next();
                String identifier = (String)IdentifierEObjectMatcher.this.idComputation.apply((Object)origin);
                if (identifier != null) {
                    Match match = this.idProxyMap.get(origin.eIsProxy(), identifier);
                    if (match != null) {
                        if (match.getOrigin() != null) {
                            IdentifierEObjectMatcher.this.reportDuplicateID(EObjectIndex.Side.ORIGIN, origin);
                        }
                        match.setOrigin(origin);
                        this.originEObjectsToMatch.put(origin, match);
                        continue;
                    }
                    match = CompareFactory.eINSTANCE.createMatch();
                    match.setOrigin(origin);
                    EObject parentEObject = IdentifierEObjectMatcher.this.getParentEObject(origin);
                    Match parent = this.originEObjectsToMatch.get(parentEObject);
                    if (parent != null) {
                        ((InternalEList)parent.getSubmatches()).addUnique((Object)match);
                    } else {
                        this.matches.add(match);
                    }
                    this.idProxyMap.put(origin.eIsProxy(), identifier, match);
                    this.originEObjectsToMatch.put(origin, match);
                    continue;
                }
                this.originEObjectsNoID.add(origin);
            }
        }

        private void reorganizeMatches() {
            for (Match match : ImmutableSet.copyOf(this.matches)) {
                EObject parentEObject = IdentifierEObjectMatcher.this.getParentEObject(match.getLeft());
                Match parent = this.leftEObjectsToMatch.get(parentEObject);
                if (parent != null) {
                    this.matches.remove(match);
                    ((InternalEList)parent.getSubmatches()).addUnique((Object)match);
                    continue;
                }
                parentEObject = IdentifierEObjectMatcher.this.getParentEObject(match.getRight());
                parent = this.rightEObjectsToMatch.get(parentEObject);
                if (parent != null) {
                    this.matches.remove(match);
                    ((InternalEList)parent.getSubmatches()).addUnique((Object)match);
                    continue;
                }
                parentEObject = IdentifierEObjectMatcher.this.getParentEObject(match.getOrigin());
                parent = this.originEObjectsToMatch.get(parentEObject);
                if (parent == null) continue;
                this.matches.remove(match);
                ((InternalEList)parent.getSubmatches()).addUnique((Object)match);
            }
        }
    }

    private class SwitchMap<K, V> {
        final Map<K, V> trueMap = Maps.newHashMap();
        final Map<K, V> falseMap = Maps.newHashMap();

        private SwitchMap() {
        }

        public boolean put(boolean switcher, K key, V value) {
            Map<K, V> selectedMap = this.getMap(switcher);
            boolean isContained = selectedMap.containsKey(key);
            selectedMap.put(key, value);
            return isContained;
        }

        public V get(boolean switcher, K key) {
            Map<K, V> selectedMap = this.getMap(switcher);
            return selectedMap.get(key);
        }

        private Map<K, V> getMap(boolean switcher) {
            if (switcher) {
                return this.falseMap;
            }
            return this.trueMap;
        }
    }
}

