/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmf.runtime.emf.core.internal.util;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.gmf.runtime.emf.core.util.CrossReferenceAdapter;

public abstract class ReferenceVisitor {
    protected CrossReferenceAdapter crossReferencer = null;
    protected EObject referencedObject = null;

    public ReferenceVisitor(EObject eObject) {
        this.crossReferencer = CrossReferenceAdapter.getExistingCrossReferenceAdapter((Notifier)eObject);
        this.referencedObject = eObject;
    }

    public void visitReferencers() {
        if (this.crossReferencer != null) {
            Map featureMap = this.getGroupedReferencers(this.referencedObject);
            Object[] references = featureMap.keySet().toArray();
            int i = 0;
            while (i < references.length) {
                EReference reference = (EReference)references[i];
                List referencerList = (List)featureMap.get(reference);
                Object[] referencers = referencerList.toArray();
                int j = 0;
                while (j < referencers.length) {
                    EObject referencer = (EObject)referencerList.get(j);
                    this.visitedReferencer(reference, referencer);
                    ++j;
                }
                ++i;
            }
        }
    }

    protected abstract void visitedReferencer(EReference var1, EObject var2);

    private Map getGroupedReferencers(EObject referenced) {
        HashMap newMap = new HashMap();
        Collection nonNavigableInverseReferences = this.crossReferencer.getNonNavigableInverseReferences(referenced);
        if (nonNavigableInverseReferences != null && !nonNavigableInverseReferences.isEmpty()) {
            for (EStructuralFeature.Setting setting : nonNavigableInverseReferences) {
                ArrayList<EObject> list = (ArrayList<EObject>)newMap.get(setting.getEStructuralFeature());
                if (list == null) {
                    list = new ArrayList<EObject>();
                    list.add(setting.getEObject());
                    newMap.put(setting.getEStructuralFeature(), list);
                    continue;
                }
                list.add(setting.getEObject());
            }
        }
        EList features = referenced.eClass().getEAllReferences();
        for (EReference reference : features) {
            Set referencers;
            EReference opposite = reference.getEOpposite();
            if (opposite == null || !reference.isChangeable() || reference.isContainer() || reference.isContainment() || (referencers = this.crossReferencer.getInverseReferencers(referenced, opposite, null)).isEmpty()) continue;
            newMap.put(opposite, new ArrayList(referencers));
        }
        return Collections.unmodifiableMap(newMap);
    }
}

