/*
 * Decompiled with CFR 0.152.
 */
package ca.odell.glazedlists.swt;

import ca.odell.glazedlists.EventList;
import ca.odell.glazedlists.event.ListEvent;
import ca.odell.glazedlists.event.ListEventListener;
import ca.odell.glazedlists.swt.DefaultItemFormat;
import ca.odell.glazedlists.swt.ItemFormat;
import ca.odell.glazedlists.swt.Selectable;
import ca.odell.glazedlists.swt.SelectionManager;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultEventListViewer<E>
implements ListEventListener<E> {
    private boolean disposeSource;
    private List list;
    protected EventList<E> source;
    private ItemFormat<? super E> itemFormat;
    private SelectionManager<E> selection;

    public DefaultEventListViewer(EventList<E> source, List list) {
        this(source, list, new DefaultItemFormat());
    }

    public DefaultEventListViewer(EventList<E> source, List list, ItemFormat<? super E> itemFormat) {
        this(source, list, itemFormat, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected DefaultEventListViewer(EventList<E> source, List list, ItemFormat<? super E> itemFormat, boolean disposeSource) {
        this.disposeSource = disposeSource;
        source.getReadWriteLock().readLock().lock();
        try {
            this.source = source;
            this.list = list;
            this.itemFormat = itemFormat;
            this.selection = new SelectionManager<E>(this.source, new SelectableList());
            int n = this.source.size();
            for (int i = 0; i < n; ++i) {
                this.addRow(i, this.source.get(i));
            }
            this.source.addListEventListener(this);
        }
        finally {
            source.getReadWriteLock().readLock().unlock();
        }
    }

    public ItemFormat<? super E> getItemFormat() {
        return this.itemFormat;
    }

    public List getList() {
        return this.list;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public EventList<E> getDeselected() {
        this.source.getReadWriteLock().readLock().lock();
        try {
            EventList<E> eventList = this.selection.getSelectionList().getDeselected();
            return eventList;
        }
        finally {
            this.source.getReadWriteLock().readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public EventList<E> getTogglingDeselected() {
        this.source.getReadWriteLock().readLock().lock();
        try {
            EventList<E> eventList = this.selection.getSelectionList().getTogglingDeselected();
            return eventList;
        }
        finally {
            this.source.getReadWriteLock().readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public EventList<E> getSelected() {
        this.source.getReadWriteLock().readLock().lock();
        try {
            EventList<E> eventList = this.selection.getSelectionList().getSelected();
            return eventList;
        }
        finally {
            this.source.getReadWriteLock().readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public EventList<E> getTogglingSelected() {
        this.source.getReadWriteLock().readLock().lock();
        try {
            EventList<E> eventList = this.selection.getSelectionList().getTogglingSelected();
            return eventList;
        }
        finally {
            this.source.getReadWriteLock().readLock().unlock();
        }
    }

    private void addRow(int row, E value) {
        this.list.add(this.itemFormat.format(value), row);
    }

    private void updateRow(int row, E value) {
        this.list.setItem(row, this.itemFormat.format(value));
    }

    private void deleteRow(int row) {
        this.list.remove(row);
    }

    @Override
    public void listChanged(ListEvent<E> listChanges) {
        int firstModified = this.source.size();
        while (listChanges.next()) {
            int changeIndex = listChanges.getIndex();
            int changeType = listChanges.getType();
            if (changeType == 2) {
                this.addRow(changeIndex, this.source.get(changeIndex));
                firstModified = Math.min(changeIndex, firstModified);
                continue;
            }
            if (changeType == 1) {
                this.updateRow(changeIndex, this.source.get(changeIndex));
                continue;
            }
            if (changeType != 0) continue;
            this.deleteRow(changeIndex);
            firstModified = Math.min(changeIndex, firstModified);
        }
        this.selection.fireSelectionChanged(firstModified, this.source.size() - 1);
    }

    public void invertSelection() {
        this.selection.getSelectionList().invertSelection();
    }

    public void dispose() {
        this.selection.dispose();
        this.source.removeListEventListener(this);
        if (this.disposeSource) {
            this.source.dispose();
        }
    }

    private final class SelectableList
    implements Selectable {
        private SelectableList() {
        }

        public void addSelectionListener(SelectionListener listener) {
            DefaultEventListViewer.this.list.addSelectionListener(listener);
        }

        public void removeSelectionListener(SelectionListener listener) {
            DefaultEventListViewer.this.list.removeSelectionListener(listener);
        }

        public int getSelectionIndex() {
            return DefaultEventListViewer.this.list.getSelectionIndex();
        }

        public int[] getSelectionIndices() {
            return DefaultEventListViewer.this.list.getSelectionIndices();
        }

        public int getStyle() {
            return DefaultEventListViewer.this.list.getStyle();
        }

        public void select(int index) {
            DefaultEventListViewer.this.list.select(index);
        }

        public void deselect(int index) {
            DefaultEventListViewer.this.list.deselect(index);
        }
    }
}

