/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.modisco.facet.custom.ui.internal;

import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.command.CompoundCommand;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EParameter;
import org.eclipse.emf.ecore.ETypedElement;
import org.eclipse.emf.ecore.EcoreFactory;
import org.eclipse.emf.ecore.EcorePackage;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.modisco.facet.custom.metamodel.v0_2_0.custom.CustomFactory;
import org.eclipse.modisco.facet.custom.metamodel.v0_2_0.custom.CustomPackage;
import org.eclipse.modisco.facet.custom.metamodel.v0_2_0.custom.Customization;
import org.eclipse.modisco.facet.custom.metamodel.v0_2_0.custom.EClassCustomization;
import org.eclipse.modisco.facet.custom.metamodel.v0_2_0.custom.ETypedElementCase;
import org.eclipse.modisco.facet.custom.metamodel.v0_2_0.custom.ETypedElementSwitchQuery;
import org.eclipse.modisco.facet.custom.metamodel.v0_2_0.custom.FacetCustomization;
import org.eclipse.modisco.facet.custom.ui.internal.exception.CustomizationEditRuntimeException;
import org.eclipse.modisco.facet.custom.ui.internal.exported.ICustomizationCommandFactory;
import org.eclipse.modisco.facet.efacet.metamodel.v0_2_0.efacet.EFacetFactory;
import org.eclipse.modisco.facet.efacet.metamodel.v0_2_0.efacet.EFacetPackage;
import org.eclipse.modisco.facet.efacet.metamodel.v0_2_0.efacet.Facet;
import org.eclipse.modisco.facet.efacet.metamodel.v0_2_0.efacet.FacetAttribute;
import org.eclipse.modisco.facet.efacet.metamodel.v0_2_0.efacet.FacetOperation;
import org.eclipse.modisco.facet.efacet.metamodel.v0_2_0.efacet.extensible.Query;
import org.eclipse.modisco.facet.util.emf.core.command.ICommandFactoryResult;
import org.eclipse.modisco.facet.util.emf.core.command.ICommandFactoryResultFactory;
import org.eclipse.modisco.facet.util.emf.core.internal.exported.ICommandFactory;

public class CustomizationCommandFactory
implements ICustomizationCommandFactory {
    private static final String CONFORM_ATT_NAME = "isConforming";
    private final EditingDomain editingDomain;
    private final ICommandFactory commandFactory;

    public CustomizationCommandFactory(EditingDomain editingDomain, ICommandFactory commandFactory) {
        this.editingDomain = editingDomain;
        this.commandFactory = commandFactory;
    }

    @Override
    public ICommandFactoryResult<EClassCustomization> createEClassCustomization(Customization customization, EClass customedEClass, Query conformanceQuery) {
        EClassCustomization eClassCustom = CustomFactory.eINSTANCE.createEClassCustomization();
        CompoundCommand resultCmd = new CompoundCommand("Create one instance of EClassCustomization for " + customedEClass.getName());
        Command linkToContainer = this.commandFactory.createAddCommand(this.editingDomain, (Object)customization, (Object)EcorePackage.eINSTANCE.getEPackage_EClassifiers(), (Object)eClassCustom);
        resultCmd.append(linkToContainer);
        Command linkToEClass = this.commandFactory.createSetCommand(this.editingDomain, (Object)eClassCustom, (Object)EFacetPackage.eINSTANCE.getFacet_ExtendedMetaclass(), (Object)customedEClass);
        resultCmd.append(linkToEClass);
        if (conformanceQuery != null) {
            ICommandFactoryResult<FacetAttribute> attResult = this.createConformanceOperation((Facet)eClassCustom, conformanceQuery);
            resultCmd.append(attResult.getCommand());
        }
        return ICommandFactoryResultFactory.DEFAULT.createCommandFactoryResult((Command)resultCmd, (Object)eClassCustom);
    }

    private ICommandFactoryResult<FacetAttribute> createConformanceOperation(Facet facet, Query query) {
        CompoundCommand resultCmd = new CompoundCommand("Creates a facet conformance attribute");
        FacetAttribute conformanceAtt = EFacetFactory.eINSTANCE.createFacetAttribute();
        conformanceAtt.setName(CONFORM_ATT_NAME);
        conformanceAtt.setEType((EClassifier)EcorePackage.eINSTANCE.getEBoolean());
        conformanceAtt.setQuery(query);
        conformanceAtt.setDerived(true);
        Command conformance = this.commandFactory.createSetCommand(this.editingDomain, (Object)facet, (Object)EFacetPackage.eINSTANCE.getFacet_ConformanceTypedElement(), (Object)conformanceAtt);
        resultCmd.append(conformance);
        Command addToFacet = this.commandFactory.createAddCommand(this.editingDomain, (Object)facet, (Object)EFacetPackage.eINSTANCE.getFacet_FacetElements(), (Object)conformanceAtt);
        resultCmd.append(addToFacet);
        return ICommandFactoryResultFactory.DEFAULT.createCommandFactoryResult((Command)resultCmd, (Object)conformanceAtt);
    }

    @Override
    public ICommandFactoryResult<FacetCustomization> createFacetCustomization(Customization customization, Facet customizedFacet) {
        FacetCustomization eFacetCustom = CustomFactory.eINSTANCE.createFacetCustomization();
        CompoundCommand resultCmd = new CompoundCommand("Create one instance of FacetCustomization for " + customizedFacet.getName());
        Command linkToContainer = this.commandFactory.createAddCommand(this.editingDomain, (Object)customization, (Object)EcorePackage.eINSTANCE.getEPackage_EClassifiers(), (Object)eFacetCustom);
        resultCmd.append(linkToContainer);
        Command linkToFacet = this.commandFactory.createAddCommand(this.editingDomain, (Object)customization, (Object)CustomPackage.eINSTANCE.getFacetCustomization_CustomizedFacet(), (Object)customizedFacet);
        resultCmd.append(linkToFacet);
        return ICommandFactoryResultFactory.DEFAULT.createCommandFactoryResult((Command)resultCmd, (Object)eFacetCustom);
    }

    @Override
    public ICommandFactoryResult<Facet> setPropertyConfig(Facet typeCustomization, ETypedElement customizedTElt, FacetOperation customProperty, Query query) {
        CompoundCommand resultCmd = new CompoundCommand("Set the value of the customization property '" + customProperty.getName() + "'");
        FacetOperation fOpToModifiy = null;
        for (FacetOperation facetOperation : typeCustomization.getFacetOperations()) {
            if (!facetOperation.getOverride().equals(customProperty)) continue;
            fOpToModifiy = facetOperation;
        }
        if (fOpToModifiy == null) {
            this.createPropertySetting(typeCustomization, customizedTElt, customProperty, query, resultCmd);
        } else {
            Query fOpQuery = fOpToModifiy.getQuery();
            if (fOpQuery instanceof ETypedElementSwitchQuery) {
                ETypedElementSwitchQuery switchQuery = (ETypedElementSwitchQuery)fOpQuery;
                Command setCase = this.setOrCreateETypedElementCase(switchQuery, customizedTElt, query);
                resultCmd.append(setCase);
            } else {
                throw new CustomizationEditRuntimeException();
            }
        }
        return ICommandFactoryResultFactory.DEFAULT.createCommandFactoryResult((Command)resultCmd, (Object)typeCustomization);
    }

    private void createPropertySetting(Facet typeCustomization, ETypedElement customizedTElt, FacetOperation customProperty, Query query, CompoundCommand resultCmd) {
        FacetOperation facetOperation = EFacetFactory.eINSTANCE.createFacetOperation();
        Command linkFOpToParent = this.commandFactory.createAddCommand(this.editingDomain, (Object)typeCustomization, (Object)EFacetPackage.eINSTANCE.getFacet_FacetOperations(), (Object)facetOperation);
        resultCmd.append(linkFOpToParent);
        Command linkToOverride = this.commandFactory.createSetCommand(this.editingDomain, (Object)facetOperation, (Object)EFacetPackage.eINSTANCE.getDerivedTypedElement_Override(), (Object)customProperty);
        resultCmd.append(linkToOverride);
        facetOperation.setName(customProperty.getName());
        facetOperation.setEType(customProperty.getEType());
        facetOperation.setLowerBound(customProperty.getLowerBound());
        facetOperation.setUpperBound(customProperty.getUpperBound());
        EParameter eParameter = EcoreFactory.eINSTANCE.createEParameter();
        eParameter.setName("eStructuralFeature");
        eParameter.setEType((EClassifier)EcorePackage.eINSTANCE.getETypedElement());
        facetOperation.getEParameters().add((Object)eParameter);
        ETypedElementSwitchQuery switchQuery = CustomFactory.eINSTANCE.createETypedElementSwitchQuery();
        Command switchToParent = this.commandFactory.createSetCommand(this.editingDomain, (Object)facetOperation, (Object)EFacetPackage.eINSTANCE.getDerivedTypedElement_Query(), (Object)switchQuery);
        resultCmd.append(switchToParent);
        Command setCase = this.setOrCreateETypedElementCase(switchQuery, customizedTElt, query);
        resultCmd.append(setCase);
    }

    private Command setOrCreateETypedElementCase(ETypedElementSwitchQuery switchQuery, ETypedElement customizedTElt, Query query) {
        CompoundCommand resultCmd = new CompoundCommand("Set or create an instance of ETypedElementCase");
        ETypedElementCase caseToModify = CustomizationCommandFactory.getCaseByETypedElement(switchQuery, customizedTElt);
        if (caseToModify == null) {
            caseToModify = CustomFactory.eINSTANCE.createETypedElementCase();
            Command linkToParent = this.commandFactory.createAddCommand(this.editingDomain, (Object)switchQuery, (Object)CustomPackage.eINSTANCE.getETypedElementSwitchQuery_Cases(), (Object)caseToModify);
            resultCmd.append(linkToParent);
        }
        Command setCase = this.commandFactory.createSetCommand(this.editingDomain, (Object)caseToModify, (Object)CustomPackage.eINSTANCE.getETypedElementCase_Case(), (Object)customizedTElt);
        resultCmd.append(setCase);
        Command setQuery = this.commandFactory.createSetCommand(this.editingDomain, (Object)caseToModify, (Object)CustomPackage.eINSTANCE.getETypedElementCase_Value(), (Object)query);
        resultCmd.append(setQuery);
        return resultCmd;
    }

    private static ETypedElementCase getCaseByETypedElement(ETypedElementSwitchQuery switchQuery, ETypedElement customizedTElt) {
        ETypedElementCase caseToModify = null;
        for (ETypedElementCase casee : switchQuery.getCases()) {
            if (casee.getCase() == null) {
                if (customizedTElt != null) continue;
                caseToModify = casee;
                continue;
            }
            if (!casee.getCase().equals(customizedTElt)) continue;
            caseToModify = casee;
            break;
        }
        return caseToModify;
    }

    @Override
    public ICommandFactoryResult<Customization> createCustomization(String name) {
        Customization customization = CustomFactory.eINSTANCE.createCustomization();
        Command setName = this.commandFactory.createSetCommand(this.editingDomain, (Object)customization, (Object)EcorePackage.eINSTANCE.getENamedElement_Name(), (Object)name);
        return ICommandFactoryResultFactory.DEFAULT.createCommandFactoryResult(setName, (Object)customization);
    }
}

