/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.modisco.infra.prefuse.examples.graphview;

import java.awt.Container;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import org.eclipse.modisco.infra.prefuse.examples.graphview.GraphMenuAction;
import org.eclipse.modisco.infra.prefuse.examples.graphview.GraphView;
import org.eclipse.modisco.infra.prefuse.examples.graphview.Messages;
import org.eclipse.modisco.infra.prefuse.examples.graphview.OpenGraphAction;
import prefuse.data.Graph;
import prefuse.util.GraphLib;

public class GraphViewUtils {
    public static JFrame demo(Graph g, String label) {
        final GraphView view = new GraphView(g, label);
        JMenu dataMenu = new JMenu(Messages.GraphViewUtils_Data);
        dataMenu.add(new OpenGraphAction(view));
        dataMenu.add(new GraphMenuAction(Messages.GraphViewUtils_Grid, "ctrl 1", view){

            protected Graph getGraph() {
                return GraphLib.getGrid((int)15, (int)15);
            }
        });
        dataMenu.add(new GraphMenuAction(Messages.GraphViewUtils_Clique, "ctrl 2", view){

            protected Graph getGraph() {
                return GraphLib.getClique((int)10);
            }
        });
        dataMenu.add(new GraphMenuAction(Messages.GraphViewUtils_Honeycomb, "ctrl 3", view){

            protected Graph getGraph() {
                return GraphLib.getHoneycomb((int)5);
            }
        });
        dataMenu.add(new GraphMenuAction(Messages.GraphViewUtils_BalancedTree, "ctrl 4", view){

            protected Graph getGraph() {
                return GraphLib.getBalancedTree((int)3, (int)5);
            }
        });
        dataMenu.add(new GraphMenuAction(Messages.GraphViewUtils_DiamondTree, "ctrl 5", view){

            protected Graph getGraph() {
                return GraphLib.getDiamondTree((int)3, (int)3, (int)3);
            }
        });
        JMenuBar menubar = new JMenuBar();
        menubar.add(dataMenu);
        JFrame frame = new JFrame(Messages.GraphViewUtils_JFrameTitle);
        frame.setJMenuBar(menubar);
        frame.setContentPane((Container)((Object)view));
        frame.pack();
        frame.setVisible(true);
        frame.addWindowListener(new WindowAdapter(){

            public void windowActivated(WindowEvent e) {
                view.getVisualization().run("layout");
            }

            public void windowDeactivated(WindowEvent e) {
                view.getVisualization().cancel("layout");
            }
        });
        return frame;
    }
}

