/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.modisco.workflow.ui.internal.wizard;

import java.util.HashMap;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchManager;
import org.eclipse.debug.ui.DebugUITools;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.modisco.infra.common.core.logging.MoDiscoLogger;
import org.eclipse.modisco.workflow.core.internal.defaultengine.WorkflowController;
import org.eclipse.modisco.workflow.core.internal.defaultengine.WorkflowControllerImpl;
import org.eclipse.modisco.workflow.ui.internal.Activator;
import org.eclipse.modisco.workflow.ui.internal.Messages;
import org.eclipse.modisco.workflow.ui.internal.Utils;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableItem;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LaunchersPage
extends WizardPage {
    private static final int HEIGHT = 400;
    private static final int WIDTH = 450;
    private Table launchersTable;
    private final HashMap<TableItem, ILaunchConfiguration> launchConfigurationMap;
    private TableItem[] itemsSelected;
    private final WorkflowController workflowController;
    private final String rootConfigName;

    public TableItem[] getItemsSelected() {
        return this.itemsSelected;
    }

    public HashMap<TableItem, ILaunchConfiguration> getLaunchConfigurationMap() {
        return this.launchConfigurationMap;
    }

    protected LaunchersPage(String rootConfigName) {
        super(Messages.LaunchersPage_launchersList);
        this.setImageDescriptor(Activator.getImageDescriptor("icons/workflow_banner.png"));
        this.setDescription(Messages.LaunchersPage_wizardDescription);
        this.workflowController = new WorkflowControllerImpl();
        this.rootConfigName = rootConfigName;
        this.itemsSelected = new TableItem[0];
        this.launchConfigurationMap = new HashMap();
    }

    public void createControl(Composite parent) {
        Composite container = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        container.setLayout((Layout)layout);
        int numColumns = 3;
        layout.numColumns = 3;
        int verticalSpacing = 9;
        layout.verticalSpacing = 9;
        GridData gridData = new GridData();
        gridData.horizontalSpan = 2;
        gridData.grabExcessHorizontalSpace = true;
        gridData.horizontalAlignment = 4;
        gridData.verticalAlignment = 4;
        gridData.grabExcessVerticalSpace = true;
        this.launchersTable = new Table(container, 2562);
        this.launchersTable.setLayoutData((Object)gridData);
        this.launchersTable.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                LaunchersPage.this.launcherSelected();
            }
        });
        this.launchersTable.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseDoubleClick(MouseEvent e) {
                LaunchersPage.this.getWizard().performFinish();
                LaunchersPage.this.getShell().close();
            }
        });
        this.setTitle(Messages.LaunchersPage_selectLaunchConfig);
        this.loadLauncher();
        this.initializeDialogUnits((Control)container);
        this.setControl((Control)container);
    }

    protected void launcherSelected() {
        this.itemsSelected = this.launchersTable.getSelection();
        this.setPageComplete(true);
    }

    private final void loadLauncher() {
        ILaunchManager manager = DebugPlugin.getDefault().getLaunchManager();
        boolean recursionMessage = false;
        try {
            ILaunchConfiguration[] iLaunchConfigurationArray = manager.getLaunchConfigurations();
            int n = iLaunchConfigurationArray.length;
            int n2 = 0;
            while (n2 < n) {
                ILaunchConfiguration launch = iLaunchConfigurationArray[n2];
                if (this.workflowController.hasPotentialRecursion(this.rootConfigName, launch)) {
                    recursionMessage = true;
                } else {
                    TableItem item = new TableItem(this.launchersTable, 0);
                    item.setText(launch.getName());
                    item.setImage(DebugUITools.getImage((String)launch.getType().getIdentifier()));
                    this.launchConfigurationMap.put(item, launch);
                }
                ++n2;
            }
        }
        catch (CoreException e) {
            MoDiscoLogger.logError((Throwable)e, (Plugin)Activator.getDefault());
        }
        if (recursionMessage) {
            this.setMessage(Messages.LaunchersPage_messageExtended);
        } else {
            this.setMessage(Messages.LaunchersPage_message);
        }
        this.setPageComplete(false);
    }

    public void setVisible(boolean visible) {
        if (visible) {
            this.getShell().setSize(450, 400);
            this.getShell().setLocation(Utils.centerShell(this.getShell()));
        }
        super.setVisible(visible);
    }
}

