/*
 * Decompiled with CFR 0.152.
 */
package prefuse.util.display;

import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.Iterator;
import prefuse.Display;
import prefuse.visual.VisualItem;

public class DisplayLib {
    private DisplayLib() {
    }

    public static Rectangle2D getBounds(Iterator iter, double margin, Rectangle2D b) {
        Rectangle2D nb;
        VisualItem item;
        b.setFrame(Double.NaN, Double.NaN, Double.NaN, Double.NaN);
        if (iter.hasNext()) {
            item = (VisualItem)iter.next();
            nb = item.getBounds();
            b.setFrame(nb);
        }
        while (iter.hasNext()) {
            item = (VisualItem)iter.next();
            nb = item.getBounds();
            double x1 = nb.getMinX() < b.getMinX() ? nb.getMinX() : b.getMinX();
            double x2 = nb.getMaxX() > b.getMaxX() ? nb.getMaxX() : b.getMaxX();
            double y1 = nb.getMinY() < b.getMinY() ? nb.getMinY() : b.getMinY();
            double y2 = nb.getMaxY() > b.getMaxY() ? nb.getMaxY() : b.getMaxY();
            b.setFrame(x1, y1, x2 - x1, y2 - y1);
        }
        b.setFrame(b.getMinX() - margin, b.getMinY() - margin, b.getWidth() + 2.0 * margin, b.getHeight() + 2.0 * margin);
        return b;
    }

    public static Rectangle2D getBounds(Iterator iter, double margin) {
        Rectangle2D.Double b = new Rectangle2D.Double();
        return DisplayLib.getBounds(iter, margin, b);
    }

    public static Point2D getCentroid(Iterator iter, Point2D p) {
        double cx = 0.0;
        double cy = 0.0;
        int count = 0;
        while (iter.hasNext()) {
            VisualItem item = (VisualItem)iter.next();
            double x = item.getX();
            double y = item.getY();
            if (Double.isInfinite(x) || Double.isNaN(x) || Double.isInfinite(y) || Double.isNaN(y)) continue;
            cx += x;
            cy += y;
            ++count;
        }
        if (count > 0) {
            cx /= (double)count;
            cy /= (double)count;
        }
        p.setLocation(cx, cy);
        return p;
    }

    public static Point2D getCentroid(Iterator iter) {
        return DisplayLib.getCentroid(iter, new Point2D.Double());
    }

    public static void fitViewToBounds(Display display, Rectangle2D bounds, long duration) {
        DisplayLib.fitViewToBounds(display, bounds, null, duration);
    }

    public static void fitViewToBounds(Display display, Rectangle2D bounds, Point2D center, long duration) {
        double w = display.getWidth();
        double h = display.getHeight();
        double cx = center == null ? bounds.getCenterX() : center.getX();
        double cy = center == null ? bounds.getCenterY() : center.getY();
        double wb = Math.max(cx - bounds.getMinX(), bounds.getMaxX() - cx);
        double hb = Math.max(cy - bounds.getMinY(), bounds.getMaxY() - cy);
        double scale = Math.min(w / (2.0 * wb), h / (2.0 * hb)) / display.getScale();
        if (center == null) {
            center = new Point2D.Double(cx, cy);
        }
        if (duration > 0L) {
            display.animatePanAndZoomToAbs(center, scale, duration);
        } else {
            display.panToAbs(center);
            display.zoomAbs(center, scale);
        }
    }
}

