/*
 * Decompiled with CFR 0.152.
 */
package prefuse.util;

import java.awt.Font;
import prefuse.util.collections.IntObjectHashMap;

public class FontLib {
    private static final IntObjectHashMap fontMap = new IntObjectHashMap();
    private static int misses = 0;
    private static int lookups = 0;

    public static Font getFont(String name, double size) {
        int isize = (int)Math.floor(size);
        return FontLib.getFont(name, 0, isize);
    }

    public static Font getFont(String name, int style, double size) {
        int isize = (int)Math.floor(size);
        return FontLib.getFont(name, style, isize);
    }

    public static Font getFont(String name, int style, int size) {
        int key = (name.hashCode() << 8) + (size << 2) + style;
        Font f = null;
        f = (Font)fontMap.get(key);
        if (f == null) {
            f = new Font(name, style, size);
            fontMap.put(key, f);
            ++misses;
        }
        ++lookups;
        return f;
    }

    public static int getCacheMissCount() {
        return misses;
    }

    public static int getCacheLookupCount() {
        return lookups;
    }

    public static void clearCache() {
        fontMap.clear();
    }

    public static Font getIntermediateFont(Font f1, Font f2, double frac) {
        int style;
        String name;
        if (frac < 0.5) {
            name = f1.getName();
            style = f1.getStyle();
        } else {
            name = f2.getName();
            style = f2.getStyle();
        }
        int size = (int)Math.round(frac * (double)f2.getSize() + (1.0 - frac) * (double)f1.getSize());
        return FontLib.getFont(name, style, size);
    }
}

