/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtend.middleend.xtend.internal.xtendlib;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import org.eclipse.xtend.backend.aop.ThisJoinPoint;
import org.eclipse.xtend.backend.aop.ThisJoinPointStaticPart;
import org.eclipse.xtend.backend.common.BackendType;
import org.eclipse.xtend.backend.common.ExecutionContext;
import org.eclipse.xtend.backend.common.Function;
import org.eclipse.xtend.backend.common.NamedFunction;
import org.eclipse.xtend.backend.common.Property;
import org.eclipse.xtend.backend.common.QualifiedName;
import org.eclipse.xtend.backend.common.StaticProperty;
import org.eclipse.xtend.backend.syslib.CollectionOperations;
import org.eclipse.xtend.backend.syslib.SysLibNames;
import org.eclipse.xtend.backend.types.builtin.CollectionType;
import org.eclipse.xtend.backend.types.builtin.FunctionType;
import org.eclipse.xtend.backend.types.builtin.ObjectType;
import org.eclipse.xtend.backend.types.builtin.PropertyType;
import org.eclipse.xtend.backend.types.builtin.StaticPropertyType;
import org.eclipse.xtend.backend.types.emf.EObjectType;
import org.eclipse.xtend.backend.types.java.internal.JavaBeansType;
import org.eclipse.xtend.middleend.javaannotations.AbstractExecutionContextAware;
import org.eclipse.xtend.middleend.javaannotations.M2tCached;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class XtendBuiltinOperations
extends AbstractExecutionContextAware {
    public Long xtendCompareTo(Object target, Object o) {
        if (target == null) {
            return o == null ? new Long(0L) : new Long(-1L);
        }
        if (o == null) {
            return new Long(1L);
        }
        if (target instanceof Comparable) {
            return new Long(((Comparable)target).compareTo(o));
        }
        String s1 = (String)this._ctx.getFunctionDefContext().invoke(this._ctx, new QualifiedName("toString"), Arrays.asList(target));
        String s2 = (String)this._ctx.getFunctionDefContext().invoke(this._ctx, new QualifiedName("toString"), Arrays.asList(target));
        return new Long(s1.compareTo(s2));
    }

    public BackendType XtendMetaType(Object o) {
        return this._ctx.getTypesystem().findType(o);
    }

    @M2tCached
    public String XtendStringReplaceFirst(String s, String regex, String replacement) {
        return s.replaceFirst(regex, replacement);
    }

    @M2tCached
    public List<Long> XtendUpto(Long target, Long v) {
        ArrayList<Long> result = new ArrayList<Long>();
        Long l1 = target;
        while (l1.compareTo(v) <= 0) {
            result.add(l1);
            l1 = l1 + 1L;
        }
        return result;
    }

    @M2tCached
    public List<Integer> XtendUpto(Integer target, Integer v) {
        ArrayList<Integer> result = new ArrayList<Integer>();
        Integer l1 = target;
        while (l1.compareTo(v) <= 0) {
            result.add(l1);
            l1 = l1 + 1;
        }
        return result;
    }

    @M2tCached
    public List<Long> XtendUpto(Long target, Long v, Long inc) {
        ArrayList<Long> result = new ArrayList<Long>();
        Long l1 = target;
        while (l1.compareTo(v) <= 0) {
            result.add(l1);
            l1 = l1 + inc;
        }
        return result;
    }

    @M2tCached
    public List<Integer> XtendUpto(Integer target, Integer v, Integer inc) {
        ArrayList<Integer> result = new ArrayList<Integer>();
        Integer l1 = target;
        while (l1.compareTo(v) <= 0) {
            result.add(l1);
            l1 = l1 + inc;
        }
        return result;
    }

    public Set<StaticProperty> XtendTypeAllStaticProperties(BackendType target) {
        HashSet<StaticProperty> result = new HashSet<StaticProperty>();
        result.addAll(target.getStaticProperties().values());
        for (BackendType superType : target.getSuperTypes()) {
            result.addAll(superType.getStaticProperties().values());
        }
        return result;
    }

    public Set XtendTypeAllFeatures(BackendType target) {
        HashSet<Object> result = new HashSet<Object>();
        result.addAll(this.XtendTypeAllProperties(target));
        result.addAll(this.XtendTypeAllOperations(target));
        result.addAll(this.XtendTypeAllStaticProperties(target));
        return result;
    }

    public Set<NamedFunction> XtendTypeAllOperations(BackendType target) {
        HashSet<NamedFunction> result = new HashSet<NamedFunction>();
        Collection builtinOps = target.getBuiltinOperations();
        for (NamedFunction f : builtinOps) {
            if (!this.isXtendOperation(target, f)) continue;
            result.add(f);
        }
        result.addAll(target.getBuiltinOperations());
        Collection superTypes = target.getSuperTypes();
        for (BackendType backendType : superTypes) {
            backendType.getBuiltinOperations();
            Collection funcs = this._ctx.getFunctionDefContext().getByFirstParameterType(backendType);
            for (NamedFunction namedFunction : funcs) {
                if (!this.isXtendOperation(target, namedFunction)) continue;
                result.add(namedFunction);
            }
        }
        return result;
    }

    public Set<Object> XtendTypeAllProperties(BackendType target) {
        HashSet<Object> result = new HashSet<Object>();
        result.addAll(target.getProperties(this._ctx).values());
        for (BackendType superType : target.getSuperTypes()) {
            result.addAll(superType.getProperties(this._ctx).values());
        }
        Set<NamedFunction> accessors = this.XtendTypeAllOperations(target);
        for (NamedFunction accessorFunc : accessors) {
            if (!this.isFunctionBackedProperty(accessorFunc)) continue;
            result.add(accessorFunc);
        }
        return result;
    }

    public Set<BackendType> XtendTypeSuperTypes(BackendType target) {
        HashSet<BackendType> result = new HashSet<BackendType>();
        result.addAll(target.getSuperTypes());
        return result;
    }

    public String XtendTypeDocumentation(BackendType target) {
        return "";
    }

    public String XtendTypeDocumentation(Object target) {
        return "";
    }

    public String XtendTypeDocumentation(EObjectType target) {
        return "base type for all ecore based metamodels (added by oAW4 emftools)";
    }

    public String XtendTypeDocumentation(JavaBeansType target) {
        return "";
    }

    public String XtendTypeDocumentation(NamedFunction target) {
        return "";
    }

    public String XtendTypeDocumentation(Property target) {
        return "";
    }

    public String XtendTypeDocumentation(StaticProperty target) {
        return "";
    }

    public Object XtendTypeGetProperty(BackendType target, CharSequence propertyName) {
        QualifiedName xtendNameFunc = new QualifiedName("XtendName");
        for (Property prop : target.getProperties(this._ctx).values()) {
            String name = (String)this._ctx.getFunctionDefContext().invoke(this._ctx, xtendNameFunc, Arrays.asList(prop));
            if (!propertyName.toString().equals(name)) continue;
            return prop;
        }
        for (BackendType superType : this.XtendTypeSuperTypes(target)) {
            for (Property prop : superType.getProperties(this._ctx).values()) {
                String name = (String)this._ctx.getFunctionDefContext().invoke(this._ctx, xtendNameFunc, Arrays.asList(prop));
                if (!propertyName.toString().equals(name)) continue;
                return prop;
            }
        }
        NamedFunction builtinFunc = this.XtendTypeGetOperation(target, propertyName.toString(), new ArrayList<BackendType>());
        if (this.isXtendOperation(target, builtinFunc)) {
            return builtinFunc;
        }
        return null;
    }

    public Object XtendTypeGetFeature(BackendType target, String featureName, List<BackendType> paramTypes) {
        String name;
        QualifiedName xtendNameFunc = new QualifiedName("XtendName");
        for (Property prop : target.getProperties(this._ctx).values()) {
            name = (String)this._ctx.getFunctionDefContext().invoke(this._ctx, xtendNameFunc, Arrays.asList(prop));
            if (!featureName.equals(name)) continue;
            return prop;
        }
        for (StaticProperty staticProp : target.getStaticProperties().values()) {
            name = (String)this._ctx.getFunctionDefContext().invoke(this._ctx, xtendNameFunc, Arrays.asList(staticProp));
            if (!featureName.equals(name)) continue;
            return staticProp;
        }
        NamedFunction builtinFunc = this.XtendTypeGetOperation(target, featureName, paramTypes);
        if (builtinFunc != null) {
            return builtinFunc;
        }
        for (BackendType superType : this.XtendTypeSuperTypes(target)) {
            String name2;
            for (Property prop : superType.getProperties(this._ctx).values()) {
                name2 = (String)this._ctx.getFunctionDefContext().invoke(this._ctx, xtendNameFunc, Arrays.asList(prop));
                if (!featureName.equals(name2)) continue;
                return prop;
            }
            for (StaticProperty staticProp : target.getStaticProperties().values()) {
                name2 = (String)this._ctx.getFunctionDefContext().invoke(this._ctx, xtendNameFunc, Arrays.asList(staticProp));
                if (!featureName.equals(name2)) continue;
                return staticProp;
            }
        }
        return null;
    }

    public NamedFunction XtendTypeGetOperation(BackendType target, String functionName, List<BackendType> paramTypes) {
        LinkedList<BackendType> pTypes = new LinkedList<BackendType>();
        pTypes.add(0, target);
        pTypes.addAll(paramTypes);
        String convertedName = this.toBackendBuiltinFeatureName(functionName);
        if (convertedName == null) {
            convertedName = functionName;
        }
        Collection canditates = (Collection)this._ctx.getFunctionDefContext().invoke(this._ctx, new QualifiedName("XtendTypeAllOperations"), Arrays.asList(target));
        canditates.addAll(this._ctx.getFunctionDefContext().getByFirstParameterType(target));
        Function matchedInnerFunc = this._ctx.getFunctionDefContext().getMatch(this._ctx, new QualifiedName(functionName), pTypes);
        if (matchedInnerFunc == null) {
            matchedInnerFunc = this._ctx.getFunctionDefContext().getMatch(this._ctx, new QualifiedName(convertedName), pTypes);
        }
        for (NamedFunction f : canditates) {
            if (!f.getFunction().equals(matchedInnerFunc)) continue;
            return f;
        }
        return null;
    }

    public List<? extends BackendType> XtendOperationGetParameterTypes(NamedFunction target) {
        List params = target.getFunction().getParameterTypes();
        return params.subList(1, params.size());
    }

    public Object XtendOperationEvaluate(NamedFunction f, Object target, List params) {
        params.add(0, target);
        return this._ctx.getFunctionInvoker().invoke(this._ctx, f.getFunction(), params);
    }

    public BackendType XtendFeatureReturnType(NamedFunction f) {
        return f.getFunction().getReturnType();
    }

    public BackendType XtendFeatureReturnType(Property p) {
        return p.getType(this._ctx.getTypesystem());
    }

    public BackendType XtendFeatureReturnType(StaticProperty p) {
        return p.getType();
    }

    public BackendType XtendFeatureOwner(Property target) {
        return target.getOwner();
    }

    public BackendType XtendFeatureOwner(StaticProperty target) {
        return target.getOwner();
    }

    public BackendType XtendFeatureOwner(NamedFunction target) {
        return (BackendType)target.getFunction().getParameterTypes().get(0);
    }

    public Object XtendName(NamedFunction f) {
        String name = f.getName().getFullQualifiedName();
        String xpandName = this.toXpandBuiltinFeatureName(name);
        if (xpandName != null) {
            return xpandName;
        }
        return name;
    }

    public Object XtendName(Property p) {
        String name = p.getName();
        String xpandName = this.toXpandBuiltinFeatureName(name);
        if (xpandName != null) {
            return xpandName;
        }
        return name;
    }

    public Object XtendName(StaticProperty p) {
        String name = p.getName();
        String xpandName = this.toXpandBuiltinFeatureName(name);
        if (xpandName != null) {
            return xpandName;
        }
        return name;
    }

    public Object XtendName(Object target) {
        BackendType t = this._ctx.getTypesystem().findType(target);
        if (CollectionType.INSTANCE.isAssignableFrom(t)) {
            if (this.isProperty(this._ctx, t, "name")) {
                return t.getProperty(this._ctx, target, "name");
            }
            Collection result = CollectionOperations.createMatchingCollection((Collection)((Collection)target));
            for (Object obj : (Collection)target) {
                Object[] args = new Object[]{obj};
                CollectionOperations.addFlattened((Collection)result, (Object)this._ctx.getFunctionDefContext().getMatch(this._ctx, new QualifiedName("XtendName"), Arrays.asList(this._ctx.getTypesystem().findType(obj))).invoke(this._ctx, args));
            }
            return result;
        }
        return t.getProperty(this._ctx, target, "name");
    }

    public List<?> adviceCtxParamValues(ThisJoinPoint jp) {
        return jp.getParameters();
    }

    public List<? extends BackendType> adviceCtxParamTypes(ThisJoinPoint jp) {
        ThisJoinPointStaticPart joinPointStaticPart = (ThisJoinPointStaticPart)this._ctx.getLocalVarContext().getLocalVars().get("thisJoinPointStaticPart");
        if (joinPointStaticPart != null) {
            return joinPointStaticPart.getFunction().getParameterTypes();
        }
        return null;
    }

    public List<String> adviceCtxParamNames(ThisJoinPoint jp) {
        ThisJoinPointStaticPart joinPointStaticPart = (ThisJoinPointStaticPart)this._ctx.getLocalVarContext().getLocalVars().get("thisJoinPointStaticPart");
        if (joinPointStaticPart != null) {
            return (List)this._ctx.getFunctionDefContext().invoke(this._ctx, new QualifiedName("getOperationParamNames"), Arrays.asList(joinPointStaticPart.getFunction()));
        }
        return null;
    }

    public String xtendDefinitionName(ThisJoinPoint jp) {
        ThisJoinPointStaticPart joinPointStaticPart = (ThisJoinPointStaticPart)this._ctx.getLocalVarContext().getLocalVars().get("thisJoinPointStaticPart");
        if (joinPointStaticPart != null) {
            Function f = joinPointStaticPart.getFunction();
            BackendType targetType = (BackendType)f.getParameterTypes().get(0);
            Collection canditates = this._ctx.getFunctionDefContext().getByFirstParameterType(targetType);
            for (NamedFunction namedFunction : canditates) {
                if (!namedFunction.getFunction().equals(f)) continue;
                return namedFunction.getName().getFullQualifiedName();
            }
        }
        return null;
    }

    public Object xtendDefinitionToString(ThisJoinPoint jp) {
        if (jp.getParameters().size() > 0) {
            Object target = jp.getParameters().get(0);
            return this._ctx.getFunctionDefContext().invoke(this._ctx, new QualifiedName("toString"), Arrays.asList(target));
        }
        return null;
    }

    public String adviceCtxName(ThisJoinPoint jp) {
        ThisJoinPointStaticPart joinPointStaticPart = (ThisJoinPointStaticPart)this._ctx.getLocalVarContext().getLocalVars().get("thisJoinPointStaticPart");
        if (joinPointStaticPart != null) {
            return joinPointStaticPart.getFunctionName().getFullQualifiedName();
        }
        return null;
    }

    public List<? extends BackendType> xtendDefinitionParamTypes(ThisJoinPoint jp) {
        ThisJoinPointStaticPart joinPointStaticPart = (ThisJoinPointStaticPart)this._ctx.getLocalVarContext().getLocalVars().get("thisJoinPointStaticPart");
        if (joinPointStaticPart != null) {
            List parameterTypes = joinPointStaticPart.getFunction().getParameterTypes();
            return parameterTypes.subList(1, parameterTypes.size());
        }
        return null;
    }

    public BackendType adviceCtxTargetType(ThisJoinPoint jp) {
        List parameterTypes;
        ThisJoinPointStaticPart joinPointStaticPart = (ThisJoinPointStaticPart)this._ctx.getLocalVarContext().getLocalVars().get("thisJoinPointStaticPart");
        if (joinPointStaticPart != null && (parameterTypes = joinPointStaticPart.getFunction().getParameterTypes()) != null && parameterTypes.size() > 0) {
            return (BackendType)parameterTypes.get(0);
        }
        return null;
    }

    public List<String> xtendDefinitionParamNames(ThisJoinPoint jp) {
        List paramNames;
        ThisJoinPointStaticPart joinPointStaticPart = (ThisJoinPointStaticPart)this._ctx.getLocalVarContext().getLocalVars().get("thisJoinPointStaticPart");
        if (joinPointStaticPart != null && (paramNames = (List)this._ctx.getFunctionDefContext().invoke(this._ctx, new QualifiedName("getOperationParamNames"), Arrays.asList(joinPointStaticPart.getFunction()))) != null) {
            return paramNames.subList(1, paramNames.size());
        }
        return null;
    }

    public Object XtendName(ThisJoinPoint jp) {
        ThisJoinPointStaticPart joinPointStaticPart = (ThisJoinPointStaticPart)this._ctx.getLocalVarContext().getLocalVars().get("thisJoinPointStaticPart");
        if (joinPointStaticPart != null) {
            return joinPointStaticPart.getFunctionName().getFullQualifiedName();
        }
        return null;
    }

    private boolean isProperty(ExecutionContext ctx, BackendType t, String propName) {
        return t.getProperties(ctx).containsKey(propName);
    }

    private boolean isFunctionBackedProperty(NamedFunction f) {
        BackendType targetType = (BackendType)f.getFunction().getParameterTypes().get(0);
        if (f.getName().getFullQualifiedName().equals("XtendName")) {
            return !targetType.equals(ObjectType.INSTANCE);
        }
        if (f.getName().getFullQualifiedName().equals("XtendMetaType")) {
            return true;
        }
        if (f.getName().getFullQualifiedName().equals("XpandIteratorElements")) {
            return true;
        }
        if (f.getName().getFullQualifiedName().equals("XtendTypeAllFeatures")) {
            return true;
        }
        if (f.getName().getFullQualifiedName().equals("XtendTypeAllOperations")) {
            return true;
        }
        if (f.getName().getFullQualifiedName().equals("XtendTypeAllProperties")) {
            return true;
        }
        if (f.getName().getFullQualifiedName().equals("XtendTypeAllStaticProperties")) {
            return true;
        }
        return f.getName().getFullQualifiedName().equals("XtendTypeSuperTypes");
    }

    private boolean isXtendOperation(BackendType target, NamedFunction f) {
        BackendType funcTargetType = (BackendType)f.getFunction().getParameterTypes().get(0);
        if (f.getName().getFullQualifiedName().equals("XtendName")) {
            if (FunctionType.INSTANCE.isAssignableFrom(funcTargetType)) {
                return true;
            }
            if (PropertyType.INSTANCE.isAssignableFrom(funcTargetType)) {
                return true;
            }
            return StaticPropertyType.INSTANCE.isAssignableFrom(funcTargetType);
        }
        return !f.getName().getFullQualifiedName().equals("concat") || !funcTargetType.equals(ObjectType.INSTANCE) || target.getBuiltinOperations().contains(f);
    }

    private String toBackendBuiltinFeatureName(String name) {
        if (name.equals("name")) {
            return "XtendName";
        }
        if (name.equals("metaType")) {
            return "XtendMetaType";
        }
        if (name.equals("allFeatures")) {
            return "XtendTypeAllFeatures";
        }
        if (name.equals("allOperations")) {
            return "XtendTypeAllOperations";
        }
        if (name.equals("allProperties")) {
            return "XtendTypeAllProperties";
        }
        if (name.equals("elements")) {
            return "XpandIteratorElements";
        }
        if (name.equals("<")) {
            return "operatorLess";
        }
        if (name.equals(">")) {
            return "operatorGreater";
        }
        if (name.equals("<=")) {
            return "operatorLessOrEquals";
        }
        if (name.equals(">=")) {
            return "operatorGreaterOrEquals";
        }
        if (name.equals("==")) {
            return SysLibNames.OPERATOR_EQUALS;
        }
        if (name.equals("!=")) {
            return "operatorNotEquals";
        }
        if (name.equals("!")) {
            return "operatorNot";
        }
        if (name.equals("+")) {
            return "operatorPlus";
        }
        if (name.equals("-")) {
            return "operatorMinus";
        }
        if (name.equals("*")) {
            return "operatorMult";
        }
        if (name.equals("/")) {
            return "operatorDiv";
        }
        if (name.equals("%")) {
            return "operatorMod";
        }
        if (name.equals("compareTo")) {
            return "xtendCompareTo";
        }
        if (name.equals("add")) {
            return "XtendAdd";
        }
        if (name.equals("addAll")) {
            return "XtendAddAll";
        }
        if (name.equals("remove")) {
            return "XtendRemove";
        }
        if (name.equals("removeAll")) {
            return "XtendRemoveAll";
        }
        return null;
    }

    private String toXpandBuiltinFeatureName(String name) {
        if (name.equals("XtendName")) {
            return "name";
        }
        if (name.equals("XtendMetaType")) {
            return "metaType";
        }
        if (name.equals("XtendTypeAllFeatures")) {
            return "allFeatures";
        }
        if (name.equals("XtendTypeAllOperations")) {
            return "allOperations";
        }
        if (name.equals("XtendTypeAllProperties")) {
            return "allProperties";
        }
        if (name.equals("XpandIteratorElements")) {
            return "elements";
        }
        if (name.equals("operatorLess")) {
            return "<";
        }
        if (name.equals("operatorGreater")) {
            return ">";
        }
        if (name.equals("operatorLessOrEquals")) {
            return "<=";
        }
        if (name.equals("operatorGreaterOrEquals")) {
            return ">=";
        }
        if (name.equals(SysLibNames.OPERATOR_EQUALS)) {
            return "==";
        }
        if (name.equals("operatorNotEquals")) {
            return "!=";
        }
        if (name.equals("operatorNot")) {
            return "!";
        }
        if (name.equals("operatorPlus")) {
            return "+";
        }
        if (name.equals("operatorMinus")) {
            return "-";
        }
        if (name.equals("operatorMult")) {
            return "*";
        }
        if (name.equals("operatorDiv")) {
            return "/";
        }
        if (name.equals("operatorMod")) {
            return "%";
        }
        if (name.equals("xtendCompareTo")) {
            return "compareTo";
        }
        if (name.equals("XtendAdd")) {
            return "add";
        }
        if (name.equals("XtendAddAll")) {
            return "addAll";
        }
        if (name.equals("XtendRemove")) {
            return "remove";
        }
        if (name.equals("XtendRemoveAll")) {
            return "removeAll";
        }
        return null;
    }
}

