/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtend.middleend.javaannotations;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import org.eclipse.emf.mwe.core.resources.ResourceLoader;
import org.eclipse.emf.mwe.core.resources.ResourceLoaderFactory;
import org.eclipse.xtend.backend.aop.AdviceParamType;
import org.eclipse.xtend.backend.aop.AroundAdvice;
import org.eclipse.xtend.backend.aop.ExecutionPointcut;
import org.eclipse.xtend.backend.common.Function;
import org.eclipse.xtend.backend.common.NamedFunction;
import org.eclipse.xtend.backend.common.QualifiedName;
import org.eclipse.xtend.backend.expr.LocalVarEvalExpression;
import org.eclipse.xtend.backend.expr.MethodInvocationExpression;
import org.eclipse.xtend.backend.types.builtin.ObjectType;
import org.eclipse.xtend.backend.util.Pair;
import org.eclipse.xtend.middleend.MiddleEnd;
import org.eclipse.xtend.middleend.javaannotations.ExecutionContextAware;
import org.eclipse.xtend.middleend.javaannotations.M2tAroundAdvice;
import org.eclipse.xtend.middleend.javaannotations.M2tImport;
import org.eclipse.xtend.middleend.javaannotations.M2tImports;
import org.eclipse.xtend.middleend.javaannotations.M2tNoFunction;
import org.eclipse.xtend.middleend.javaannotations.M2tPointcut;
import org.eclipse.xtend.middleend.javaannotations.M2tPrivateFunction;
import org.eclipse.xtend.middleend.javaannotations.M2tQualifiedName;
import org.eclipse.xtend.middleend.javaannotations.internal.JavaDefinedFunction;
import org.eclipse.xtend.middleend.plugins.ImportedResource;
import org.eclipse.xtend.middleend.plugins.LanguageSpecificMiddleEnd;
import org.eclipse.xtend.middleend.plugins.ParsedResource;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class JavaFunctionClassContributor
implements LanguageSpecificMiddleEnd {
    public static final String MIDDLE_END_NAME = "JavaAnnotations";
    private ResourceLoader _resourceLoader = null;
    private MiddleEnd _middleEnd = null;

    private ResourceLoader getResourceLoader() {
        if (this._resourceLoader == null) {
            this._resourceLoader = ResourceLoaderFactory.createResourceLoader();
        }
        return this._resourceLoader;
    }

    @Override
    public boolean canHandle(String resourceName) {
        return this.getCls(resourceName) != null;
    }

    private Class<?> getCls(String resourceName) {
        try {
            return this.getResourceLoader().loadClass(resourceName.replace('/', '.').replace("::", "."));
        }
        catch (Throwable throwable) {
            return null;
        }
    }

    @Override
    public ParsedResource parseResource(String resourceName) {
        ParsedResource result = new ParsedResource();
        if (JavaFunctionClassContributor.classAsResource(Object.class).equals(resourceName)) {
            return result;
        }
        Class<?> cls = this.getCls(resourceName);
        Method[] methodArray = cls.getDeclaredMethods();
        int n = methodArray.length;
        int n2 = 0;
        while (n2 < n) {
            Method mtd = methodArray[n2];
            if (this.isPublic(mtd) && !this.isInfrastructureMethod(mtd, cls) && mtd.getAnnotation(M2tNoFunction.class) == null) {
                boolean isPublicFunction = mtd.getAnnotation(M2tPrivateFunction.class) == null && mtd.getAnnotation(M2tAroundAdvice.class) == null;
                boolean isAroundAdvice = mtd.getAnnotation(M2tAroundAdvice.class) != null;
                QualifiedName functionName = mtd.getAnnotation(M2tQualifiedName.class) != null ? new QualifiedName(cls.getCanonicalName().replaceAll(".", "::"), mtd.getName()) : new QualifiedName(mtd.getName());
                NamedFunction f = new NamedFunction(functionName, new JavaDefinedFunction(mtd, null, this._middleEnd.getTypesystem()));
                if (isPublicFunction) {
                    result.getPublicFunctions().add(f);
                } else if (isAroundAdvice) {
                    result.getAdvice().add(this.createAdvice(f, mtd));
                } else {
                    result.getPrivateFunctions().add(f);
                }
            }
            ++n2;
        }
        M2tImports importsAnn = cls.getAnnotation(M2tImports.class);
        if (importsAnn != null) {
            M2tImport[] m2tImportArray = importsAnn.imports();
            int n3 = m2tImportArray.length;
            n = 0;
            while (n < n3) {
                M2tImport imp = m2tImportArray[n];
                String impResPath = imp.resource().replaceAll("\\.", "::");
                impResPath.replaceAll("/", "::");
                result.getImports().add(new ImportedResource(impResPath, imp.reexport()));
                ++n;
            }
        }
        return result;
    }

    private boolean isPublic(Method mtd) {
        return (mtd.getModifiers() & 1) != 0;
    }

    private boolean isInfrastructureMethod(Method mtd, Class<?> cls) {
        if (ExecutionContextAware.class.isAssignableFrom(cls)) {
            try {
                ExecutionContextAware.class.getMethod(mtd.getName(), mtd.getParameterTypes());
                return true;
            }
            catch (NoSuchMethodException noSuchMethodException) {}
        }
        return false;
    }

    private AroundAdvice createAdvice(NamedFunction f, Method mtd) {
        Function inner = f.getFunction();
        if (inner instanceof JavaDefinedFunction) {
            M2tAroundAdvice adviceAnn = mtd.getAnnotation(M2tAroundAdvice.class);
            M2tPointcut pointcutAnn = adviceAnn.pointcut();
            ArrayList<NamedFunction> adviceBodyJavaFunctions = null;
            adviceBodyJavaFunctions = (ArrayList<NamedFunction>)this._middleEnd.getExecutionContext().getContributionStateContext().retrieveState("AdviceBodyJavaDefinedFunctions");
            if (adviceBodyJavaFunctions == null) {
                adviceBodyJavaFunctions = new ArrayList<NamedFunction>();
                this._middleEnd.getExecutionContext().getContributionStateContext().storeState("AdviceBodyJavaDefinedFunctions", adviceBodyJavaFunctions);
            }
            adviceBodyJavaFunctions.add(f);
            String[] paramTypeNames = pointcutAnn.paramTypeNames();
            ArrayList<Pair<String, AdviceParamType>> paramTypes = new ArrayList<Pair<String, AdviceParamType>>();
            int i = 0;
            while (i < paramTypeNames.length) {
                String paramTypeName = paramTypeNames[i];
                if (!paramTypeName.equals("*")) {
                    AdviceParamType paramType = new AdviceParamType(this._middleEnd.getTypesystem().findType(paramTypeName), true);
                    Pair<String, AdviceParamType> paramTypePair = new Pair<String, AdviceParamType>("o" + i + 1, paramType);
                    paramTypes.add(paramTypePair);
                }
                ++i;
            }
            new AdviceParamType(this._middleEnd.getTypesystem().findType(ObjectType.INSTANCE.getUniqueRepresentation()), true);
            ExecutionPointcut pointcut = new ExecutionPointcut(pointcutAnn.namePattern(), paramTypes, pointcutAnn.hasVarArgs(), null);
            MethodInvocationExpression body = new MethodInvocationExpression(mtd, Arrays.asList(new LocalVarEvalExpression("thisJoinPoint", null)), false, null);
            AroundAdvice adv = new AroundAdvice(body, pointcut, true);
            return adv;
        }
        throw new IllegalArgumentException("Advice definition " + f.getName() + " is not a JavaDefinedFunction");
    }

    @Override
    public String getName() {
        return MIDDLE_END_NAME;
    }

    @Override
    public void setMiddleEnd(MiddleEnd middleEnd) {
        this._middleEnd = middleEnd;
    }

    public static String classAsResource(Class<?> cls) {
        return cls.getName().replace('.', '/');
    }
}

