/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtend.backend.expr;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.xtend.backend.common.BackendType;
import org.eclipse.xtend.backend.common.BackendTypesystem;
import org.eclipse.xtend.backend.common.ExecutionContext;
import org.eclipse.xtend.backend.common.ExpressionBase;
import org.eclipse.xtend.backend.common.SourcePos;
import org.eclipse.xtend.backend.functions.java.internal.JavaBuiltinConverter;
import org.eclipse.xtend.backend.functions.java.internal.JavaBuiltinConverterFactory;
import org.eclipse.xtend.backend.functions.java.internal.ParameterConverter;
import org.eclipse.xtend.backend.util.ErrorHandler;
import org.eclipse.xtend.middleend.javaannotations.ExecutionContextAware;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MethodInvocationExpression
extends ExpressionBase {
    private final Method _mtd;
    private final boolean _isStatic;
    private final List<ParameterConverter> _parameterConverters = new ArrayList<ParameterConverter>();
    private final JavaBuiltinConverter _returnValueConverter;
    private final List<? extends ExpressionBase> _params;
    private final boolean _nullIfFirstParamIsNull;
    private Class<?> _clazz;

    public MethodInvocationExpression(Method mtd, List<? extends ExpressionBase> params, boolean nullIfFirstParamIsNull, SourcePos sourcePos) {
        super(sourcePos);
        this._mtd = mtd;
        this._clazz = mtd.getDeclaringClass();
        this._params = params;
        this._nullIfFirstParamIsNull = nullIfFirstParamIsNull;
        int i = 0;
        while (i < mtd.getParameterTypes().length) {
            ParameterConverter pc = JavaBuiltinConverterFactory.getParameterConverter(mtd.getParameterTypes()[i], i);
            if (pc != null) {
                this._parameterConverters.add(pc);
            }
            ++i;
        }
        this._returnValueConverter = JavaBuiltinConverterFactory.getConverter(mtd.getReturnType());
        this._isStatic = (mtd.getModifiers() & 8) != 0;
    }

    public Method getMethod() {
        return this._mtd;
    }

    public List<? extends ExpressionBase> getParams() {
        return this._params;
    }

    public boolean isNullIfFirstParamIsNull() {
        return this._nullIfFirstParamIsNull;
    }

    /*
     * Could not resolve type clashes
     * Unable to fully structure code
     */
    @Override
    protected Object evaluateInternal(ExecutionContext ctx) {
        params = new ArrayList<Object>();
        for (ExpressionBase expr : this._params) {
            params.add(expr.evaluate(ctx));
        }
        if (this._nullIfFirstParamIsNull && params.size() > 0 && params.get(0) == null) {
            ctx.logNullDeRef(this.getPos());
            return null;
        }
        rawParams = params.toArray(new Object[params.size()]);
        try {
            i = 0;
            while (i < this._parameterConverters.size()) {
                this._parameterConverters.get(i).convert(rawParams);
                ++i;
            }
            o = this.getInstance(ctx);
            if (o instanceof ExecutionContextAware) {
                ((ExecutionContextAware)o).setExecutionContext(ctx);
            }
            resultRaw = this._mtd.invoke(o, rawParams);
            return this._returnValueConverter.javaToBackend(resultRaw);
        }
        catch (Exception e) {
            paramTypes = new ArrayList<String>();
            ** for (p : params)
        }
lbl-1000:
        // 1 sources

        {
            if (p == null) {
                paramTypes.add(Void.TYPE.getName());
                continue;
            }
            paramTypes.add(p.getClass().getName());
            continue;
        }
lbl31:
        // 1 sources

        ErrorHandler.handle("could not invoke method " + this._mtd + " with parameters " + params + " of types " + paramTypes, e);
        return null;
    }

    private Object getInstance(ExecutionContext ctx) {
        if (this._isStatic) {
            return null;
        }
        try {
            Object result = ctx.getContributionStateContext().retrieveState(this._clazz);
            if (result == null) {
                result = this._clazz.newInstance();
                ctx.getContributionStateContext().storeState(this._clazz, result);
            }
            return result;
        }
        catch (Exception exc) {
            ErrorHandler.handle(exc);
            return null;
        }
    }

    public static List<BackendType> guessParameterTypes(Method mtd, BackendTypesystem ts) {
        ArrayList<BackendType> result = new ArrayList<BackendType>();
        Class<?>[] classArray = mtd.getParameterTypes();
        int n = classArray.length;
        int n2 = 0;
        while (n2 < n) {
            Class<?> cls = classArray[n2];
            result.add(ts.findType(cls));
            ++n2;
        }
        return result;
    }

    public String getName() {
        return this._mtd.getName();
    }
}

