/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtend.backend.common;

import java.util.Arrays;
import java.util.Collections;
import org.eclipse.xtend.backend.common.EfficientLazyString;
import org.eclipse.xtend.backend.common.ExecutionContext;
import org.eclipse.xtend.backend.common.QualifiedName;

public class Helpers {
    public static QualifiedName TO_STRING_METHOD_NAME = new QualifiedName("toString");
    public static QualifiedName EQUALS_NAME = new QualifiedName("operatorEquals");

    public static CharSequence overridableToString(ExecutionContext ctx, Object o) {
        if (o == null) {
            return "";
        }
        if (o instanceof EfficientLazyString) {
            return (CharSequence)o;
        }
        Object resultRaw = ctx.getFunctionDefContext().invoke(ctx, TO_STRING_METHOD_NAME, Collections.singletonList(o));
        if (resultRaw instanceof CharSequence) {
            return (CharSequence)resultRaw;
        }
        return String.valueOf(resultRaw);
    }

    public static boolean nullSafeEquals(ExecutionContext ctx, Object o1, Object o2) {
        if (o1 == o2) {
            return true;
        }
        if (o1 == null || o2 == null) {
            return false;
        }
        return (Boolean)ctx.getFunctionDefContext().invoke(ctx, EQUALS_NAME, Arrays.asList(o1, o2));
    }
}

