/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xpand2.incremental;

import java.util.ArrayList;
import java.util.Collection;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.compare.diff.metamodel.AttributeChange;
import org.eclipse.emf.compare.diff.metamodel.ModelElementChangeLeftTarget;
import org.eclipse.emf.compare.diff.metamodel.ModelElementChangeRightTarget;
import org.eclipse.emf.compare.diff.metamodel.ReferenceChange;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.mwe.core.WorkflowContext;
import org.eclipse.emf.mwe.core.issues.Issues;
import org.eclipse.emf.mwe.core.lib.AbstractWorkflowComponent2;
import org.eclipse.emf.mwe.core.monitor.ProgressMonitor;
import org.eclipse.internal.xpand2.ast.FileStatement;
import org.eclipse.internal.xtend.expression.ast.FeatureCall;
import org.eclipse.internal.xtend.expression.ast.Identifier;
import org.eclipse.internal.xtend.expression.ast.SyntaxElement;
import org.eclipse.xpand.incremental.trace.InputElement;
import org.eclipse.xpand.incremental.trace.OutputFile;
import org.eclipse.xpand.incremental.trace.Trace;
import org.eclipse.xpand.incremental.trace.TraceFactory;
import org.eclipse.xtend.expression.ExecutionContext;
import org.eclipse.xtend.expression.VetoableCallback;

public class IncrementalGenerationCallback
extends AbstractWorkflowComponent2
implements VetoableCallback {
    private String diffModelSlot;
    private String oldTraceModelSlot;
    private String newTraceModelSlot;
    private EObject diffModel;
    private Trace oldTraceModel;
    private Trace newTraceModel;
    private OutputFile currentOutputFile;
    private EObject[][] changedElements;

    public void setDiffModelSlot(String diffModelSlot) {
        this.diffModelSlot = diffModelSlot;
    }

    public void setOldTraceModelSlot(String oldTraceModelSlot) {
        this.oldTraceModelSlot = oldTraceModelSlot;
    }

    public void setNewTraceModelSlot(String newTraceModelSlot) {
        this.newTraceModelSlot = newTraceModelSlot;
    }

    protected void checkConfigurationInternal(Issues issues) {
        super.checkConfigurationInternal(issues);
        if (this.diffModelSlot == null) {
            issues.addError("No diffModelSlot given. Cannot do incremental generation.");
        }
        if (this.oldTraceModelSlot == null) {
            issues.addError("No oldTraceModelSlot given. Cannot do incremental generation.");
        }
        if (this.newTraceModelSlot == null) {
            issues.addError("No newTraceModelSlot given. Cannot do incremental generation.");
        }
    }

    public void invokeInternal(WorkflowContext workflowContext, ProgressMonitor monitor, Issues issues) {
        this.diffModel = (EObject)workflowContext.get(this.diffModelSlot);
        if (this.diffModel == null) {
            issues.addWarning("No diffModel in slot " + this.diffModelSlot + ". Cannot do incremental generation.");
        } else {
            this.prepareChangedElements();
        }
        this.oldTraceModel = (Trace)workflowContext.get(this.oldTraceModelSlot);
        if (this.oldTraceModel == null) {
            issues.addWarning("No oldTraceModel in slot " + this.oldTraceModelSlot + ". Cannot do incremental generation.");
        }
        this.newTraceModel = TraceFactory.eINSTANCE.createTrace();
        workflowContext.set(this.newTraceModelSlot, (Object)this.newTraceModel);
    }

    private void prepareChangedElements() {
        ArrayList<EObject[]> elements = new ArrayList<EObject[]>();
        TreeIterator i = this.diffModel.eAllContents();
        while (i.hasNext()) {
            AttributeChange change;
            EObject diff = (EObject)i.next();
            if (diff instanceof AttributeChange) {
                change = (AttributeChange)diff;
                elements.add(new EObject[]{change.getLeftElement(), change.getAttribute()});
                continue;
            }
            if (diff instanceof ReferenceChange) {
                change = (ReferenceChange)diff;
                elements.add(new EObject[]{change.getLeftElement(), change.getReference()});
                continue;
            }
            if (diff instanceof ModelElementChangeLeftTarget) {
                change = (ModelElementChangeLeftTarget)diff;
                elements.add(new EObject[]{change.getLeftElement().eContainer(), change.getLeftElement().eContainingFeature()});
                continue;
            }
            if (!(diff instanceof ModelElementChangeRightTarget)) continue;
            change = (ModelElementChangeRightTarget)diff;
            elements.add(new EObject[]{change.getLeftParent(), change.getRightElement().eContainingFeature()});
        }
        this.changedElements = (EObject[][])elements.toArray((T[])new EObject[2][0]);
    }

    public boolean pre(SyntaxElement element, ExecutionContext ctx) {
        if (element instanceof FileStatement) {
            return this.handleFileStatement((FileStatement)element, ctx);
        }
        if (element instanceof FeatureCall) {
            return this.handleFeatureCall((FeatureCall)element, ctx);
        }
        return true;
    }

    private boolean handleFileStatement(FileStatement fileStatement, ExecutionContext ctx) {
        String fileName = fileStatement.getTargetFileName().evaluate(ctx).toString();
        String outletName = fileStatement.getOutletName();
        if (fileName == null) {
            return true;
        }
        OutputFile oldFileTrace = this.getOldTrace(fileName, outletName);
        if (oldFileTrace == null || this.hasRelevantChangeForFile(oldFileTrace)) {
            this.currentOutputFile = TraceFactory.eINSTANCE.createOutputFile();
            this.currentOutputFile.setFileName(fileName);
            this.currentOutputFile.setOutlet(outletName);
            this.currentOutputFile.setTargetObject((EObject)ctx.getVariable("this").getValue());
            this.newTraceModel.getOutputFiles().add((Object)this.currentOutputFile);
            return true;
        }
        EcoreUtil.Copier copier = new EcoreUtil.Copier();
        OutputFile copyOfFileTrace = (OutputFile)copier.copy((EObject)oldFileTrace);
        copier.copyReferences();
        this.newTraceModel.getOutputFiles().add((Object)copyOfFileTrace);
        this.currentOutputFile = null;
        return false;
    }

    private boolean hasRelevantChangeForFile(OutputFile oldFileTrace) {
        if (this.changedElements == null) {
            return true;
        }
        EObject[][] eObjectArray = this.changedElements;
        int n = this.changedElements.length;
        int n2 = 0;
        while (n2 < n) {
            EObject[] diff = eObjectArray[n2];
            for (InputElement input : oldFileTrace.getInputElements()) {
                if (!new EcoreUtil.EqualityHelper().equals(diff[0], input.getModelElement()) || !new EcoreUtil.EqualityHelper().equals(diff[1], (EObject)input.getFeature())) continue;
                return true;
            }
            ++n2;
        }
        return false;
    }

    private OutputFile getOldTrace(String fileName, String outletName) {
        if (this.oldTraceModel == null) {
            return null;
        }
        for (OutputFile f : this.oldTraceModel.getOutputFiles()) {
            if (!f.getFileName().equals(fileName) || !(outletName == null ? f.getOutlet() == null : outletName.equals(f.getOutlet()))) continue;
            return f;
        }
        return null;
    }

    private boolean handleFeatureCall(FeatureCall featureCall, ExecutionContext ctx) {
        if (this.currentOutputFile != null) {
            Identifier currentFeature = featureCall.getName();
            Object target = null;
            if (featureCall.getTarget() != null) {
                target = featureCall.getTarget().evaluate(ctx);
            }
            if (target == null && ctx.getVariable("this") != null) {
                target = ctx.getVariable("this").getValue();
            }
            String featureName = currentFeature.getNameString(ctx);
            if (target instanceof EObject) {
                EObject targetObject = (EObject)target;
                this.addTraceForObject(featureName, targetObject);
            }
            if (target instanceof Collection) {
                Collection targetCollection = (Collection)target;
                for (EObject targetObject : targetCollection) {
                    this.addTraceForObject(featureName, targetObject);
                }
            }
        }
        return true;
    }

    private void addTraceForObject(String featureName, EObject targetObject) {
        EStructuralFeature feature = targetObject.eClass().getEStructuralFeature(featureName);
        if (feature != null) {
            this.addInputElement(targetObject, feature);
        }
    }

    private void addInputElement(EObject target, EStructuralFeature feature) {
        for (InputElement e : this.currentOutputFile.getInputElements()) {
            if (e.getModelElement() != target || e.getFeature() != feature) continue;
            return;
        }
        InputElement inputElement = TraceFactory.eINSTANCE.createInputElement();
        inputElement.setModelElement(target);
        inputElement.setFeature(feature);
        this.currentOutputFile.getInputElements().add((Object)inputElement);
    }

    public void post(SyntaxElement element, ExecutionContext ctx, Object expressionResult) {
        if (element instanceof FileStatement) {
            this.currentOutputFile = null;
        }
    }
}

