/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtend.ui.editor.outline;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.internal.xtend.xtend.ast.CreateExtensionStatement;
import org.eclipse.internal.xtend.xtend.ast.Extension;
import org.eclipse.internal.xtend.xtend.ast.ExtensionFile;
import org.eclipse.jface.action.IAction;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.editors.text.TextEditor;
import org.eclipse.xtend.shared.ui.editor.AbstractXtendXpandEditor;
import org.eclipse.xtend.shared.ui.editor.outlineview.AbstractExtXptContentOutlinePage;
import org.eclipse.xtend.shared.ui.editor.outlineview.OutlineElement;
import org.eclipse.xtend.shared.ui.expression.editor.EditorImages;
import org.eclipse.xtend.ui.core.IXtendResource;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class XtendContentOutlinePage
extends AbstractExtXptContentOutlinePage {
    public static final int PRIVATE_CREATE_EXTENSION = 2;
    public static final int PRIVATE_EXTENSION = 3;
    public static final int CREATE_EXTENSION = 4;
    public static final int EXTENSION = 5;

    public XtendContentOutlinePage(AbstractXtendXpandEditor editor) {
        super((TextEditor)editor);
    }

    protected OutlineElement[] getChildren(Object parentElement) {
        if (parentElement instanceof IXtendResource) {
            ExtensionFile xr = (ExtensionFile)((IXtendResource)parentElement).getExtXptResource();
            if (xr == null) {
                return new OutlineElement[0];
            }
            ArrayList<OutlineElement> result = new ArrayList<OutlineElement>();
            result.addAll(this.toOutlineElementsForNamespaceImports(xr.getNsImports()));
            result.addAll(this.toOutlineElementsForExtensionImports(xr.getExtImports()));
            result.addAll(this.toOutlineElements(xr.getExtensions()));
            return result.toArray(new OutlineElement[result.size()]);
        }
        return new OutlineElement[0];
    }

    private List<OutlineElement> toOutlineElements(List<Extension> extensions) {
        ArrayList<OutlineElement> l = new ArrayList<OutlineElement>();
        for (Extension ext : extensions) {
            Image img = null;
            int type = 2;
            if (ext.isPrivate()) {
                if (ext instanceof CreateExtensionStatement) {
                    img = EditorImages.getImage((String)"extension_private_create.gif");
                } else {
                    img = EditorImages.getImage((String)"extension_private.gif");
                    type = 3;
                }
            } else if (ext instanceof CreateExtensionStatement) {
                img = EditorImages.getImage((String)"extension_create.gif");
                type = 4;
            } else {
                img = EditorImages.getImage((String)"extension.gif");
                type = 5;
            }
            l.add(new OutlineElement(ext.toOutlineString(), ext.getStart(), ext.getEnd() - ext.getStart(), img, type));
        }
        return l;
    }

    public void createControl(Composite parent) {
        super.createControl(parent);
        this.registerToolbarActions(this.getSite().getActionBars());
    }

    private void registerToolbarActions(IActionBars actionBars) {
        actionBars.getToolBarManager().add((IAction)new AbstractExtXptContentOutlinePage.LexicalSortingAction((AbstractExtXptContentOutlinePage)this));
    }
}

