/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtend.shared.ui.core.builder;

import java.util.Enumeration;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.IResourceDeltaVisitor;
import org.eclipse.core.resources.IResourceVisitor;
import org.eclipse.core.resources.IStorage;
import org.eclipse.core.resources.IncrementalProjectBuilder;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.internal.core.JarPackageFragmentRoot;
import org.eclipse.xtend.shared.ui.Activator;
import org.eclipse.xtend.shared.ui.ResourceContributor;
import org.eclipse.xtend.shared.ui.core.IXtendXpandProject;
import org.eclipse.xtend.shared.ui.core.IXtendXpandResource;
import org.eclipse.xtend.shared.ui.core.builder.XtendXpandMarkerManager;
import org.eclipse.xtend.shared.ui.core.internal.JDTUtil;
import org.eclipse.xtend.shared.ui.core.internal.ResourceID;
import org.eclipse.xtend.shared.ui.internal.XtendLog;

public class XtendXpandBuilder
extends IncrementalProjectBuilder {
    private Set<IXtendXpandResource> toAnalyze = null;

    boolean isOnJavaClassPath(IResource resource) {
        IJavaProject jp = JavaCore.create((IProject)resource.getProject());
        if (jp != null) {
            return jp.isOnClasspath(resource);
        }
        return false;
    }

    public static final String getBUILDER_ID() {
        return String.valueOf(Activator.getId()) + ".xtendBuilder";
    }

    protected IProject[] build(int kind, Map args, IProgressMonitor monitor) throws CoreException {
        this.toAnalyze = new HashSet<IXtendXpandResource>();
        try {
            if (kind == 6) {
                this.fullBuild(monitor);
            } else {
                IResourceDelta delta = this.getDelta(this.getProject());
                if (delta == null) {
                    this.fullBuild(monitor);
                } else {
                    this.incrementalBuild(delta, monitor);
                }
            }
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
        for (IXtendXpandResource res : this.toAnalyze) {
            res.analyze();
        }
        IXtendXpandProject p = Activator.getExtXptModelManager().findProject((IResource)this.getProject());
        p.analyze(monitor);
        return null;
    }

    void reloadResource(IFile resource) {
        IXtendXpandResource r;
        IXtendXpandProject project;
        if (resource.exists() && (project = Activator.getExtXptModelManager().findProject((IResource)resource)) != null && (r = project.findOawResource((IStorage)resource)) != null) {
            if (r.refresh()) {
                resource.getLocalTimeStamp();
            }
            this.toAnalyze.add(r);
        }
    }

    public void handleRemovement(IFile resource) {
        IXtendXpandProject project = Activator.getExtXptModelManager().findProject((IResource)resource);
        if (project != null) {
            project.unregisterOawResource(project.findOawResource((IStorage)resource));
        } else {
            XtendLog.logInfo("No oaw project found for " + resource.getProject().getName());
        }
    }

    protected void fullBuild(IProgressMonitor monitor) throws CoreException {
        IXtendXpandProject project = Activator.getExtXptModelManager().findProject(this.getProject().getFullPath());
        if (project != null) {
            ResourceContributor[] contributors;
            this.getProject().accept((IResourceVisitor)new OawDeltaVisitor(monitor));
            IJavaProject jp = JavaCore.create((IProject)this.getProject());
            IPackageFragmentRoot[] roots = jp.getPackageFragmentRoots();
            HashSet<String> extensions = new HashSet<String>();
            ResourceContributor[] resourceContributorArray = contributors = Activator.getRegisteredResourceContributors();
            int n = contributors.length;
            int n2 = 0;
            while (n2 < n) {
                ResourceContributor resourceContributor = resourceContributorArray[n2];
                extensions.add(resourceContributor.getFileExtension());
                ++n2;
            }
            int i = 0;
            while (i < roots.length) {
                IPackageFragmentRoot root = roots[i];
                if (root.isArchive()) {
                    root.open(monitor);
                    try {
                        ZipFile zip = ((JarPackageFragmentRoot)root).getJar();
                        Enumeration<? extends ZipEntry> entries = zip.entries();
                        while (entries.hasMoreElements()) {
                            ZipEntry entry = entries.nextElement();
                            for (String ext : extensions) {
                                String name = entry.getName();
                                if (!name.endsWith(ext)) continue;
                                String fqn = name.substring(0, name.length() - ext.length() - 1).replaceAll("/", "::");
                                ResourceID resourceID = new ResourceID(fqn, ext);
                                IStorage findStorage = JDTUtil.loadFromJar(resourceID, root);
                                project.findOawResource(findStorage);
                            }
                        }
                    }
                    finally {
                        root.close();
                    }
                }
                ++i;
            }
        } else {
            XtendLog.logInfo("Couldn't create oawproject for project " + this.getProject().getName());
        }
    }

    protected void incrementalBuild(IResourceDelta delta, IProgressMonitor monitor) throws CoreException {
        OawDeltaVisitor visitor = new OawDeltaVisitor(monitor);
        delta.accept((IResourceDeltaVisitor)visitor);
    }

    class OawDeltaVisitor
    implements IResourceDeltaVisitor,
    IResourceVisitor {
        private IProgressMonitor monitor;
        private Set<String> extensions;

        public OawDeltaVisitor(IProgressMonitor monitor) {
            ResourceContributor[] contributors;
            this.monitor = monitor;
            this.extensions = new HashSet<String>();
            ResourceContributor[] resourceContributorArray = contributors = Activator.getRegisteredResourceContributors();
            int n = contributors.length;
            int n2 = 0;
            while (n2 < n) {
                ResourceContributor resourceContributor = resourceContributorArray[n2];
                this.extensions.add(resourceContributor.getFileExtension());
                ++n2;
            }
        }

        public boolean visit(IResourceDelta delta) throws CoreException {
            IResource resource = delta.getResource();
            if (this.isOawResource(resource)) {
                switch (delta.getKind()) {
                    case 1: {
                        XtendXpandMarkerManager.deleteMarkers((IResource)((IFile)resource));
                        XtendXpandBuilder.this.reloadResource((IFile)resource);
                        break;
                    }
                    case 2: {
                        XtendXpandBuilder.this.handleRemovement((IFile)resource);
                        break;
                    }
                    case 4: {
                        XtendXpandBuilder.this.reloadResource((IFile)resource);
                    }
                }
            }
            this.monitor.worked(1);
            return true;
        }

        private boolean isOawResource(IResource resource) {
            return resource instanceof IFile && this.extensions.contains(((IFile)resource).getFileExtension()) && XtendXpandBuilder.this.isOnJavaClassPath(resource);
        }

        public boolean visit(IResource resource) {
            if (this.isOawResource(resource)) {
                XtendXpandBuilder.this.reloadResource((IFile)resource);
            }
            this.monitor.worked(1);
            return true;
        }
    }
}

