/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xpand2;

import java.util.HashSet;
import org.eclipse.internal.xpand2.model.XpandDefinition;
import org.eclipse.internal.xpand2.model.XpandResource;
import org.eclipse.xpand2.XpandExecutionContext;
import org.eclipse.xpand2.XpandExecutionContextImpl;
import org.eclipse.xtend.expression.AnalysationIssue;
import org.eclipse.xtend.expression.EvaluationException;
import org.eclipse.xtend.expression.ExecutionContext;
import org.eclipse.xtend.expression.Variable;
import org.eclipse.xtend.typesystem.Type;

public class XpandFacade {
    private XpandExecutionContext ctx = null;

    public XpandFacade(XpandExecutionContext ctx) {
        this.ctx = ctx;
    }

    public void evaluate(String definitionName, Object targetObject, Object ... params) {
        params = params == null ? new Object[]{} : params;
        Type targetType = this.ctx.getType(targetObject);
        Type[] paramTypes = new Type[params.length];
        int i = 0;
        while (i < paramTypes.length) {
            paramTypes[i] = this.ctx.getType(params[i]);
            ++i;
        }
        XpandDefinition def = this.ctx.findDefinition(definitionName, targetType, paramTypes);
        if (def == null) {
            throw new EvaluationException("No Definition " + definitionName + this.getParamString(paramTypes) + " for " + targetType.getName() + " could be found!", null, (ExecutionContext)this.ctx);
        }
        this.ctx = (XpandExecutionContext)this.ctx.cloneWithVariable(new Variable("this", targetObject));
        int i2 = 0;
        while (i2 < params.length) {
            Variable v = new Variable(def.getParams()[i2].getName().getValue(), params[i2]);
            this.ctx = (XpandExecutionContext)this.ctx.cloneWithVariable(v);
            ++i2;
        }
        this.ctx = (XpandExecutionContext)this.ctx.cloneWithResource(def.getOwner());
        def.evaluate(this.ctx);
    }

    private String getParamString(Type[] paramTypes) {
        if (paramTypes.length == 0) {
            return "";
        }
        StringBuffer buff = new StringBuffer("(");
        int i = 0;
        while (i < paramTypes.length) {
            Type t = paramTypes[i];
            buff.append(t.getName());
            if (i + 1 < paramTypes.length) {
                buff.append(",");
            }
            ++i;
        }
        buff.append(")");
        return buff.toString();
    }

    public AnalysationIssue[] analyze(String templateName) {
        HashSet issues = new HashSet();
        XpandResource tpl = this.ctx.findTemplate(templateName);
        tpl.analyze(this.ctx, issues);
        return issues.toArray(new AnalysationIssue[issues.size()]);
    }

    public static XpandFacade create(XpandExecutionContextImpl execCtx) {
        return new XpandFacade(execCtx);
    }
}

