/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jet.core.parser.ast;

import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import org.eclipse.jet.core.parser.ast.BodyElement;
import org.eclipse.jet.core.parser.ast.JETAST;
import org.eclipse.jet.taglib.TagDefinition;

public abstract class XMLElement
extends BodyElement {
    private final String name;
    private final Map attributes;
    private final TagDefinition tagDefinition;

    XMLElement(JETAST ast, int line, int colOffset, int start, int end, String name, Map attributes, TagDefinition td) {
        super(ast, line, colOffset, start, end);
        this.name = name;
        this.tagDefinition = td;
        this.attributes = Collections.unmodifiableMap(new LinkedHashMap(attributes));
    }

    public final String getName() {
        return this.name;
    }

    public final Map getAttributes() {
        return this.attributes;
    }

    public String getTagNCName() {
        String qName = this.getName();
        int sepIndex = qName.indexOf(58);
        return sepIndex >= 0 ? qName.substring(sepIndex + 1) : qName;
    }

    public String getNSPrefix() {
        String qName = this.getName();
        int sepIndex = qName.indexOf(58);
        return sepIndex >= 0 ? qName.substring(0, sepIndex) : "";
    }

    public final TagDefinition getTagDefinition() {
        return this.tagDefinition;
    }

    public final boolean removeLineWhenOtherwiseEmpty() {
        return this.tagDefinition.removeWhenContainingLineIsEmpty();
    }
}

