/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jet.internal.taglib.workspace;

import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jet.JET2Context;
import org.eclipse.jet.JET2Writer;
import org.eclipse.jet.internal.taglib.workspace.WsProjectAction;
import org.eclipse.jet.taglib.AbstractContainerTag;
import org.eclipse.jet.taglib.JET2TagException;
import org.eclipse.jet.taglib.TagInfo;
import org.eclipse.jet.taglib.workspace.WorkspaceContextExtender;
import org.eclipse.jet.transform.TransformContextExtender;

public class ProjectTag
extends AbstractContainerTag {
    private static final String NAME__ATTR = "name";
    private boolean containerPushed = false;

    public void doBeforeBody(TagInfo td, JET2Context context, JET2Writer out) throws JET2TagException {
        IProject project;
        String name = this.getAttribute(NAME__ATTR);
        String location = this.getAttribute("location");
        WorkspaceContextExtender wsExtender = new WorkspaceContextExtender(context);
        try {
            project = ResourcesPlugin.getWorkspace().getRoot().getProject(name);
        }
        catch (IllegalArgumentException e) {
            throw new JET2TagException(e.getMessage(), (Throwable)e);
        }
        IProjectDescription projectDescription = ResourcesPlugin.getWorkspace().newProjectDescription(name);
        if (location != null) {
            projectDescription.setLocation((IPath)new Path(location));
        }
        TransformContextExtender tce = new TransformContextExtender(context);
        wsExtender.addAction(new WsProjectAction(context, tce.getTemplatePath(), td, project, projectDescription));
        wsExtender.pushContainer((IContainer)project);
        this.containerPushed = true;
    }

    public void doAfterBody(TagInfo td, JET2Context context, JET2Writer out) throws JET2TagException {
        WorkspaceContextExtender wsExtender = new WorkspaceContextExtender(context);
        if (this.containerPushed) {
            wsExtender.popContainer();
        }
    }
}

