/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jet.internal;

import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.common.EMFPlugin;
import org.eclipse.jet.internal.JETActivatorWrapper;
import org.eclipse.jet.internal.SavedStateManager;
import org.eclipse.jet.internal.extensionpoints.ModelInspectorsManager;
import org.eclipse.jet.internal.extensionpoints.ModelLoaderExtManager;
import org.eclipse.jet.internal.extensionpoints.PluginProjectMonitor;
import org.eclipse.jet.internal.extensionpoints.WorkspaceTagLibraryManager;
import org.eclipse.jet.internal.extensionpoints.XPathFunctionsManager;
import org.eclipse.jet.internal.runtime.JETBundleInstaller;
import org.eclipse.jet.internal.runtime.JETBundleManager;
import org.eclipse.jet.internal.taglib.InternalTagLibManager;
import org.eclipse.jet.taglib.TagLibrary;
import org.eclipse.jet.transform.IJETBundleManager;
import org.osgi.framework.BundleContext;

public class InternalJET2Platform
extends EMFPlugin.EclipsePlugin {
    private static InternalJET2Platform plugin;
    private InternalTagLibManager tagLibManager = null;
    private JETBundleInstaller jetBundleInstaller = null;
    private XPathFunctionsManager xpathFunctionsManager = null;
    private ModelLoaderExtManager modelLoaderExtManager = null;
    private ModelInspectorsManager modelInspectorExtManager = null;
    private JETBundleManager bundleManager = null;
    private PluginProjectMonitor pluginProjectMonitor = null;
    private WorkspaceTagLibraryManager workspaceTagLibraryManager = null;
    private SavedStateManager savedStateManager = null;

    public static InternalJET2Platform getDefault() {
        return plugin;
    }

    private static void log(int severity, String msg, Exception e) {
        InternalJET2Platform.getDefault().getLog().log(InternalJET2Platform.newStatus(severity, msg, e));
    }

    public static void log(IStatus result) {
        InternalJET2Platform.getDefault().getLog().log(result);
    }

    public static void logError(String msg) {
        InternalJET2Platform.logError(msg, null);
    }

    public static void logError(String msg, Exception e) {
        InternalJET2Platform.log(4, msg, e);
    }

    public static void logInfo(String msg) {
        InternalJET2Platform.logInfo(msg, null);
    }

    public static void logInfo(String msg, Exception e) {
        InternalJET2Platform.log(1, msg, e);
    }

    public static void logWarning(String msg) {
        InternalJET2Platform.logWarning(msg, null);
    }

    public static void logWarning(String msg, Exception e) {
        InternalJET2Platform.log(2, msg, e);
    }

    public static IStatus newStatus(int severity, String msg, Exception e) {
        return new Status(severity, "org.eclipse.jet", 0, msg == null ? "" : msg, (Throwable)e);
    }

    public InternalJET2Platform() {
        plugin = this;
        JETActivatorWrapper.INSTANCE.setPlugin(this);
    }

    public IPath getCompiledBundleLocation() {
        IPath stateLocation = this.getStateLocation();
        IPath compiledBundleLocation = stateLocation.append("compiledBundles");
        compiledBundleLocation.toFile().mkdirs();
        return compiledBundleLocation;
    }

    public TagLibrary getTagLibrary(String id) {
        return this.tagLibManager.getTagLibrary(id);
    }

    public TagLibrary getWorkspaceTagLibrary(String id) {
        return this.workspaceTagLibraryManager.getTagLibrary(id);
    }

    public IProject getProjectDefiningTagLibrary(String id) {
        return this.workspaceTagLibraryManager.getProjectDefiningTagLibrary(id);
    }

    public JETBundleInstaller getJETBundleInstaller() {
        return this.jetBundleInstaller;
    }

    public void start(BundleContext context) throws Exception {
        super.start(context);
        this.modelInspectorExtManager = new ModelInspectorsManager();
        this.modelInspectorExtManager.startup();
        this.modelLoaderExtManager = new ModelLoaderExtManager();
        this.modelLoaderExtManager.startup();
        this.xpathFunctionsManager = new XPathFunctionsManager();
        this.xpathFunctionsManager.startup();
        this.pluginProjectMonitor = new PluginProjectMonitor();
        this.workspaceTagLibraryManager = new WorkspaceTagLibraryManager();
        this.workspaceTagLibraryManager.startup(this.pluginProjectMonitor);
        this.pluginProjectMonitor.startup();
        this.tagLibManager = new InternalTagLibManager();
        this.tagLibManager.startup();
        this.jetBundleInstaller = new JETBundleInstaller();
        this.jetBundleInstaller.startup(context);
        this.bundleManager = new JETBundleManager();
        this.bundleManager.startup();
        this.savedStateManager = new SavedStateManager((Plugin)this);
        this.savedStateManager.startup();
    }

    public void stop(BundleContext context) throws Exception {
        this.tagLibManager.shutdown();
        this.tagLibManager = null;
        this.jetBundleInstaller.shutdown();
        this.jetBundleInstaller = null;
        this.xpathFunctionsManager.shutdown();
        this.xpathFunctionsManager = null;
        this.modelLoaderExtManager.shutdown();
        this.modelLoaderExtManager = null;
        this.modelInspectorExtManager.shutdown();
        this.modelInspectorExtManager = null;
        this.bundleManager.shutdown();
        this.bundleManager = null;
        this.workspaceTagLibraryManager.shutdown();
        this.pluginProjectMonitor.shutdown();
        this.savedStateManager.shutdown();
        this.savedStateManager = null;
        super.stop(context);
        plugin = null;
    }

    public static void debugMessage(Object issuer, String message) {
        Class<?> msgClass = null;
        msgClass = issuer instanceof Class ? (Class<?>)issuer : issuer.getClass();
        System.err.println(String.valueOf(msgClass.getName()) + ": " + message);
    }

    public String[] getKnownTagLibraryIds() {
        return this.tagLibManager.getKnownTagLibraryIds();
    }

    public final XPathFunctionsManager getXPathFunctionsManager() {
        return this.xpathFunctionsManager;
    }

    public final InternalTagLibManager getTagLibManager() {
        return this.tagLibManager;
    }

    public final IJETBundleManager getBundleManager() {
        return this.bundleManager;
    }

    public final SavedStateManager getSavedStateManager() {
        return this.savedStateManager;
    }
}

