/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jet.internal.taglib.control;

import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Set;
import org.eclipse.jet.JET2Context;
import org.eclipse.jet.XPathContextExtender;
import org.eclipse.jet.internal.taglib.control.DeepIterateEntry;
import org.eclipse.jet.internal.taglib.control.DeepIterateTag;
import org.eclipse.jet.internal.taglib.control.DeepIteratorStrategyBuilder;
import org.eclipse.jet.internal.taglib.control.IDeepIterateStrategy;

public abstract class AbstrateDeepIterateStrategy
implements IDeepIterateStrategy {
    protected final JET2Context context;
    protected final XPathContextExtender xpc;
    protected final String select;
    protected final String filter;
    protected final String var;
    protected Set loopDetectionStack;
    protected Collection entries;
    protected final boolean allowDuplicates;
    protected final Object initialContextObject;
    protected final String deepIterateTagName;
    protected final String varStatus;

    public AbstrateDeepIterateStrategy(DeepIteratorStrategyBuilder builder) {
        this.context = builder.getContext();
        this.xpc = XPathContextExtender.getInstance(this.context);
        this.select = builder.getSelect();
        this.filter = builder.getFilter();
        this.var = builder.getVar();
        this.varStatus = builder.getVarStatus();
        this.allowDuplicates = builder.isAllowDuplicates();
        this.initialContextObject = builder.getContextObject();
        this.deepIterateTagName = builder.getTagName();
    }

    protected boolean satisfiesFilter(DeepIterateEntry entry) {
        if (this.filter != null && this.var != null) {
            this.context.setVariable(this.var, entry.getObject());
        }
        if (this.filter != null && this.varStatus != null) {
            this.context.setVariable(this.varStatus, (Object)new DeepIterateTag.LoopStatus(entry.getDepth(), entry.isLeaf()));
        }
        return this.filter != null ? this.xpc.resolveTest(entry.getObject(), this.filter) : true;
    }

    protected boolean createsRecursiveLoop(DeepIterateEntry entry) {
        return this.loopDetectionStack.contains(entry);
    }

    protected boolean isDuplicateEntry(DeepIterateEntry n) {
        return !this.allowDuplicates && this.entries.contains(n);
    }

    protected Object[] selectNodes(Object contextObject, int depth) {
        if (this.var != null) {
            this.context.setVariable(this.var, contextObject);
        }
        if (this.varStatus != null) {
            this.context.setVariable(this.varStatus, (Object)new DeepIterateTag.LoopStatus(depth));
        }
        return this.xpc.resolve(contextObject, this.select);
    }

    protected abstract void doSearch();

    public final Collection search() {
        try {
            this.entries = new LinkedHashSet();
            this.loopDetectionStack = new HashSet();
            this.doSearch();
            Collection collection = this.entries;
            Object var1_2 = null;
            this.loopDetectionStack = null;
            this.entries = null;
            return collection;
        }
        catch (Throwable throwable) {
            Object var1_3 = null;
            this.loopDetectionStack = null;
            this.entries = null;
            throw throwable;
        }
    }
}

