/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jet.internal.runtime;

import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.StringTokenizer;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.preferences.ConfigurationScope;
import org.eclipse.core.runtime.preferences.DefaultScope;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.core.runtime.preferences.IPreferencesService;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.eclipse.jet.internal.InternalJET2Platform;
import org.eclipse.jet.internal.runtime.DirectoryBundleProvider;
import org.eclipse.jet.internal.runtime.DynamicJETBundleDescriptor;
import org.eclipse.jet.internal.runtime.IJETBundleProvider;
import org.eclipse.jet.transform.IJETBundleDescriptor;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleException;
import org.osgi.service.prefs.Preferences;

public class AdditionalBundleLocationProvider
implements IJETBundleProvider,
IEclipsePreferences.IPreferenceChangeListener {
    private static boolean DEBUG = InternalJET2Platform.getDefault().isDebugging() && Boolean.valueOf(Platform.getDebugOption((String)"org.eclipse.jet/debug/additionalBundleLoading")) != false;
    private IEclipsePreferences defaultsNode;
    private IEclipsePreferences configurationNode;
    private IEclipsePreferences instanceNode;
    private IEclipsePreferences[] searchList;
    private final IPreferencesService service = Platform.getPreferencesService();
    private final List directoryProviders = new ArrayList();

    private String[] parseAdditionalPathString(String stringList) {
        if (stringList == null) {
            return new String[0];
        }
        StringTokenizer st = new StringTokenizer(stringList, String.valueOf(File.pathSeparator) + "\n\r");
        ArrayList<Object> v = new ArrayList<Object>();
        while (st.hasMoreElements()) {
            v.add(st.nextElement());
        }
        return v.toArray(new String[v.size()]);
    }

    public Collection getAllJETBundleDescriptors() {
        Set allIds = this.getAllJETBundleIds();
        ArrayList<IJETBundleDescriptor> descriptors = new ArrayList<IJETBundleDescriptor>(allIds.size());
        Iterator i = allIds.iterator();
        while (i.hasNext()) {
            String id = (String)i.next();
            descriptors.add(this.getDescriptor(id));
        }
        return descriptors;
    }

    public Set getAllJETBundleIds() {
        if (DEBUG) {
            System.out.println("AdditionalBundleLocationProvider.getAllJETBundleIds()");
        }
        HashSet result = new HashSet();
        Iterator i = this.directoryProviders.iterator();
        while (i.hasNext()) {
            DirectoryBundleProvider provider = (DirectoryBundleProvider)i.next();
            result.addAll(provider.getAllJETBundleIds());
        }
        if (DEBUG) {
            System.out.println("   " + result);
        }
        return result;
    }

    public IJETBundleDescriptor getDescriptor(String id) {
        if (DEBUG) {
            System.out.println("AdditionalBundleLocationProvider.getDescriptor(" + id + ")");
        }
        IJETBundleDescriptor descriptor = null;
        Iterator i = this.directoryProviders.iterator();
        while (i.hasNext() && descriptor == null) {
            DirectoryBundleProvider provider = (DirectoryBundleProvider)i.next();
            descriptor = provider.getDescriptor(id);
        }
        return descriptor;
    }

    public Bundle load(String id, IProgressMonitor monitor) throws BundleException {
        Bundle bundle = null;
        DynamicJETBundleDescriptor descriptor = (DynamicJETBundleDescriptor)this.getDescriptor(id);
        if (descriptor != null) {
            bundle = InternalJET2Platform.getDefault().getJETBundleInstaller().installBundle(descriptor.getBundleURL());
            if (DEBUG) {
                System.out.println("[deployedBundle] Loaded " + bundle.getSymbolicName());
            }
        }
        return bundle;
    }

    public void shutdown() {
        this.instanceNode.removePreferenceChangeListener((IEclipsePreferences.IPreferenceChangeListener)this);
        this.directoryProviders.clear();
        this.configurationNode = null;
        this.instanceNode = null;
        this.searchList = null;
    }

    public void startup() {
        if (DEBUG) {
            System.out.println("AdditionalBundleLocationProvider.startup()");
        }
        this.defaultsNode = new DefaultScope().getNode("org.eclipse.jet");
        this.configurationNode = new ConfigurationScope().getNode("org.eclipse.jet");
        this.instanceNode = new InstanceScope().getNode("org.eclipse.jet");
        this.searchList = new IEclipsePreferences[]{this.instanceNode, this.configurationNode, this.defaultsNode};
        String additonalLocations = this.service.get("org.eclipse.jet.additionalJarLocations", null, (Preferences[])this.searchList);
        this.addTransforms(additonalLocations);
        this.instanceNode.addPreferenceChangeListener((IEclipsePreferences.IPreferenceChangeListener)this);
    }

    private void addTransforms(String additonalLocations) {
        if (DEBUG) {
            System.out.println("AdditionalBundleLocationProvider.addTransforms(" + additonalLocations + ")");
        }
        String[] dirNames = this.parseAdditionalPathString(additonalLocations);
        this.directoryProviders.clear();
        File[] dirs = new File[dirNames.length];
        int i = 0;
        while (i < dirNames.length) {
            dirs[i] = new File(dirNames[i]);
            if (dirs[i].exists() && dirs[i].isDirectory()) {
                this.directoryProviders.add(new DirectoryBundleProvider(dirs[i]));
            }
            ++i;
        }
    }

    public void unload(String id) throws BundleException {
    }

    public void unload(Bundle bundle) throws BundleException {
        if (bundle != null) {
            if (DEBUG) {
                System.out.println("[deployedBundle] Unloading " + bundle.getSymbolicName());
            }
            bundle.uninstall();
        }
    }

    public void preferenceChange(IEclipsePreferences.PreferenceChangeEvent event) {
        if (DEBUG) {
            System.out.println("AdditionalBundleLocationProvider.preferenceChange()");
            System.out.println("  key: " + event.getKey());
            System.out.println("  old: " + event.getOldValue());
            System.out.println("  new: " + event.getNewValue());
        }
        if ("org.eclipse.jet.additionalJarLocations".equals(event.getKey())) {
            String additonalLocations = this.service.get("org.eclipse.jet.additionalJarLocations", null, (Preferences[])this.searchList);
            this.addTransforms(additonalLocations);
        }
    }
}

