/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.acceleo.internal.ide.ui.editors.template;

import java.util.ArrayList;
import org.eclipse.acceleo.internal.ide.ui.AcceleoUIMessages;
import org.eclipse.acceleo.internal.ide.ui.editors.template.AcceleoEditor;
import org.eclipse.acceleo.internal.ide.ui.editors.template.utils.OpenDeclarationUtils;
import org.eclipse.acceleo.parser.cst.CSTNode;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.edit.provider.ComposedAdapterFactory;
import org.eclipse.emf.edit.provider.IItemLabelProvider;
import org.eclipse.emf.edit.provider.ReflectiveItemProviderAdapterFactory;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.hyperlink.AbstractHyperlinkDetector;
import org.eclipse.jface.text.hyperlink.IHyperlink;
import org.eclipse.ocl.utilities.ASTNode;
import org.eclipse.ui.texteditor.ITextEditor;

public class AcceleoElementHyperlinkDetector
extends AbstractHyperlinkDetector {
    private static final ComposedAdapterFactory FACTORY = AcceleoElementHyperlinkDetector.createAdapterFactory();

    public IHyperlink[] detectHyperlinks(ITextViewer textViewer, IRegion region, boolean canShowMultipleHyperlinks) {
        CSTNode cstNode;
        ITextEditor textEditor = (ITextEditor)this.getAdapter(ITextEditor.class);
        if (region == null || !(textEditor instanceof AcceleoEditor)) {
            return null;
        }
        EObject res = null;
        AcceleoEditor editor = (AcceleoEditor)textEditor;
        int offset = region.getOffset();
        ASTNode astNode = editor.getContent().getASTNode(offset, offset);
        if (astNode != null) {
            res = OpenDeclarationUtils.findDeclarationFromAST(astNode);
        }
        if (res == null && (cstNode = editor.getContent().getCSTNode(offset, offset)) != null) {
            res = OpenDeclarationUtils.findDeclarationFromCST(editor, astNode, cstNode);
        }
        IHyperlink[] links = null;
        if (res != null) {
            links = new IHyperlink[]{new AcceleoElementHyperlink((ITextEditor)editor, region, res)};
        }
        return links;
    }

    private static ComposedAdapterFactory createAdapterFactory() {
        ArrayList<Object> factories = new ArrayList<Object>();
        factories.add(new ComposedAdapterFactory(ComposedAdapterFactory.Descriptor.Registry.INSTANCE));
        factories.add(new ReflectiveItemProviderAdapterFactory());
        return new ComposedAdapterFactory(factories);
    }

    protected static String getLabelFor(EObject eObj) {
        IItemLabelProvider labelProvider;
        String text = eObj == null ? "null" : ((labelProvider = (IItemLabelProvider)FACTORY.adapt((Notifier)eObj, IItemLabelProvider.class)) != null ? labelProvider.getText((Object)eObj) : "");
        return text;
    }

    private class AcceleoElementHyperlink
    implements IHyperlink {
        private final IRegion hyperLinkRegion;
        private final EObject target;
        private final ITextEditor sourceEditor;

        public AcceleoElementHyperlink(ITextEditor editor, IRegion region, EObject linkTarget) {
            this.sourceEditor = editor;
            this.hyperLinkRegion = region;
            this.target = linkTarget;
        }

        public IRegion getHyperlinkRegion() {
            return this.hyperLinkRegion;
        }

        public String getHyperlinkText() {
            return AcceleoUIMessages.getString("AcceleoElementHyperlinkDetector.OpenDeclarationLabel", AcceleoElementHyperlinkDetector.getLabelFor(this.target));
        }

        public String getTypeLabel() {
            return null;
        }

        public void open() {
            OpenDeclarationUtils.showEObject(this.sourceEditor.getSite().getPage(), this.target.eResource().getURI(), OpenDeclarationUtils.createRegion(this.target), this.target);
        }
    }
}

