/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.acceleo.internal.ide.ui.debug.actions;

import org.eclipse.acceleo.ide.ui.AcceleoUIActivator;
import org.eclipse.acceleo.internal.ide.ui.debug.model.AcceleoLineBreakpoint;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.model.IBreakpoint;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.Position;
import org.eclipse.jface.text.source.IAnnotationModel;
import org.eclipse.jface.text.source.IVerticalRulerInfo;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.texteditor.AbstractMarkerAnnotationModel;
import org.eclipse.ui.texteditor.IDocumentProvider;
import org.eclipse.ui.texteditor.ITextEditor;
import org.eclipse.ui.texteditor.IUpdate;

public abstract class AbstractBreakpointRulerAction
extends Action
implements IUpdate {
    protected IVerticalRulerInfo info;
    protected ITextEditor textEditor;
    private IBreakpoint breakpoint;

    protected IBreakpoint getBreakpoint() {
        return this.breakpoint;
    }

    protected void setBreakpoint(IBreakpoint aBreakpoint) {
        this.breakpoint = aBreakpoint;
    }

    protected ITextEditor getTextEditor() {
        return this.textEditor;
    }

    protected void setTextEditor(ITextEditor aTextEditor) {
        this.textEditor = aTextEditor;
    }

    protected IVerticalRulerInfo getInfo() {
        return this.info;
    }

    protected void setInfo(IVerticalRulerInfo rulerInfo) {
        this.info = rulerInfo;
    }

    protected IBreakpoint determineBreakpoint() {
        IBreakpoint[] breakpoints = DebugPlugin.getDefault().getBreakpointManager().getBreakpoints("org.eclipse.acceleo.ide.ui.debug.model.AcceleoModelPresentation");
        int i = 0;
        while (i < breakpoints.length) {
            if (breakpoints[i] instanceof AcceleoLineBreakpoint) {
                try {
                    if (this.breakpointAtRulerLine((AcceleoLineBreakpoint)breakpoints[i])) {
                        return breakpoints[i];
                    }
                }
                catch (CoreException e) {
                    AcceleoUIActivator.getDefault().getLog().log(e.getStatus());
                }
            }
            ++i;
        }
        return null;
    }

    private boolean breakpointAtRulerLine(AcceleoLineBreakpoint aBreakpoint) throws CoreException {
        Position position;
        AbstractMarkerAnnotationModel model = this.getAnnotationModel();
        if (model != null && (position = model.getMarkerPosition(aBreakpoint.getMarker())) != null) {
            IDocumentProvider provider = this.getTextEditor().getDocumentProvider();
            IDocument doc = provider.getDocument((Object)this.getTextEditor().getEditorInput());
            try {
                int markerLineNumber = doc.getLineOfOffset(position.getOffset());
                int rulerLine = this.getInfo().getLineOfLastMouseButtonActivity();
                if (rulerLine == markerLineNumber) {
                    return !this.getTextEditor().isDirty() || aBreakpoint.getLineNumber() == markerLineNumber + 1;
                }
            }
            catch (BadLocationException badLocationException) {}
        }
        return false;
    }

    protected AbstractMarkerAnnotationModel getAnnotationModel() {
        IDocumentProvider provider = this.textEditor.getDocumentProvider();
        IAnnotationModel model = provider.getAnnotationModel((Object)this.getTextEditor().getEditorInput());
        if (model instanceof AbstractMarkerAnnotationModel) {
            return (AbstractMarkerAnnotationModel)model;
        }
        return null;
    }

    protected IResource getResource() {
        IEditorInput input = this.textEditor.getEditorInput();
        IResource resource = (IResource)input.getAdapter(IFile.class);
        if (resource == null) {
            resource = (IResource)input.getAdapter(IResource.class);
        }
        return resource;
    }
}

