/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.m2m.internal.qvt.oml.editor.ui.hyperlinks;

import java.util.Arrays;
import java.util.List;
import lpg.lpgjavaruntime.IToken;
import lpg.lpgjavaruntime.PrsStream;
import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EEnumLiteral;
import org.eclipse.emf.ecore.EModelElement;
import org.eclipse.emf.ecore.ENamedElement;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.Region;
import org.eclipse.jface.text.hyperlink.IHyperlink;
import org.eclipse.m2m.internal.qvt.oml.ast.binding.ASTBindingHelper;
import org.eclipse.m2m.internal.qvt.oml.ast.binding.ASTSyntheticNode;
import org.eclipse.m2m.internal.qvt.oml.ast.binding.ASTSyntheticNodeAccess;
import org.eclipse.m2m.internal.qvt.oml.ast.env.QvtOperationalEnv;
import org.eclipse.m2m.internal.qvt.oml.ast.parser.ConstructorOperationAdapter;
import org.eclipse.m2m.internal.qvt.oml.cst.ClassifierDefCS;
import org.eclipse.m2m.internal.qvt.oml.cst.InstantiationExpCS;
import org.eclipse.m2m.internal.qvt.oml.cst.MappingModuleCS;
import org.eclipse.m2m.internal.qvt.oml.cst.ModelTypeCS;
import org.eclipse.m2m.internal.qvt.oml.editor.ui.CSTHelper;
import org.eclipse.m2m.internal.qvt.oml.editor.ui.hyperlinks.HyperlinkUtil;
import org.eclipse.m2m.internal.qvt.oml.editor.ui.hyperlinks.IHyperlinkDetectorHelper;
import org.eclipse.m2m.internal.qvt.oml.editor.ui.hyperlinks.MetamodelElementHyperlink;
import org.eclipse.m2m.internal.qvt.oml.editor.ui.hyperlinks.QvtFileHyperlink;
import org.eclipse.m2m.qvt.oml.ecore.ImperativeOCL.InstantiationExp;
import org.eclipse.ocl.cst.CSTNode;
import org.eclipse.ocl.cst.EnumLiteralExpCS;
import org.eclipse.ocl.cst.PathNameCS;
import org.eclipse.ocl.cst.SimpleNameCS;
import org.eclipse.ocl.ecore.EnumLiteralExp;

public class PathNameHyperlinkDetector
implements IHyperlinkDetectorHelper {
    public IHyperlink detectHyperlink(IHyperlinkDetectorHelper.IDetectionContext context) {
        CSTNode syntaxElement = context.getSyntaxElement();
        EModelElementRef elementRef = PathNameHyperlinkDetector.findReferencedMetamodelElement(syntaxElement, context.getRegion());
        if (elementRef != null) {
            URI sourceURI;
            ASTSyntheticNode referencedDefinitionAST;
            EModelElement element = elementRef.element;
            CSTNode cstNode = ASTBindingHelper.resolveCSTNode((EObject)element, CSTNode.class);
            if (cstNode == null && (referencedDefinitionAST = ASTSyntheticNodeAccess.getASTNode((EObject)element)) != null) {
                cstNode = ASTSyntheticNodeAccess.getCST((ASTSyntheticNode)referencedDefinitionAST, CSTNode.class);
            }
            if (cstNode != null && (sourceURI = CSTHelper.getSourceFile(cstNode)) != null) {
                if (cstNode instanceof ModelTypeCS) {
                    cstNode = ((ModelTypeCS)cstNode).getIdentifierCS();
                } else if (cstNode instanceof MappingModuleCS) {
                    MappingModuleCS moduleCS = (MappingModuleCS)cstNode;
                    if (moduleCS.getHeaderCS() != null) {
                        cstNode = moduleCS.getHeaderCS();
                        if (moduleCS.getHeaderCS().getPathNameCS() != null) {
                            cstNode = moduleCS.getHeaderCS().getPathNameCS();
                        }
                    }
                } else if (cstNode instanceof ClassifierDefCS) {
                    cstNode = ((ClassifierDefCS)cstNode).getSimpleNameCS();
                }
                IRegion destReg = HyperlinkUtil.createRegion(cstNode);
                return new QvtFileHyperlink(elementRef.sourceLinkRegion, sourceURI, destReg, destReg);
            }
            return new MetamodelElementHyperlink(elementRef.sourceLinkRegion, elementRef.element);
        }
        return null;
    }

    public static EModelElement findReferencedElementDefinition(CSTNode syntaxElement, IRegion region) {
        EModelElementRef ref = PathNameHyperlinkDetector.findReferencedMetamodelElement(syntaxElement, region);
        return ref != null ? ref.element : null;
    }

    private static EModelElementRef findReferencedMetamodelElement(CSTNode syntaxElement, IRegion region) {
        Object astObj = syntaxElement.getAst();
        if (astObj instanceof EClassifier) {
            int[] selectedNamePos;
            PathNameCS pathNameCS;
            IRegion resultRegion;
            if (syntaxElement instanceof SimpleNameCS) {
                if (astObj instanceof EModelElement) {
                    return new EModelElementRef((EModelElement)astObj, HyperlinkUtil.createRegion(syntaxElement));
                }
            } else if (syntaxElement instanceof PathNameCS && !PathNameHyperlinkDetector.isConstructorCS(syntaxElement) && astObj instanceof ENamedElement && (resultRegion = PathNameHyperlinkDetector.getPathRegion(pathNameCS = (PathNameCS)syntaxElement, region, selectedNamePos = new int[1])) != null) {
                List selectedNames;
                QvtOperationalEnv env;
                ENamedElement ast = (ENamedElement)pathNameCS.getAst();
                int pos = selectedNamePos[0];
                EList csNames = pathNameCS.getSequenceOfNames();
                if (pos >= 0 && pos < csNames.size() - 1 && (ast = (env = PathNameHyperlinkDetector.getEnv((CSTNode)pathNameCS)).lookupClassifier(selectedNames = csNames.subList(0, pos + 1))) == null) {
                    ast = env.lookupPackage(selectedNames);
                }
                if (ast != null) {
                    return new EModelElementRef((EModelElement)ast, resultRegion);
                }
            }
        } else if (syntaxElement instanceof EnumLiteralExpCS) {
            if (!(astObj instanceof EnumLiteralExp)) {
                return null;
            }
            EnumLiteralExpCS enumExpCS = (EnumLiteralExpCS)syntaxElement;
            EnumLiteralExp enumExpAST = (EnumLiteralExp)enumExpCS.getAst();
            EEnumLiteral enumLit = (EEnumLiteral)enumExpAST.getReferredEnumLiteral();
            if (enumLit != null) {
                SimpleNameCS linkCS = enumExpCS.getSimpleNameCS();
                if (linkCS == null) {
                    linkCS = enumExpCS;
                }
                return new EModelElementRef((EModelElement)enumLit, HyperlinkUtil.createRegion((CSTNode)linkCS));
            }
        }
        return null;
    }

    private static boolean isConstructorCS(CSTNode syntaxElement) {
        if (!(syntaxElement.eContainer() instanceof InstantiationExpCS)) {
            return false;
        }
        InstantiationExpCS constructorCS = (InstantiationExpCS)syntaxElement.eContainer();
        if (!(constructorCS.getAst() instanceof InstantiationExp)) {
            return false;
        }
        InstantiationExp instExp = (InstantiationExp)constructorCS.getAst();
        Adapter adapter = EcoreUtil.getAdapter((List)instExp.eAdapters(), ConstructorOperationAdapter.class);
        return adapter != null && ((ConstructorOperationAdapter)adapter).getReferredConstructor() != null;
    }

    private static IRegion getPathRegion(PathNameCS pathNameCS, IRegion selection, int[] selectedPos) {
        int[] positions = PathNameHyperlinkDetector.getPathPos(pathNameCS);
        if (positions == null) {
            return HyperlinkUtil.createRegion((CSTNode)pathNameCS);
        }
        int nameOffset = pathNameCS.getStartOffset();
        int i = 0;
        for (String name : pathNameCS.getSequenceOfNames()) {
            int offset = selection.getOffset();
            if (nameOffset <= offset && offset <= nameOffset + name.length()) {
                selectedPos[0] = i;
                return new Region(nameOffset, name.length());
            }
            if (i == positions.length) break;
            nameOffset = positions[i++];
        }
        return HyperlinkUtil.createRegion((CSTNode)pathNameCS);
    }

    private static int[] getPathPos(PathNameCS pathNameCS) {
        EList sequenceOfNames = pathNameCS.getSequenceOfNames();
        if (sequenceOfNames.size() == 1) {
            return null;
        }
        int size = sequenceOfNames.size() - 1;
        int[] positions = new int[size];
        Arrays.fill(positions, -1);
        IToken startToken = pathNameCS.getStartToken();
        IToken endToken = pathNameCS.getEndToken();
        PrsStream prsStream = startToken.getPrsStream();
        IToken nextToken = startToken;
        int tokenIndex = 1;
        int i = 0;
        while (nextToken != endToken) {
            nextToken = prsStream.getIToken(startToken.getTokenIndex() + tokenIndex++);
            if (nextToken.getKind() != 2) continue;
            positions[i++] = nextToken.getStartOffset();
            if (i == positions.length) break;
        }
        return positions;
    }

    private static QvtOperationalEnv getEnv(CSTNode node) {
        return (QvtOperationalEnv)CSTHelper.getEnvironment(node);
    }

    private static class EModelElementRef {
        final EModelElement element;
        final IRegion sourceLinkRegion;

        private EModelElementRef(EModelElement element, IRegion sourceLinkRegion) {
            this.element = element;
            this.sourceLinkRegion = sourceLinkRegion;
        }
    }
}

