/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.m2m.internal.qvt.oml.editor.ui.hovers;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextHover;
import org.eclipse.jface.text.ITextHoverExtension2;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.Position;
import org.eclipse.jface.text.Region;
import org.eclipse.jface.text.source.Annotation;
import org.eclipse.jface.text.source.IAnnotationModel;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.m2m.internal.qvt.oml.compiler.CompiledUnit;
import org.eclipse.m2m.internal.qvt.oml.cst.UnitCS;
import org.eclipse.m2m.internal.qvt.oml.editor.ui.Activator;
import org.eclipse.m2m.internal.qvt.oml.editor.ui.CSTHelper;
import org.eclipse.m2m.internal.qvt.oml.editor.ui.QvtDocumentProvider;
import org.eclipse.m2m.internal.qvt.oml.editor.ui.hovers.IElementInfoProvider;
import org.eclipse.m2m.internal.qvt.oml.editor.ui.hovers.ModelTypeInfoProvider;
import org.eclipse.m2m.internal.qvt.oml.editor.ui.hovers.ModuleImportInfoProvider;
import org.eclipse.m2m.internal.qvt.oml.editor.ui.hovers.OperationCallInfoProvider;
import org.eclipse.m2m.internal.qvt.oml.editor.ui.hovers.PathNameInfoProvider;
import org.eclipse.m2m.internal.qvt.oml.editor.ui.hovers.PatternPropertyExpressionInfoProvider;
import org.eclipse.m2m.internal.qvt.oml.editor.ui.hovers.PropertyCallInfoProvider;
import org.eclipse.m2m.internal.qvt.oml.editor.ui.hovers.ResolveInMappingInfoProvider;
import org.eclipse.m2m.internal.qvt.oml.editor.ui.hovers.VariableExpressionInfoProvider;
import org.eclipse.ocl.cst.CSTNode;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class QvtTextHover
implements ITextHover,
ITextHoverExtension2 {
    private final QvtDocumentProvider myDocumentProvider;
    private final IElementInfoProvider[] myElementInfoProviders;

    public QvtTextHover(QvtDocumentProvider documentProvider) {
        this.myDocumentProvider = documentProvider;
        this.myElementInfoProviders = new IElementInfoProvider[]{new OperationCallInfoProvider(), new PropertyCallInfoProvider(), new VariableExpressionInfoProvider(), new PatternPropertyExpressionInfoProvider(), new PathNameInfoProvider(), new ModuleImportInfoProvider(), new ResolveInMappingInfoProvider(), new ModelTypeInfoProvider()};
    }

    public IRegion getHoverRegion(ITextViewer textViewer, int offset) {
        return new Region(offset, 0);
    }

    public Object getHoverInfo2(ITextViewer textViewer, IRegion hoverRegion) {
        return this.getHoverInfo(textViewer, hoverRegion);
    }

    public String getHoverInfo(ITextViewer textViewer, IRegion hoverRegion) {
        if (this.checkCompiledUnit(this.myDocumentProvider.getCompiledModule()) && textViewer != null && textViewer.getDocument() != null) {
            Annotation annotation = this.getAnnotation(textViewer, hoverRegion.getOffset());
            if (annotation != null) {
                return annotation.getText();
            }
            UnitCS rootCS = this.myDocumentProvider.getCompiledModule().getUnitCST();
            List<CSTNode> elements = CSTHelper.selectTargetedElements((CSTNode)rootCS, hoverRegion);
            if (!elements.isEmpty()) {
                try {
                    return this.getElementsInfo(elements, textViewer, hoverRegion);
                }
                catch (Exception e) {
                    Activator.log(e);
                }
            }
        }
        return "";
    }

    public Annotation getAnnotation(ITextViewer textViewer, int offset) {
        if (textViewer instanceof ISourceViewer) {
            final IAnnotationModel annotationModel = ((ISourceViewer)textViewer).getAnnotationModel();
            if (annotationModel == null) {
                return null;
            }
            ArrayList<Annotation> annotations = new ArrayList<Annotation>();
            Iterator iter = annotationModel.getAnnotationIterator();
            while (iter.hasNext()) {
                Position position;
                Annotation annotation = (Annotation)iter.next();
                if (!annotation.isPersistent() || annotation.isMarkedDeleted() || (position = annotationModel.getPosition(annotation)) == null || !position.includes(offset)) continue;
                annotations.add(annotation);
            }
            if (!annotations.isEmpty()) {
                Collections.sort(annotations, new Comparator<Annotation>(){

                    @Override
                    public int compare(Annotation o1, Annotation o2) {
                        Position p1 = annotationModel.getPosition(o1);
                        Position p2 = annotationModel.getPosition(o2);
                        return p1.getLength() - p2.getLength();
                    }
                });
                return (Annotation)annotations.get(0);
            }
        }
        return null;
    }

    private String getElementsInfo(List<CSTNode> elements, ITextViewer textViewer, IRegion hoverRegion) {
        for (CSTNode nextElement : elements) {
            int i = 0;
            while (i < this.myElementInfoProviders.length) {
                IElementInfoProvider provider = this.myElementInfoProviders[i];
                try {
                    String info = provider.getElementInfo(nextElement, textViewer, hoverRegion);
                    if (info != null && info.length() > 0) {
                        return info;
                    }
                }
                catch (NullPointerException nullPointerException) {}
                ++i;
            }
        }
        return "";
    }

    private boolean checkCompiledUnit(CompiledUnit unit) {
        return unit != null && unit.getUnitCST() != null;
    }
}

