/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.m2m.atl.engine.extractors.xml;

import java.io.BufferedOutputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.util.Collections;
import java.util.Iterator;
import java.util.Map;
import org.eclipse.m2m.atl.engine.extractors.Extractor;
import org.eclipse.m2m.atl.engine.vm.nativelib.ASMCollection;
import org.eclipse.m2m.atl.engine.vm.nativelib.ASMModel;
import org.eclipse.m2m.atl.engine.vm.nativelib.ASMModelElement;
import org.eclipse.m2m.atl.engine.vm.nativelib.ASMOclAny;
import org.eclipse.m2m.atl.engine.vm.nativelib.ASMString;

public class XMLExtractor
implements Extractor {
    private static Map parameterTypes = Collections.EMPTY_MAP;

    public Map getParameterTypes() {
        return parameterTypes;
    }

    public void extract(ASMModel source, OutputStream target, Map params) {
        this.extract(null, source, target);
    }

    public String getPrefix() {
        return "xml";
    }

    public void extract(ASMModel format, ASMModel extent, OutputStream out) {
        PrintStream out2 = new PrintStream(new BufferedOutputStream(out));
        out2.println("<?xml version = '1.0' encoding = 'ISO-8859-1' ?>");
        this.write((ASMModelElement)extent.getElementsByType("Root").iterator().next(), extent, out2, "");
        out2.close();
    }

    private void write(ASMModelElement o, ASMModel extent, PrintStream out, String indent) {
        String oTypeName = this.getString(o.getMetaobject(), "name");
        if (oTypeName.equals("Element") || oTypeName.equals("Root")) {
            String typeName;
            ASMModelElement c;
            String name = this.getString(o, "name");
            out.print(String.valueOf(indent) + "<" + name);
            ASMCollection children = (ASMCollection)o.get(null, "children");
            boolean hasElements = false;
            boolean hasTexts = false;
            Iterator i = children.iterator();
            while (i.hasNext()) {
                c = (ASMModelElement)i.next();
                typeName = this.getString(c.getMetaobject(), "name");
                if (typeName.equals("Attribute")) {
                    out.print(" " + this.getString(c, "name") + " = '" + this.convertText(this.getString(c, "value"), true) + "'");
                    continue;
                }
                if (typeName.equals("Element")) {
                    hasElements = true;
                    continue;
                }
                if (!typeName.equals("Text")) continue;
                hasTexts = true;
            }
            if (hasElements) {
                out.println(">");
                i = children.iterator();
                while (i.hasNext()) {
                    c = (ASMModelElement)i.next();
                    typeName = this.getString(c.getMetaobject(), "name");
                    if (typeName.equals("Element")) {
                        this.write(c, extent, out, String.valueOf(indent) + "  ");
                        continue;
                    }
                    if (!typeName.equals("Text")) continue;
                    out.print(this.convertText(this.getString(c, "value"), false));
                }
                out.println(String.valueOf(indent) + "</" + name + ">");
            } else if (hasTexts) {
                out.print(">");
                i = children.iterator();
                while (i.hasNext()) {
                    c = (ASMModelElement)i.next();
                    typeName = this.getString(c.getMetaobject(), "name");
                    if (!typeName.equals("Text")) continue;
                    out.print(this.convertText(this.getString(c, "value"), false));
                }
                out.println("</" + name + ">");
            } else {
                out.println("/>");
            }
        }
    }

    private String getString(ASMModelElement ame, String name) {
        ASMOclAny ret = ame.get(null, name);
        if (!(ret instanceof ASMString)) {
            throw new RuntimeException("could not read " + name + " of " + ame + " : " + ame.getType());
        }
        return ((ASMString)ret).getSymbol();
    }

    private String convertText(String in, boolean inAttr) {
        String ret = in.replaceAll("&", "&amp;").replaceAll("<", "&lt;").replaceAll(">", "&gt;");
        if (inAttr) {
            ret = ret.replaceAll("\n", "&#10;").replaceAll("\t", "&#9;").replaceAll("'", "&apos;").replaceAll("\"", "&quot;");
        }
        return ret;
    }
}

