/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmf.internal.xpand.editor;

import java.net.MalformedURLException;
import java.net.URL;
import org.eclipse.gmf.internal.xpand.editor.Activator;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.ImageRegistry;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Display;

public class EditorImages {
    public static final String EXTENSION = "extension.gif";
    public static final String OPERATION = "operation.gif";
    public static final String PROPERTY = "property.gif";
    public static final String VARIABLE = "variable.gif";
    public static final String TYPE = "type.gif";
    public static final String STATEMENT = "statement.gif";
    private static ImageRegistry imageRegistry;
    private static URL ICON_BASE_URL;

    static {
        ICON_BASE_URL = null;
        ICON_BASE_URL = Activator.getDefault().getBundle().getEntry("icons/");
        EditorImages.initializeImageRegistry();
    }

    private static void declareImages() {
        EditorImages.declareRegistryImage(EXTENSION, EXTENSION);
        EditorImages.declareRegistryImage(OPERATION, OPERATION);
        EditorImages.declareRegistryImage(PROPERTY, PROPERTY);
        EditorImages.declareRegistryImage(VARIABLE, VARIABLE);
        EditorImages.declareRegistryImage(STATEMENT, STATEMENT);
        EditorImages.declareRegistryImage(TYPE, TYPE);
    }

    private static final void declareRegistryImage(String key, String path) {
        ImageDescriptor desc = ImageDescriptor.getMissingImageDescriptor();
        try {
            desc = ImageDescriptor.createFromURL((URL)EditorImages.makeIconFileURL(path));
        }
        catch (MalformedURLException me) {
            Activator.logError(me);
        }
        imageRegistry.put(key, desc);
    }

    public static ImageRegistry getImageRegistry() {
        if (imageRegistry == null) {
            EditorImages.initializeImageRegistry();
        }
        return imageRegistry;
    }

    public static ImageRegistry initializeImageRegistry() {
        imageRegistry = new ImageRegistry(Display.getCurrent() == null ? Display.getDefault() : Display.getCurrent());
        EditorImages.declareImages();
        return imageRegistry;
    }

    public static Image getImage(String key) {
        return EditorImages.getImageRegistry().get(key);
    }

    public static ImageDescriptor getImageDescriptor(String key) {
        return EditorImages.getImageRegistry().getDescriptor(key);
    }

    private static URL makeIconFileURL(String iconPath) throws MalformedURLException {
        if (ICON_BASE_URL == null) {
            throw new MalformedURLException();
        }
        return new URL(ICON_BASE_URL, iconPath);
    }
}

