/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmf.runtime.draw2d.ui.render.internal.svg.metafile;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.util.Enumeration;
import java.util.Vector;
import junit.framework.Assert;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import junit.textui.TestRunner;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.gmf.runtime.draw2d.ui.render.awt.internal.svg.metafile.EMFTranscoder;
import org.eclipse.gmf.runtime.draw2d.ui.render.awt.internal.svg.metafile.WMFTranscoder;
import org.osgi.framework.Bundle;

public class Metafile2SvgTest
extends TestCase {
    private static final boolean GENERATE_SVG_FILES = false;
    private Bundle bundle;

    public Metafile2SvgTest(String name) {
        super(name);
    }

    public static void main(String[] args) {
        TestRunner.run((Test)Metafile2SvgTest.suite());
    }

    public static Test suite() {
        return new TestSuite(Metafile2SvgTest.class);
    }

    protected void setUp() throws Exception {
        super.setUp();
        this.bundle = Platform.getBundle((String)"org.eclipse.gmf.tests.runtime.draw2d.ui.render");
    }

    protected void tearDown() throws Exception {
        super.tearDown();
    }

    public void testEmf2Svg() throws Exception {
        String rootDir = "resources/metafiles/";
        Enumeration enumFiles = this.bundle.getEntryPaths(rootDir);
        Vector<String> failures = new Vector<String>();
        while (enumFiles.hasMoreElements()) {
            String metafileName = (String)enumFiles.nextElement();
            Path filePath = new Path(metafileName);
            if ((filePath == null || !metafileName.endsWith("emf")) && !metafileName.endsWith("wmf")) continue;
            String svgFilename = String.valueOf(metafileName.substring(0, metafileName.length() - 3)) + "svg";
            URL url = FileLocator.find((Bundle)this.bundle, (IPath)filePath, null);
            InputStream metafileInputStream = url.openStream();
            try {
                ByteArrayOutputStream svgOutputStream = new ByteArrayOutputStream(10000);
                Object tc = metafileName.endsWith(".emf") ? new EMFTranscoder() : new WMFTranscoder();
                URL svgUrl = FileLocator.find((Bundle)this.bundle, (IPath)new Path(svgFilename), null);
                tc.transcode(metafileInputStream, (OutputStream)svgOutputStream, svgUrl.toString());
                InputStream svgInputStream = svgUrl.openStream();
                byte[] fileBytes = new byte[svgInputStream.available()];
                svgInputStream.read(fileBytes);
                svgInputStream.close();
                svgOutputStream.flush();
                svgOutputStream.close();
                byte[] generatedBytes = svgOutputStream.toByteArray();
                if (fileBytes.length != generatedBytes.length) {
                    String errorMessage = "Data sizes are not equal: " + svgFilename + " Expected: " + fileBytes.length + " Received: " + generatedBytes.length + "\n";
                    failures.add(errorMessage);
                    this.writeErrorFile(svgFilename, generatedBytes);
                    continue;
                }
                int i = 0;
                while (i < fileBytes.length) {
                    if (fileBytes[i] != generatedBytes[i]) {
                        String errorMessage = "Data is different in file '" + svgFilename + "' at byte " + i + "\n";
                        failures.add(errorMessage);
                        this.writeErrorFile(svgFilename, generatedBytes);
                        break;
                    }
                    ++i;
                }
                metafileInputStream.close();
            }
            catch (Exception e) {
                String errorMessage = "Caught exception while processing file " + metafileName + "\n" + e.toString();
                failures.add(errorMessage);
            }
        }
        if (failures.size() > 0) {
            String failureString = "";
            int index = 0;
            while (index < failures.size()) {
                failureString = String.valueOf(failureString) + (String)failures.get(index);
                ++index;
            }
            Assert.assertEquals((String)("Found failures:\n" + failureString), (int)0, (int)failures.size());
        }
    }

    private void writeErrorFile(String svgFilename, byte[] data) throws IOException {
        String filename = String.valueOf(svgFilename.substring(0, svgFilename.length() - 4)) + "_failed.svg";
        File errorFile = new File(filename);
        if (errorFile.exists()) {
            if (!errorFile.canWrite()) {
                return;
            }
            errorFile.delete();
        }
        errorFile.createNewFile();
        FileOutputStream svgOutputStream = new FileOutputStream(errorFile);
        svgOutputStream.write(data);
        svgOutputStream.flush();
        svgOutputStream.close();
    }
}

