/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmf.internal.xpand.expression.ast;

import java.util.Set;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.gmf.internal.xpand.expression.AnalysationIssue;
import org.eclipse.gmf.internal.xpand.expression.ExecutionContext;
import org.eclipse.gmf.internal.xpand.expression.Variable;
import org.eclipse.gmf.internal.xpand.expression.ast.Expression;
import org.eclipse.gmf.internal.xpand.expression.ast.Identifier;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LetExpression
extends Expression {
    private Expression varExpression;
    private Expression targetExpression;
    private Identifier varName;

    public LetExpression(int start, int end, int line, int startOffset, int endOffset, Identifier varName, Expression varExpression, Expression target) {
        super(start, end, line, startOffset, endOffset);
        this.varName = varName;
        this.varExpression = varExpression;
        this.targetExpression = target;
    }

    @Override
    public Object evaluateInternal(ExecutionContext ctx) {
        Object o = this.varExpression.evaluate(ctx);
        ctx = ctx.cloneWithVariable(new Variable(this.varName.getValue(), o));
        return this.targetExpression.evaluate(ctx);
    }

    @Override
    public EClassifier analyze(ExecutionContext ctx, Set<AnalysationIssue> issues) {
        EClassifier t = this.varExpression.analyze(ctx, issues);
        if (t == null) {
            return null;
        }
        ctx = ctx.cloneWithVariable(new Variable(this.varName.getValue(), t));
        return this.targetExpression.analyze(ctx, issues);
    }

    public String toString() {
        return "let " + this.varName + "=" + this.varExpression + " : " + this.targetExpression;
    }

    public Identifier getVarName() {
        return this.varName;
    }

    public Expression getVarExpression() {
        return this.varExpression;
    }

    public Expression getTargetExpression() {
        return this.targetExpression;
    }
}

