/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmf.internal.validate.ocl;

import java.text.MessageFormat;
import java.util.Collection;
import java.util.HashSet;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EDataType;
import org.eclipse.emf.ecore.EEnumLiteral;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EOperation;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EParameter;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.ETypedElement;
import org.eclipse.emf.ecore.EcorePackage;
import org.eclipse.emf.ecore.impl.EPackageRegistryImpl;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.gmf.internal.validate.DebugOptions;
import org.eclipse.gmf.internal.validate.DefUtils;
import org.eclipse.gmf.internal.validate.EDataTypeConversion;
import org.eclipse.gmf.internal.validate.GMFValidationPlugin;
import org.eclipse.gmf.internal.validate.Messages;
import org.eclipse.gmf.internal.validate.StatusCodes;
import org.eclipse.gmf.internal.validate.Trace;
import org.eclipse.gmf.internal.validate.expressions.AbstractExpression;
import org.eclipse.gmf.internal.validate.expressions.IEvaluationEnvironment;
import org.eclipse.gmf.internal.validate.expressions.IParseEnvironment;
import org.eclipse.ocl.Environment;
import org.eclipse.ocl.EnvironmentFactory;
import org.eclipse.ocl.ParserException;
import org.eclipse.ocl.Query;
import org.eclipse.ocl.ecore.CallOperationAction;
import org.eclipse.ocl.ecore.CollectionType;
import org.eclipse.ocl.ecore.Constraint;
import org.eclipse.ocl.ecore.EcoreEnvironmentFactory;
import org.eclipse.ocl.ecore.OCL;
import org.eclipse.ocl.ecore.SendSignalAction;
import org.eclipse.ocl.ecore.TypeType;
import org.eclipse.ocl.expressions.ExpressionsFactory;
import org.eclipse.ocl.expressions.OCLExpression;
import org.eclipse.ocl.expressions.Variable;
import org.eclipse.ocl.options.Option;
import org.eclipse.ocl.options.ParsingOptions;

class OCLExpressionAdapter
extends AbstractExpression {
    public static final String OCL = "ocl";
    private Query<EClassifier, EClass, EObject> query;
    private Environment<EPackage, EClassifier, EOperation, EStructuralFeature, EEnumLiteral, EParameter, EObject, CallOperationAction, SendSignalAction, Constraint, EClass, EObject> env;

    public OCLExpressionAdapter(String body, EClassifier context, IParseEnvironment extEnv) {
        super(body, context, extEnv);
        try {
            OCL ocl = null;
            if (extEnv != null) {
                EcoreEnvironmentFactory factory = EcoreEnvironmentFactory.INSTANCE;
                if (extEnv.getImportRegistry() != null) {
                    factory = new EcoreEnvironmentFactory(extEnv.getImportRegistry());
                }
                ocl = org.eclipse.ocl.ecore.OCL.newInstance((EnvironmentFactory)factory);
                this.env = ocl.getEnvironment();
                for (String varName : extEnv.getVariableNames()) {
                    EClassifier type = extEnv.getTypeOf(varName);
                    Variable varDecl = ExpressionsFactory.eINSTANCE.createVariable();
                    varDecl.setName(varName);
                    varDecl.setType((Object)type);
                    this.env.addElement(varDecl.getName(), varDecl, true);
                }
            } else {
                EPackageRegistryImpl registry = new EPackageRegistryImpl();
                for (Object nextRegistryObject : EPackage.Registry.INSTANCE.values()) {
                    if (!(nextRegistryObject instanceof EPackage)) continue;
                    EPackage ePackage = (EPackage)nextRegistryObject;
                    registry.put((Object)ePackage.getNsURI(), (Object)ePackage);
                }
                if (context.eResource() != null && context.eResource().getResourceSet() != null) {
                    ResourceSet resourceSet = context.eResource().getResourceSet();
                    EcoreUtil.resolveAll((ResourceSet)resourceSet);
                    HashSet ePackages = new HashSet();
                    for (Resource resource : resourceSet.getResources()) {
                        ePackages.addAll(EcoreUtil.getObjectsByType((Collection)resource.getContents(), (EClassifier)EcorePackage.Literals.EPACKAGE));
                    }
                    for (EPackage ePackage : ePackages) {
                        registry.put((Object)ePackage.getNsURI(), (Object)ePackage);
                    }
                }
                ocl = org.eclipse.ocl.ecore.OCL.newInstance((EnvironmentFactory)new EcoreEnvironmentFactory((EPackage.Registry)registry));
                this.env = ocl.getEnvironment();
            }
            ParsingOptions.setOption(this.env, (Option)ParsingOptions.implicitRootClass(this.env), (Object)EcorePackage.Literals.EOBJECT);
            OCL.Helper helper = ocl.createOCLHelper();
            helper.setContext((Object)context);
            this.query = ocl.createQuery((OCLExpression)helper.createQuery(body));
        }
        catch (ParserException e) {
            this.setInvalidOclExprStatus((Exception)((Object)e));
        }
        catch (IllegalArgumentException e) {
            this.setInvalidOclExprStatus(e);
        }
        catch (RuntimeException e) {
            this.setStatus(GMFValidationPlugin.createStatus(4, StatusCodes.UNEXPECTED_PARSE_ERROR, Messages.unexpectedExprParseError, e));
            GMFValidationPlugin.log(this.getStatus());
            Trace.catching(DebugOptions.EXCEPTIONS_CATCHING, e);
        }
    }

    public String getLanguage() {
        return OCL;
    }

    public boolean isLooselyTyped() {
        return false;
    }

    public boolean isAssignableTo(EClassifier ecoreType) {
        if (this.env == null) {
            return false;
        }
        EClassifier oclType = (EClassifier)this.env.getUMLReflection().getOCLType((Object)ecoreType);
        if (oclType == null) {
            return false;
        }
        return this.isOclConformantTo(oclType);
    }

    public boolean isAssignableToElement(ETypedElement typedElement) {
        if (this.env == null || typedElement.getEType() == null) {
            return false;
        }
        EClassifier oclType = (EClassifier)this.env.getUMLReflection().getOCLType((Object)typedElement);
        if (oclType == null) {
            return false;
        }
        return this.isOclConformantTo(oclType);
    }

    public EClassifier getResultType() {
        return this.query != null ? (EClassifier)this.query.getExpression().getType() : super.getResultType();
    }

    protected Object doEvaluate(Object context) {
        return this.filterOCLInvalid(this.query != null ? this.query.evaluate(context) : null);
    }

    protected Object doEvaluate(Object context, IEvaluationEnvironment extEnvironment) {
        if (this.query != null) {
            this.query.getEvaluationEnvironment().clear();
            for (String varName : extEnvironment.getVariableNames()) {
                this.query.getEvaluationEnvironment().add(varName, extEnvironment.getValueOf(varName));
            }
        }
        return this.doEvaluate(context);
    }

    private Object filterOCLInvalid(Object object) {
        return this.env != null && object == this.env.getOCLStandardLibrary().getOclInvalid() ? null : object;
    }

    private boolean isOclConformantTo(EClassifier anotherOclType) {
        EClassifier thisRefferedClassifier;
        CollectionType oclCollectionType;
        EClassifier thisOclType = this.getResultType();
        boolean isTargetCollection = anotherOclType instanceof CollectionType;
        if (isTargetCollection && (oclCollectionType = (CollectionType)anotherOclType).getElementType() != null) {
            anotherOclType = (EClassifier)oclCollectionType.getElementType();
        }
        if (thisOclType instanceof CollectionType) {
            if (!isTargetCollection) {
                return false;
            }
            CollectionType thisOclCollectionType = (CollectionType)thisOclType;
            if (thisOclCollectionType.getElementType() != null) {
                thisOclType = (EClassifier)thisOclCollectionType.getElementType();
            }
        }
        if (thisOclType instanceof TypeType && (thisRefferedClassifier = (EClassifier)((TypeType)thisOclType).getReferredType()) != null) {
            return DefUtils.getCanonicalEClassifier(anotherOclType).isInstance((Object)thisRefferedClassifier);
        }
        if (!(thisOclType.getInstanceClass() != Integer.class && thisOclType.getInstanceClass() != Integer.TYPE || anotherOclType.getInstanceClass() != Double.class && anotherOclType.getInstanceClass() != Double.TYPE)) {
            return true;
        }
        if (thisOclType instanceof EDataType && anotherOclType instanceof EDataType && new EDataTypeConversion().isConvertable((EDataType)anotherOclType, (EDataType)thisOclType)) {
            return true;
        }
        return DefUtils.checkTypeAssignmentCompatibility(anotherOclType, thisOclType);
    }

    void setInvalidOclExprStatus(Exception exception) {
        String message = MessageFormat.format(Messages.invalidExpressionBody, this.getBody(), exception.getLocalizedMessage());
        this.setStatus(GMFValidationPlugin.createStatus(4, StatusCodes.INVALID_VALUE_EXPRESSION, message, exception));
        Trace.catching(DebugOptions.EXCEPTIONS_CATCHING, exception);
    }
}

