/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmf.tests.expression.ast;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.emf.ecore.EEnumLiteral;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.EcorePackage;
import org.eclipse.gmf.internal.xpand.expression.EvaluationException;
import org.eclipse.gmf.internal.xpand.expression.ExecutionContext;
import org.eclipse.gmf.internal.xpand.expression.Variable;
import org.eclipse.gmf.internal.xpand.expression.ast.Expression;
import org.eclipse.gmf.tests.expression.ast.ATypeModel;
import org.eclipse.gmf.tests.expression.ast.AbstractExpressionTest;

public class EvaluationTest
extends AbstractExpressionTest {
    private ExecutionContext ec;
    private ATypeModel aType;

    protected void setUp() throws Exception {
        this.aType = new ATypeModel();
        this.ec = this.aType.newContext(null);
    }

    public final void testSimple() {
        Expression expr = this.parse("true == null");
        Object result = expr.evaluate(this.ec);
        EvaluationTest.assertFalse((boolean)((Boolean)result));
    }

    public final void testStaticPropertyCall() {
        Expression expr = this.parse("evaluationTestModel::Type1::A_LITERAL");
        Object result = expr.evaluate(this.ec);
        EEnumLiteral metaLiteral1 = this.aType.getMetaEnum().getEEnumLiteral("A_LITERAL");
        EvaluationTest.assertEquals((Object)metaLiteral1.getInstance(), (Object)result);
    }

    public final void testCollectionLiteral1() {
        Expression expr = this.parse("{\"hallo\"}");
        Object result = expr.evaluate(this.ec);
        EvaluationTest.assertEquals((Object)"hallo", ((List)result).iterator().next());
    }

    public final void testCollectionLiteral3() {
        Expression expr = this.parse("{3}");
        Object result = expr.evaluate(this.ec);
        EvaluationTest.assertEquals((Object)3, ((List)result).iterator().next());
    }

    public final void testCollectionLiteral2() {
        Expression expr = this.parse("{\"hallo\",3}");
        List result = (List)expr.evaluate(this.ec);
        EvaluationTest.assertEquals((int)2, (int)result.size());
        EvaluationTest.assertEquals((Object)"hallo", result.get(0));
        EvaluationTest.assertEquals((Object)3, result.get(1));
    }

    public final void testFeatureCall() {
        Expression expr = this.parse("test");
        this.ec = this.ec.cloneWithVariable(new Variable[]{new Variable("this", this.aType.getInstance())});
        Object result = expr.evaluate(this.ec);
        EvaluationTest.assertEquals((Object)this.aType.getATypeTestFeatureValue(), (Object)result);
    }

    public final void testFeatureCall1() {
        Expression expr = this.parse("this.test");
        this.ec = this.ec.cloneWithVariable(new Variable[]{new Variable("this", this.aType.getInstance())});
        Object result = expr.evaluate(this.ec);
        EvaluationTest.assertEquals((Object)this.aType.getATypeTestFeatureValue(), (Object)result);
    }

    public final void testEqualsNull() {
        Expression expr = this.parse("this == null");
        this.ec = this.ec.cloneWithVariable(new Variable[]{new Variable("this", this.aType.getInstance())});
        Object result = expr.evaluate(this.ec);
        EvaluationTest.assertEquals((Object)Boolean.FALSE, (Object)result);
    }

    public final void testNotEqualsNull() {
        Expression expr = this.parse("this != null");
        this.ec = this.ec.cloneWithVariable(new Variable[]{new Variable("this", this.aType.getInstance())});
        Object result = expr.evaluate(this.ec);
        EvaluationTest.assertEquals((Object)Boolean.TRUE, (Object)result);
    }

    public final void testOperationCall1() {
        this.aType.registerOperations();
        Expression expr = this.parse("myOperation()");
        this.ec = this.ec.cloneWithVariable(new Variable[]{new Variable("this", this.aType.getInstance())});
        Object result = expr.evaluate(this.ec);
        EvaluationTest.assertEquals((Object)ATypeModel.myOperation(), (Object)result);
    }

    public final void testOperationCall2() {
        this.aType.registerOperations();
        Expression expr = this.parse("myOperation(\"Test\")");
        this.ec = this.ec.cloneWithVariable(new Variable[]{new Variable("this", this.aType.getInstance())});
        Object result = expr.evaluate(this.ec);
        EvaluationTest.assertEquals((Object)ATypeModel.myOperation("Test"), (Object)result);
    }

    public final void testOperationCall3() {
        this.aType.registerOperations();
        Expression expr = this.parse("this.myOperation()");
        this.ec = this.ec.cloneWithVariable(new Variable[]{new Variable("this", this.aType.getInstance())});
        Object result = expr.evaluate(this.ec);
        EvaluationTest.assertEquals((Object)ATypeModel.myOperation(), (Object)result);
    }

    public final void testOperationCall4() {
        this.aType.registerOperations();
        Expression expr = this.parse("this.myOperation(\"Test\")");
        this.ec = this.ec.cloneWithVariable(new Variable[]{new Variable("this", this.aType.getInstance())});
        Object result = expr.evaluate(this.ec);
        EvaluationTest.assertEquals((Object)ATypeModel.myOperation("Test"), (Object)result);
    }

    public final void testArithmetic() {
        Expression expr = this.parse("3 + 4 * 2");
        EvaluationTest.assertEquals((Object)11, (Object)expr.evaluate(this.ec));
        expr = this.parse("4 * 2 + 3");
        EvaluationTest.assertEquals((Object)11, (Object)expr.evaluate(this.ec));
        expr = this.parse("4 * 2 + 3 / 3");
        EvaluationTest.assertEquals((Object)9, (Object)expr.evaluate(this.ec));
    }

    public final void testArithmetic2() {
        Expression expr = this.parse("3 + 4.0 * 2");
        EvaluationTest.assertEquals((Object)new Double(11.0), (Object)expr.evaluate(this.ec));
        expr = this.parse("4.0 * 2 + 3");
        EvaluationTest.assertEquals((Object)new Double(11.0), (Object)expr.evaluate(this.ec));
        expr = this.parse("4 * 2 + 3 / 3.0");
        EvaluationTest.assertEquals((Object)new Double(9.0), (Object)expr.evaluate(this.ec));
    }

    public final void testArithmetic3() {
        Expression expr = this.parse("5 / 2");
        EvaluationTest.assertEquals((Object)2, (Object)expr.evaluate(this.ec));
        expr = this.parse("5 / 2.0");
        EvaluationTest.assertEquals((Object)new Double(2.5), (Object)expr.evaluate(this.ec));
    }

    public final void testArithmetic4_Precedence() {
        Expression expr = this.parse("10-5-5");
        EvaluationTest.assertEquals((Object)0, (Object)expr.evaluate(this.ec));
    }

    public final void testNegation() {
        Expression expr = this.parse("-1");
        EvaluationTest.assertEquals((Object)-1, (Object)expr.evaluate(this.ec));
        expr = this.parse("-2.5");
        EvaluationTest.assertEquals((Object)-2.5, (Object)expr.evaluate(this.ec));
        expr = this.parse("(0-2) == -2");
        EvaluationTest.assertEquals((Object)Boolean.TRUE, (Object)expr.evaluate(this.ec));
    }

    public final void testStringConcatenation1() {
        Expression expr = this.parse("\"test\" + 3 + 4");
        EvaluationTest.assertEquals((Object)"test34", (Object)expr.evaluate(this.ec));
    }

    public final void testStringConcatenation2() {
        Expression expr = this.parse("(\"test\" + 3) + 4");
        EvaluationTest.assertEquals((Object)"test34", (Object)expr.evaluate(this.ec));
    }

    public final void testNullReference() {
        this.ec = this.ec.cloneWithVariable(new Variable[]{new Variable("nullRef", null)});
        Expression expr = this.parse("nullRef + \"test\" + 3 + 4");
        EvaluationTest.assertEquals(null, (Object)expr.evaluate(this.ec));
        this.ec = this.ec.cloneWithVariable(new Variable[]{new Variable("this", null)});
        EvaluationTest.assertNull((Object)this.parse("this.unknownMember").evaluate(this.ec));
    }

    public final void testTypeLiteral1() {
        EvaluationTest.assertEquals((Object)EcorePackage.eINSTANCE.getEString(), (Object)this.parse("String").evaluate(this.ec));
    }

    public final void testTypeLiteral2() {
        Expression e = this.parse("EClass.getEStructuralFeature('name')");
        EvaluationTest.assertTrue((boolean)(e.evaluate(this.ec) instanceof EStructuralFeature));
    }

    public final void testPath1() {
        Expression expr = this.parse("{'a','b','c'}.toUpperCase()");
        List result = (List)expr.evaluate(this.ec);
        EvaluationTest.assertEquals((Object)"A", result.get(0));
        EvaluationTest.assertEquals((Object)"B", result.get(1));
        EvaluationTest.assertEquals((Object)"C", result.get(2));
    }

    public final void testPath2() {
        Expression expr = this.parse("{'a','b','c'}.size()");
        EvaluationTest.assertEquals((Object)3, (Object)expr.evaluate(this.ec));
    }

    public final void testPath3() {
        Expression expr = this.parse("{'a','b2','c'}.toUpperCase().length()");
        List result = (List)expr.evaluate(this.ec);
        EvaluationTest.assertEquals((Object)1, result.get(0));
        EvaluationTest.assertEquals((Object)2, result.get(1));
        EvaluationTest.assertEquals((Object)1, result.get(2));
    }

    public final void testPath4() {
        Expression expr = this.parse("{'a,b2,c','a,b,c','a,b,c'}.split(',').length()");
        List result = (List)expr.evaluate(this.ec);
        EvaluationTest.assertEquals((int)9, (int)result.size());
        EvaluationTest.assertEquals((Object)1, result.get(0));
        EvaluationTest.assertEquals((Object)2, result.get(1));
        EvaluationTest.assertEquals((Object)1, result.get(2));
    }

    public final void testNestedCollExpr() {
        Expression expr = this.parse("col.typeSelect(String).forAll(e|col.typeSelect(Integer).exists(a| a == e.length()))");
        ArrayList<Object> list = new ArrayList<Object>();
        list.add("123");
        list.add("1234");
        list.add("12345");
        list.add(3);
        list.add(4);
        ExecutionContext contextWithVar = this.ec.cloneWithVariable(new Variable[]{new Variable("col", list)});
        EvaluationTest.assertEquals((Object)Boolean.FALSE, (Object)expr.evaluate(contextWithVar));
        list.add(5);
        EvaluationTest.assertEquals((Object)Boolean.TRUE, (Object)expr.evaluate(contextWithVar));
    }

    public final void testTypeSelectWithNull() {
        Expression expr = this.parse("{null, 'test'}.typeSelect(String).size()");
        EvaluationTest.assertEquals((Object)1, (Object)expr.evaluate(this.ec));
    }

    public final void testLet1() {
        Expression expr = this.parse("let x = {'a,b2,c','a,b,c','1,2,3'} : x.get(1)");
        EvaluationTest.assertEquals((Object)"a,b,c", (Object)expr.evaluate(this.ec));
    }

    public final void testLet2() {
        Expression expr = this.parse("let x = {} : x.add('1') -> x.add('2') -> x.add('3') -> x");
        ArrayList<String> l = new ArrayList<String>();
        l.add("1");
        l.add("2");
        l.add("3");
        EvaluationTest.assertEquals(l, (Object)expr.evaluate(this.ec));
    }

    public final void testConstruction() {
        Expression expr = this.parse("new String");
        EvaluationTest.assertEquals((Object)"", (Object)expr.evaluate(this.ec));
        try {
            this.parse("new Unkown").evaluate(this.ec);
            EvaluationTest.fail();
        }
        catch (EvaluationException evaluationException) {}
    }
}

