/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmf.mappings.util;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.gmf.internal.common.migrate.MigrationConfig;
import org.eclipse.gmf.mappings.FeatureLabelMapping;
import org.eclipse.gmf.mappings.GMFMapPackage;
import org.eclipse.gmf.mappings.LabelMapping;
import org.eclipse.gmf.mappings.MappingEntry;

public class GMFMapMigration {
    private static final String GMFMAP_FILE_EXT = "gmfmap";
    private static final String eNS_URI_1_0 = "http://www.eclipse.org/gmf/2005/mappings";
    public static final MigrationConfig.Descriptor CONFIG = new MigrationConfig.Descriptor(){

        public String getExtension() {
            return GMFMapMigration.GMFMAP_FILE_EXT;
        }

        public MigrationConfig getConfig() {
            MigrationConfig config = new MigrationConfig("http://www.eclipse.org/gmf/2005/mappings/2.0", new String[]{GMFMapMigration.eNS_URI_1_0}){

                protected void handleResourceLoaded(Resource resource, Map<EObject, Map<String, String>> ignoredAttributes) {
                    TreeIterator it = resource.getAllContents();
                    while (it.hasNext()) {
                        EObject object = (EObject)it.next();
                        if (!(object instanceof MappingEntry)) continue;
                        MappingEntry entry = (MappingEntry)object;
                        ArrayList<LabelMapping> mappings = new ArrayList<LabelMapping>((Collection<LabelMapping>)entry.getLabelMappings());
                        for (LabelMapping mapping : mappings) {
                            if (!(mapping instanceof FeatureLabelMapping) || !((FeatureLabelMapping)mapping).getFeatures().isEmpty()) continue;
                            entry.getLabelMappings().remove((Object)mapping);
                            LabelMapping newMapping = GMFMapPackage.eINSTANCE.getGMFMapFactory().createLabelMapping();
                            newMapping.setDiagramLabel(mapping.getDiagramLabel());
                            if (mapping.isReadOnly()) {
                                newMapping.setReadOnly(true);
                            }
                            entry.getLabelMappings().add((Object)newMapping);
                        }
                    }
                }
            };
            GMFMapMigration.initialize(config);
            return config;
        }
    };

    static void initialize(MigrationConfig config) {
        config.addNarrowReferenceType(GMFMapPackage.eINSTANCE.getFeatureSeqInitializer_Initializers(), GMFMapPackage.eINSTANCE.getFeatureValueSpec());
        config.addNarrowReferenceType(GMFMapPackage.eINSTANCE.getMappingEntry_LabelMappings(), GMFMapPackage.eINSTANCE.getFeatureLabelMapping());
    }
}

