/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmf.internal.common.migrate;

import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EFactory;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.EcoreFactory;
import org.eclipse.emf.ecore.EcorePackage;
import org.eclipse.gmf.internal.common.migrate.MigrationHelperDelegate;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MigrationHelperDelegateImpl
implements MigrationHelperDelegate {
    private static EStructuralFeature ourDeletedAttribute = EcoreFactory.eINSTANCE.createEAttribute();
    private Map<EClassifier, Collection<String>> myDeletedAttributes = new HashMap<EClassifier, Collection<String>>();
    private Map<EReference, EClass> myNarrowReferenceTypes = new HashMap<EReference, EClass>();
    private Map<EClass, Map<String, EStructuralFeature>> myRenamedAttributes = new HashMap<EClass, Map<String, EStructuralFeature>>();
    private Map<String, EClassifier> myRenamedTypes = new HashMap<String, EClassifier>();

    static {
        ourDeletedAttribute.setName("attributeIsDeleted");
        ourDeletedAttribute.setEType((EClassifier)EcorePackage.eINSTANCE.getEString());
    }

    public void registerDeletedAttributes(EClassifier classifier, String ... deletedAttrNames) {
        assert (!this.myDeletedAttributes.containsKey(classifier));
        this.myDeletedAttributes.put(classifier, (Collection<String>)Arrays.asList(deletedAttrNames));
    }

    public void registerNarrowReferenceType(EReference reference, EClass concreteType) {
        this.myNarrowReferenceTypes.put(reference, concreteType);
    }

    public void registerRenamedAttributes(EClass eClass, Map<String, EStructuralFeature> renamedAttributes) {
        this.myRenamedAttributes.put(eClass, renamedAttributes);
    }

    public void registerRenamedType(String oldTypeName, EClassifier newType) {
        this.myRenamedTypes.put(oldTypeName, newType);
    }

    public void registerRenamedAttribute(EClass eClass, String oldName, EStructuralFeature newStructuralFeature) {
        Map<String, EStructuralFeature> renamedAttributes = this.myRenamedAttributes.get(eClass);
        if (renamedAttributes == null) {
            renamedAttributes = new HashMap<String, EStructuralFeature>();
        }
        renamedAttributes.put(oldName, newStructuralFeature);
        this.registerRenamedAttributes(eClass, renamedAttributes);
    }

    public boolean isAttributeDeleted(EClass clazz, String name) {
        Collection<String> deletedAttributes = this.myDeletedAttributes.get(clazz);
        boolean result = deletedAttributes != null && deletedAttributes.contains(name);
        Iterator it = clazz.getEAllSuperTypes().iterator();
        while (!result && it.hasNext()) {
            EClass nextParent = (EClass)it.next();
            result = this.isAttributeDeleted(nextParent, name);
        }
        return result;
    }

    public EClass getNarrowReferenceType(EStructuralFeature feature) {
        return this.myNarrowReferenceTypes.get(feature);
    }

    public EStructuralFeature getRenamedFeatureFor(EClass clazz, String name) {
        Map<String, EStructuralFeature> renamings = this.myRenamedAttributes.get(clazz);
        EStructuralFeature result = renamings != null ? renamings.get(name) : null;
        Iterator it = clazz.getEAllSuperTypes().iterator();
        while (result == null && it.hasNext()) {
            EClass nextParent = (EClass)it.next();
            result = this.getRenamedFeatureFor(nextParent, name);
        }
        return result;
    }

    public EClassifier getRenamedType(String typeName) {
        return this.myRenamedTypes.get(typeName);
    }

    @Override
    public EClass getStructuralFeatureType(EStructuralFeature feature) {
        return this.getNarrowReferenceType(feature);
    }

    @Override
    public boolean setValue(EObject object, EStructuralFeature feature, Object value, int position) {
        return ourDeletedAttribute.equals(feature);
    }

    @Override
    public EStructuralFeature getFeature(EClass eClass, String namespaceURI, String name, boolean isElement) {
        EStructuralFeature result = null;
        EStructuralFeature rename = null;
        if (this.isAttributeDeleted(eClass, name)) {
            result = ourDeletedAttribute;
        } else {
            rename = this.getRenamedFeatureFor(eClass, name);
            if (rename != null) {
                result = rename;
            }
        }
        return result;
    }

    @Override
    public EClassifier getType(EFactory factory, String typeName) {
        EClassifier result = null;
        EClassifier type = this.getRenamedType(typeName);
        if (type != null) {
            result = type;
        }
        return result;
    }

    @Override
    public EObject createObject(EFactory factory, EClassifier type) {
        return null;
    }

    @Override
    public void postProcess() {
    }

    @Override
    public void processObject(EObject result) {
    }
}

