/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmf.internal.common.codegen;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.lang.reflect.InvocationTargetException;
import java.net.URI;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.emf.codegen.ecore.Generator;
import org.eclipse.emf.codegen.util.CodeGenUtil;
import org.eclipse.emf.common.util.BasicDiagnostic;
import org.eclipse.emf.common.util.Diagnostic;
import org.eclipse.emf.common.util.DiagnosticException;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.gmf.common.UnexpectedBehaviourException;
import org.eclipse.gmf.common.codegen.ImportAssistant;
import org.eclipse.gmf.internal.common.Activator;
import org.eclipse.gmf.internal.common.codegen.BinaryEmitter;
import org.eclipse.gmf.internal.common.codegen.ImportUtil;
import org.eclipse.gmf.internal.common.codegen.Messages;
import org.eclipse.gmf.internal.common.codegen.OrganizeImportsPostprocessor;
import org.eclipse.gmf.internal.common.codegen.TextEmitter;
import org.eclipse.gmf.internal.common.codegen.TextMerger;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.ToolFactory;
import org.eclipse.jdt.core.formatter.CodeFormatter;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.IDocument;
import org.eclipse.text.edits.TextEdit;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class GeneratorBase
implements Runnable {
    private CodeFormatter myCodeFormatter;
    private OrganizeImportsPostprocessor myImportsPostprocessor;
    private IProgressMonitor myProgress = new NullProgressMonitor();
    private IPackageFragmentRoot myDestRoot;
    private IProject myDestProject;
    private final List<IStatus> myExceptions;
    private IStatus myRunStatus = Status.CANCEL_STATUS;
    private TextMerger myMerger;
    private final boolean isToRestoreExistingImports = true;

    protected abstract void customRun() throws InterruptedException, UnexpectedBehaviourException;

    protected abstract void setupProgressMonitor();

    public GeneratorBase() {
        this.myExceptions = new LinkedList<IStatus>();
    }

    public void run(IProgressMonitor progress) throws InterruptedException {
        this.setProgressMonitor(progress);
        this.clearExceptionsList();
        this.doRun();
    }

    @Override
    public void run() {
        this.clearExceptionsList();
        try {
            this.doRun();
        }
        catch (InterruptedException ex) {
            this.myRunStatus = new Status(8, Activator.getID(), 0, Messages.interrupted, (Throwable)ex);
        }
    }

    public IStatus getRunStatus() {
        return this.myRunStatus;
    }

    public void setProgressMonitor(IProgressMonitor progress) {
        this.myProgress = progress;
    }

    protected final void handleException(CoreException ex) {
        this.handleException(ex.getStatus());
    }

    protected final void handleException(IStatus status) {
        this.myExceptions.add(status);
    }

    protected final void handleException(Throwable ex) {
        if (ex instanceof DiagnosticException) {
            Diagnostic diagnostic = ((DiagnosticException)ex).getDiagnostic();
            if (diagnostic.getException() instanceof InvocationTargetException) {
                Throwable originalEx = ((InvocationTargetException)diagnostic.getException()).getCause();
                this.handleException(GeneratorBase.newStatus(originalEx));
            } else {
                this.handleException(BasicDiagnostic.toIStatus((Diagnostic)diagnostic));
            }
        } else {
            this.handleException(GeneratorBase.newStatus(ex));
        }
    }

    protected void handleUnexpected(UnexpectedBehaviourException ex) {
        this.handleException(ex);
    }

    protected static IStatus newStatus(Throwable ex) {
        return GeneratorBase.newStatus(4, ex);
    }

    protected static IStatus newStatus(int severity, Throwable ex) {
        String msg = ex.getMessage() == null ? ex.getClass().getName() : ex.getMessage();
        return new Status(severity, Activator.getID(), 0, Messages.bind((String)Messages.exception, (Object)msg), ex);
    }

    protected final IProject getDestProject() {
        return this.myDestProject;
    }

    protected final IProgressMonitor getProgress() {
        return this.myProgress;
    }

    protected final void setupProgressMonitor(String task, int total) {
        if (this.myProgress == null) {
            this.myProgress = new NullProgressMonitor();
            return;
        }
        this.myProgress.beginTask(task == null ? Messages.start : task, total);
    }

    protected final IProgressMonitor getNextStepMonitor() throws InterruptedException {
        if (this.myProgress.isCanceled()) {
            throw new InterruptedException();
        }
        return new SubProgressMonitor(this.myProgress, 1);
    }

    protected final void initializeEditorProject(String pluginId, IPath projectLocation) throws UnexpectedBehaviourException, InterruptedException {
        List<IProject> referencedProjects = Collections.emptyList();
        this.initializeEditorProject(pluginId, projectLocation, referencedProjects);
    }

    protected final void initializeEditorProject(String pluginId, IPath projectLocation, List<IProject> referencedProjects) throws UnexpectedBehaviourException, InterruptedException {
        this.myDestProject = ResourcesPlugin.getWorkspace().getRoot().getProject(pluginId);
        Path srcPath = new Path(String.valueOf('/') + this.myDestProject.getName() + "/src");
        int style = Generator.EMF_PLUGIN_PROJECT_STYLE;
        List pluginVariables = null;
        IProgressMonitor pm = this.getNextStepMonitor();
        this.setProgressTaskName(Messages.initproject);
        Generator.createEMFProject((IPath)srcPath, (IPath)projectLocation, referencedProjects, (IProgressMonitor)pm, (int)style, pluginVariables);
        try {
            IJavaProject jp = JavaCore.create((IProject)this.myDestProject);
            this.myDestRoot = jp.findPackageFragmentRoot((IPath)srcPath);
            if (this.myDestRoot == null) {
                IClasspathEntry[] oldCP = jp.getRawClasspath();
                IClasspathEntry[] newCP = new IClasspathEntry[oldCP.length + 1];
                System.arraycopy(oldCP, 0, newCP, 0, oldCP.length);
                newCP[oldCP.length] = JavaCore.newSourceEntry((IPath)srcPath);
                jp.setRawClasspath(newCP, (IProgressMonitor)new NullProgressMonitor());
                this.myDestRoot = jp.findPackageFragmentRoot((IPath)srcPath);
            }
        }
        catch (JavaModelException ex) {
            throw new UnexpectedBehaviourException(ex.getMessage());
        }
        if (this.myDestRoot == null) {
            throw new UnexpectedBehaviourException("no source root can be found");
        }
    }

    /*
     * Exception decompiling
     */
    protected final void doGenerateFile(TextEmitter emitter, IPath filePath, Object ... param) throws InterruptedException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    protected final IPath guessNewProjectLocation(Path examplaryProjectPath, String newProjectName) {
        URI locationURI;
        block12: {
            block11: {
                IProject p;
                block10: {
                    block9: {
                        block8: {
                            assert (newProjectName != null);
                            try {
                                if (!ResourcesPlugin.getWorkspace().getRoot().getProject(newProjectName).exists()) break block8;
                                return null;
                            }
                            catch (CoreException ex) {
                                this.handleException(GeneratorBase.newStatus(2, ex));
                                return null;
                            }
                        }
                        if (examplaryProjectPath != null && examplaryProjectPath.isAbsolute()) break block9;
                        return null;
                    }
                    p = ResourcesPlugin.getWorkspace().getRoot().getProject(examplaryProjectPath.segment(0));
                    if (p.exists()) break block10;
                    return null;
                }
                locationURI = p.getDescription().getLocationURI();
                if (locationURI != null) break block11;
                return null;
            }
            if (locationURI.getScheme() == null || "file".equals(locationURI.getScheme())) break block12;
            return null;
        }
        return new Path(locationURI.getSchemeSpecificPart()).removeLastSegments(1).append(newProjectName);
    }

    protected final ImportAssistant createImportAssistant(String packageName, String className) {
        return new ImportUtil(packageName, className, this.myDestRoot);
    }

    protected final void doGenerateJavaClass(TextEmitter emitter, String qualifiedClassName, Object ... input) throws InterruptedException {
        this.doGenerateJavaClass(emitter, CodeGenUtil.getPackageName((String)qualifiedClassName), CodeGenUtil.getSimpleClassName((String)qualifiedClassName), input);
    }

    /*
     * Exception decompiling
     */
    protected final void doGenerateJavaClass(TextEmitter emitter, String packageName, String className, Object ... input) throws InterruptedException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    protected final void doGenerateBinaryFile(BinaryEmitter emitter, Path outputPath, Object[] params) throws InterruptedException, UnexpectedBehaviourException {
        IProgressMonitor pm = this.getNextStepMonitor();
        this.setProgressTaskName(outputPath.lastSegment());
        IFile f = this.getDestProject().getFile((IPath)outputPath);
        if (f.exists()) {
            return;
        }
        try {
            try {
                pm.beginTask(null, 4);
                IPath containerPath = this.getDestProject().getFullPath().append(outputPath.removeLastSegments(1));
                CodeGenUtil.EclipseUtil.findOrCreateContainer((IPath)containerPath, (boolean)false, null, (IProgressMonitor)new SubProgressMonitor(pm, 1));
                byte[] contents = emitter.generate((IProgressMonitor)new SubProgressMonitor(pm, 1), params);
                f.create((InputStream)new ByteArrayInputStream(contents), true, (IProgressMonitor)new SubProgressMonitor(pm, 1));
                f.getParent().refreshLocal(1, (IProgressMonitor)new SubProgressMonitor(pm, 1));
            }
            catch (InvocationTargetException ex) {
                this.handleException(ex.getCause());
                pm.done();
            }
            catch (CoreException ex) {
                this.handleException(ex);
                pm.done();
            }
        }
        finally {
            pm.done();
        }
    }

    protected String mergeJavaCode(String oldContents, String generatedText, IProgressMonitor pm) throws JavaModelException {
        pm.beginTask(Messages.merge, 1);
        try {
            String string = this.getMergeService().mergeJava(oldContents, generatedText);
            return string;
        }
        finally {
            pm.done();
        }
    }

    protected String mergePlainText(String oldText, String genText, IFile oldRes, IProgressMonitor pm) {
        pm.beginTask(Messages.merge, 1);
        try {
            String string = this.getMergeService().process(oldRes.getFileExtension(), oldText, genText);
            return string;
        }
        finally {
            pm.done();
        }
    }

    private TextMerger getMergeService() {
        if (this.myMerger == null) {
            this.myMerger = this.createMergeService();
            assert (this.myMerger != null);
        }
        return this.myMerger;
    }

    protected TextMerger createMergeService() {
        return new TextMerger();
    }

    protected void setProgressTaskName(String text) {
        this.myProgress.subTask(text);
    }

    protected final String formatCode(String text) {
        Document doc = new Document(text);
        TextEdit edit = this.getCodeFormatter().format(8, doc.get(), 0, doc.get().length(), 0, null);
        try {
            if (edit != null) {
                edit.apply((IDocument)doc);
                text = doc.get();
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return text;
    }

    private void doRun() throws InterruptedException {
        try {
            try {
                this.setupProgressMonitor();
                ResourcesPlugin.getWorkspace().run(new IWorkspaceRunnable(){

                    public void run(IProgressMonitor monitor) throws CoreException {
                        try {
                            GeneratorBase.this.customRun();
                            GeneratorBase.this.myRunStatus = GeneratorBase.this.getExceptionsStatus();
                        }
                        catch (NullPointerException ex) {
                            GeneratorBase.this.myRunStatus = (IStatus)new Status(4, Activator.getID(), 0, NullPointerException.class.getName(), (Throwable)ex);
                        }
                        catch (UnexpectedBehaviourException ex) {
                            GeneratorBase.this.myRunStatus = (IStatus)new Status(4, Activator.getID(), 0, Messages.unexpected, (Throwable)ex);
                        }
                        catch (InterruptedException ex) {
                            GeneratorBase.this.myRunStatus = (IStatus)new Status(8, Activator.getID(), 0, Messages.interrupted, (Throwable)ex);
                        }
                    }
                }, null);
                if (this.myRunStatus.getSeverity() == 8 && this.myRunStatus.getException() instanceof InterruptedException) {
                    throw (InterruptedException)this.myRunStatus.getException();
                }
            }
            catch (CoreException ex) {
                this.myRunStatus = ex.getStatus();
                this.getProgress().done();
                this.clearExceptionsList();
            }
        }
        finally {
            this.getProgress().done();
            this.clearExceptionsList();
        }
    }

    private CodeFormatter getCodeFormatter() {
        if (this.myCodeFormatter == null) {
            this.myCodeFormatter = ToolFactory.createCodeFormatter(null);
        }
        return this.myCodeFormatter;
    }

    private OrganizeImportsPostprocessor getImportsPostrocessor() {
        if (this.myImportsPostprocessor == null) {
            this.myImportsPostprocessor = new OrganizeImportsPostprocessor(true);
        }
        return this.myImportsPostprocessor;
    }

    private final void clearExceptionsList() {
        this.myExceptions.clear();
    }

    private final IStatus getExceptionsStatus() {
        if (this.myExceptions == null || this.myExceptions.isEmpty()) {
            return Status.OK_STATUS;
        }
        IStatus[] s = this.myExceptions.toArray(new IStatus[this.myExceptions.size()]);
        return new MultiStatus(Activator.getID(), 0, s, Messages.problems, null);
    }

    protected static final class Counter {
        private final HashMap<EClass, Integer> myCounters = new HashMap();
        private final HashMap<EClass, Integer> myCache = new HashMap();
        private final Integer CACHE_MISS = new Integer(0);

        public void registerFactor(EClass eClass, int count) {
            this.myCounters.put(eClass, count);
        }

        public int getTotal(EObject from) {
            int total = this.process(from);
            TreeIterator it = from.eAllContents();
            while (it.hasNext()) {
                total += this.process((EObject)it.next());
            }
            return total;
        }

        protected int process(EObject next) {
            EClass nextKey = next.eClass();
            Integer cachedValue = this.checkCached(nextKey);
            if (cachedValue != null) {
                return cachedValue;
            }
            LinkedList<EClass> checkQueue = new LinkedList<EClass>();
            checkQueue.add(nextKey);
            do {
                EClass key;
                if (this.myCounters.containsKey(key = (EClass)checkQueue.removeFirst())) {
                    Integer value = this.myCounters.get(key);
                    this.cache(nextKey, value);
                    return value;
                }
                checkQueue.addAll((Collection<EClass>)key.getESuperTypes());
            } while (!checkQueue.isEmpty());
            this.cache(nextKey, this.CACHE_MISS);
            return 0;
        }

        private Integer checkCached(EClass nextKey) {
            return this.myCache.get(nextKey);
        }

        private void cache(EClass nextKey, Integer value) {
            this.myCache.put(nextKey, value);
        }
    }
}

